/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.config.miniparser;

import com.bes.enterprise.config.miniparser.ConfigBindingException;
import com.bes.enterprise.config.miniparser.DomTemplate;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class DomParserContext {
    private final Set<String> includePaths = new HashSet<String>();
    private final LinkedList<DomTemplateHandler> domTemplateHandlers = new LinkedList();
    private final Map<String, Map<String, AttributeConfig>> allAttributeConfigs = new HashMap<String, Map<String, AttributeConfig>>();

    public DomParserContext addIncludePaths(String navigatorPath) {
        navigatorPath = this.removeLeadingSlash(navigatorPath);
        this.includePaths.add(navigatorPath);
        return this;
    }

    public Set<String> getIncludePaths() {
        return this.includePaths;
    }

    public boolean includePath(String navigatorPath) {
        if (this.includePaths.isEmpty()) {
            return true;
        }
        return this.includePaths.contains(navigatorPath);
    }

    public DomParserContext addDomTemplateHandlers(DomTemplateHandler handler) {
        if (!this.domTemplateHandlers.contains(handler)) {
            this.domTemplateHandlers.add(handler);
        }
        return this;
    }

    public LinkedList<DomTemplateHandler> getDomTemplateHandlers() {
        return this.domTemplateHandlers;
    }

    public DomParserContext addAttributeConfig(String navigatorPath, AttributeConfig attributeConfig) {
        Map<String, AttributeConfig> elementAttrConfigs = this.allAttributeConfigs.get(navigatorPath = this.removeLeadingSlash(navigatorPath));
        if (elementAttrConfigs == null) {
            elementAttrConfigs = new HashMap<String, AttributeConfig>();
            this.allAttributeConfigs.put(navigatorPath, elementAttrConfigs);
        }
        elementAttrConfigs.put(attributeConfig.name(), attributeConfig);
        return this;
    }

    public Map<String, AttributeConfig> getAttributeConfigs(String navigatorPath) {
        Map<String, AttributeConfig> elementAttrConfigs = this.allAttributeConfigs.get(navigatorPath = this.removeLeadingSlash(navigatorPath));
        if (elementAttrConfigs != null) {
            return elementAttrConfigs;
        }
        return Collections.emptyMap();
    }

    public void postFillAttributes(String navigatorPath, DomTemplate domTemplate) {
        Map<String, AttributeConfig> attrConfigs = this.allAttributeConfigs.get(navigatorPath);
        String elmentName = domTemplate.getTagName();
        if (attrConfigs == null) {
            attrConfigs = this.allAttributeConfigs.get(elmentName);
        }
        Map<String, String> domAttributes = domTemplate.getAllAttributes();
        if (attrConfigs != null && !attrConfigs.isEmpty()) {
            for (AttributeConfig config : attrConfigs.values()) {
                String attrName = config.name();
                if (!domAttributes.containsKey(attrName)) {
                    if (config.defaultValue() != null) {
                        domTemplate.setAttribute(attrName, config.defaultValue());
                    } else if (config.required()) {
                        throw new ConfigBindingException("Attribute " + attrName + " of element " + elmentName + " is required!");
                    }
                }
                if (!config.encrypted()) continue;
                domTemplate.markEncryptedAttribute(attrName);
            }
        }
    }

    public void postFillElements(String navigatorPath, DomTemplate domTemplate) {
        if (!this.domTemplateHandlers.isEmpty()) {
            for (DomTemplateHandler handler : this.domTemplateHandlers) {
                if (!handler.matches(navigatorPath, domTemplate)) continue;
                handler.hanlde(navigatorPath, domTemplate);
            }
        }
    }

    private String removeLeadingSlash(String navigatorPath) {
        if (navigatorPath.startsWith("/")) {
            navigatorPath = navigatorPath.substring(1);
        }
        return navigatorPath;
    }

    public static class PasswordEncryptedHandler
    implements DomTemplateHandler {
        @Override
        public boolean matches(String naviagtorPath, DomTemplate domTemplate) {
            if ("property".equals(domTemplate.getTagName()) && "password".equals(domTemplate.getAttribute("name"))) {
                return true;
            }
            return domTemplate.hasAttribute("password");
        }

        @Override
        public void hanlde(String naviagtorPath, DomTemplate domTemplate) {
            if ("property".equals(domTemplate.getTagName())) {
                domTemplate.markEncryptedAttribute("value");
            }
            if (domTemplate.hasAttribute("password")) {
                domTemplate.markEncryptedAttribute("password");
            }
        }
    }

    public static interface DomTemplateHandler {
        public boolean matches(String var1, DomTemplate var2);

        public void hanlde(String var1, DomTemplate var2);
    }

    public static class AttributeConfig {
        private String name;
        private boolean required;
        private boolean encrypted;
        private String defaultValue;

        public String name() {
            return this.name;
        }

        public AttributeConfig name(String name) {
            this.name = name;
            return this;
        }

        public boolean required() {
            return this.required;
        }

        public AttributeConfig required(boolean required) {
            if (this.defaultValue != null) {
                throw new ConfigBindingException("The attribute has default value, should not mark as required!");
            }
            this.required = required;
            return this;
        }

        public boolean encrypted() {
            return this.encrypted;
        }

        public AttributeConfig encrypted(boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public String defaultValue() {
            return this.defaultValue;
        }

        public AttributeConfig defaultValue(String defaultValue) {
            if (this.required) {
                throw new ConfigBindingException("Required attribute should not have default value!");
            }
            this.defaultValue = defaultValue;
            return this;
        }
    }
}

