/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.config.miniparser;

import com.bes.enterprise.config.miniparser.ConfigBeanPath;
import com.bes.enterprise.config.miniparser.ConfigBindingException;
import com.bes.enterprise.config.provider.CipherAlgorithmProviderFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class DomTemplate {
    private String tagName;
    private String keyAttributeName;
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();
    private final List<String> persistenceAttributes = new ArrayList<String>();
    private final Set<String> encryptedAttributes = new HashSet<String>();
    private final Set<String> needEncryptedAttributes = new HashSet<String>();
    private String elementText;
    private boolean encryptedElementText;
    private final Map<String, List<DomTemplate>> children = new LinkedHashMap<String, List<DomTemplate>>();
    private static CipherAlgorithmProviderFactory cipherAlgorithmProviderFactory = CipherAlgorithmProviderFactory.getInstance();

    public DomTemplate() {
    }

    public DomTemplate(DomTemplate source) {
        HashMap newChildren = new HashMap();
        for (Map.Entry entry : newChildren.entrySet()) {
            String key = (String)entry.getKey();
            List oldModels = (List)entry.getValue();
            ArrayList<DomTemplate> newModels = new ArrayList<DomTemplate>();
            for (DomTemplate model : oldModels) {
                newModels.add(model.deepCopy());
            }
            newChildren.put(key, newModels);
        }
        this.tagName = source.tagName;
        this.keyAttributeName = source.keyAttributeName;
        this.elementText = source.elementText;
        this.children.putAll(newChildren);
        this.attributes.putAll(source.attributes);
    }

    public DomTemplate deepCopy() {
        DomTemplate newDom = new DomTemplate();
        newDom.attributes.putAll(this.attributes);
        HashMap newChildren = new HashMap();
        for (Map.Entry entry : newChildren.entrySet()) {
            String key = (String)entry.getKey();
            List oldModels = (List)entry.getValue();
            ArrayList<DomTemplate> newModels = new ArrayList<DomTemplate>();
            for (DomTemplate model : oldModels) {
                newModels.add(model.deepCopy());
            }
            newChildren.put(key, newModels);
        }
        newDom.tagName = this.tagName;
        newDom.keyAttributeName = this.keyAttributeName;
        newDom.elementText = this.elementText;
        newDom.children.putAll(newChildren);
        return newDom;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public String getKeyAttribute() {
        return this.keyAttributeName;
    }

    public boolean hasAttribute(String attributeName) {
        return this.attributes.containsKey(attributeName);
    }

    public String getAttribute(String attributeName) {
        String value = this.attributes.get(attributeName);
        try {
            if (cipherAlgorithmProviderFactory.isCipherText(value)) {
                value = cipherAlgorithmProviderFactory.decrypt(value);
            }
        }
        catch (Exception e2) {
            throw new ConfigBindingException(String.format("Failure to decrypt attribute %s of element %s.", attributeName, this.tagName));
        }
        this.attributes.put(attributeName, value);
        return value;
    }

    public void setAttribute(String attributeName, String value) {
        if ("\u0000".equals(value)) {
            value = null;
        }
        this.attributes.put(attributeName, value);
    }

    public void markEncryptedAttribute(String attributeName) {
        this.encryptedAttributes.add(attributeName);
    }

    public void markNeedEncryptedAttribute(String attributeName) {
        this.needEncryptedAttributes.add(attributeName);
    }

    public boolean isEncryptedAttribute(String attributeName) {
        return this.encryptedAttributes.contains(attributeName);
    }

    public boolean isEncryptedElementText() {
        return this.encryptedElementText;
    }

    public boolean needEncryptedAttribute(String attributeName) {
        return this.needEncryptedAttributes.contains(attributeName);
    }

    public void setEncryptedElementText(boolean encryptedElementText) {
        this.encryptedElementText = encryptedElementText;
    }

    public void markPersistenceAttribute(String attributeName) {
        if (!this.persistenceAttributes.contains(attributeName)) {
            this.persistenceAttributes.add(attributeName);
        }
    }

    public boolean isMarkedPersistenceAttribute(String attributeName) {
        return this.persistenceAttributes.contains(attributeName);
    }

    public void removeAttribute(String attributeName) {
        this.persistenceAttributes.remove(attributeName);
    }

    public void removeAttributes(List<String> attributeNames) {
        for (String attributeName : attributeNames) {
            this.removeAttribute(attributeName);
        }
    }

    public String getElementText() {
        try {
            if (cipherAlgorithmProviderFactory.isCipherText(this.elementText)) {
                this.elementText = cipherAlgorithmProviderFactory.decrypt(this.elementText);
            }
        }
        catch (Exception e2) {
            throw new ConfigBindingException(String.format("Failure to decrypt text  %s of element %s.", this.elementText, this.tagName));
        }
        return this.elementText;
    }

    public void setElementText(String elementText) {
        this.elementText = elementText;
    }

    public Map<String, String> getAllAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void setAllAttributes(Map<String, String> allAttributes) {
        this.attributes.clear();
        this.attributes.putAll(allAttributes);
    }

    public List<String> getAllAttributeNames() {
        Set<String> attributeNameSet = this.attributes.keySet();
        ArrayList<String> attributeNameList = new ArrayList<String>(attributeNameSet);
        return Collections.unmodifiableList(attributeNameList);
    }

    public void addElement(String elementName, DomTemplate model) {
        if (model == null) {
            return;
        }
        List<DomTemplate> childDomModels = this.children.get(elementName);
        if (childDomModels == null) {
            childDomModels = new ArrayList<DomTemplate>();
            this.children.put(elementName, childDomModels);
        }
        childDomModels.add(model);
    }

    public void addElements(String elementName, List<DomTemplate> childDomModels) {
        if (childDomModels == null || childDomModels.isEmpty()) {
            return;
        }
        List<DomTemplate> domModels = this.children.get(elementName);
        if (domModels == null) {
            domModels = new ArrayList<DomTemplate>();
            this.children.put(elementName, domModels);
        }
        domModels.addAll(childDomModels);
    }

    public List<DomTemplate> getElements(String elementName) {
        List<DomTemplate> childDomModels = this.children.get(elementName);
        if (childDomModels == null) {
            childDomModels = Collections.emptyList();
        }
        return childDomModels;
    }

    public DomTemplate getElement(String elementName) {
        List<DomTemplate> childDomModels = this.getElements(elementName);
        if (childDomModels != null && childDomModels.size() > 0) {
            return childDomModels.get(0);
        }
        return null;
    }

    public void removeElements(String elementName) {
        List<DomTemplate> childDomModels = this.children.get(elementName);
        if (childDomModels != null) {
            childDomModels.clear();
        }
        this.children.remove(elementName);
    }

    public List<String> getAllElementNames() {
        Set<String> elementNameSet = this.children.keySet();
        ArrayList<String> elementNameList = new ArrayList<String>(elementNameSet);
        return Collections.unmodifiableList(elementNameList);
    }

    public String getAttributeByPath(ConfigBeanPath configBeanPath, String attributeName) {
        DomTemplate domTemplate = this.locate(configBeanPath);
        if (domTemplate != null) {
            return domTemplate.getAttribute(attributeName);
        }
        return null;
    }

    public void setAttributeByPath(ConfigBeanPath configBeanPath, String attributeName, String attributeValue) {
        DomTemplate domTemplate = this.locate(configBeanPath);
        if (domTemplate != null) {
            domTemplate.setAttribute(attributeName, attributeValue);
        }
    }

    public Map<String, String> getAllAttributesByPath(ConfigBeanPath configBeanPath) {
        DomTemplate domTemplate = this.locate(configBeanPath);
        if (domTemplate != null) {
            return domTemplate.getAllAttributes();
        }
        return Collections.EMPTY_MAP;
    }

    public void setAllAttributesByPath(ConfigBeanPath configBeanPath, Map<String, String> attributes) {
        DomTemplate domTemplate = this.locate(configBeanPath);
        if (domTemplate != null) {
            domTemplate.setAllAttributes(attributes);
        }
    }

    public DomTemplate getElementByPath(ConfigBeanPath configBeanPath) {
        DomTemplate domTemplate = this.locate(configBeanPath);
        return domTemplate;
    }

    public void setElementByPath(ConfigBeanPath configBeanPath, DomTemplate domTemplate) {
        String element = configBeanPath.getElementName();
        ConfigBeanPath parent = configBeanPath.getParentPath();
        if (parent == null) {
            throw new ConfigBindingException(String.format("Could not substitute root element at path %s.", configBeanPath.getFullPath()));
        }
        DomTemplate parentDomTemplate = this.locate(parent);
        if (parentDomTemplate != null) {
            parentDomTemplate.addElement(element, domTemplate);
        }
    }

    public List<DomTemplate> getElementsByPath(ConfigBeanPath configBeanPath) {
        String element = configBeanPath.getElementName();
        ConfigBeanPath parent = configBeanPath.getParentPath();
        if (parent == null) {
            throw new ConfigBindingException(String.format("Could not substitute root element at path %s.", configBeanPath.getFullPath()));
        }
        DomTemplate parentDomTemplate = this.locate(parent);
        if (parentDomTemplate != null) {
            parentDomTemplate.removeElements(element);
            return parentDomTemplate.getElements(element);
        }
        return Collections.EMPTY_LIST;
    }

    public void setElementsByPath(ConfigBeanPath configBeanPath, List<DomTemplate> domTemplates) {
        String element = configBeanPath.getElementName();
        ConfigBeanPath parent = configBeanPath.getParentPath();
        if (parent == null) {
            throw new ConfigBindingException(String.format("Could not substitute root element at path %s.", configBeanPath.getFullPath()));
        }
        DomTemplate parentDomTemplate = this.locate(parent);
        if (parentDomTemplate != null) {
            parentDomTemplate.removeElements(element);
            parentDomTemplate.addElements(element, domTemplates);
        }
    }

    private DomTemplate locate(ConfigBeanPath configBeanPath) {
        return DomTemplate.locate(configBeanPath, this);
    }

    private static DomTemplate locate(ConfigBeanPath configBeanPath, DomTemplate rootDomTemplate) {
        String rootPath;
        String fullPath = configBeanPath.getFullPath();
        if (fullPath.startsWith("/")) {
            fullPath = fullPath.substring("/".length());
        }
        if (fullPath.equals(rootPath = configBeanPath.getRootPath())) {
            return rootDomTemplate;
        }
        List<String> elementPaths = ConfigBeanPath.splitPath(fullPath);
        DomTemplate resultDomTemplate = rootDomTemplate;
        for (String complicatedPath : elementPaths) {
            try {
                DomTemplate childDomTemplate = DomTemplate.locateChildConfigBean(resultDomTemplate, complicatedPath);
                if (childDomTemplate == null) {
                    throw new ConfigBindingException(String.format("Could not locate config bean for %s, config bean related to path %s does not exist.", fullPath, complicatedPath));
                }
                resultDomTemplate = childDomTemplate;
            }
            catch (IllegalArgumentException ex) {
                throw new ConfigBindingException(String.format("Could not locate config bean for %s, meta data of config bean related to path %s is not correct.", fullPath, complicatedPath), ex);
            }
        }
        return resultDomTemplate;
    }

    private static DomTemplate locateChildConfigBean(DomTemplate parentDomTemplate, String complicatedPath) {
        String element = ConfigBeanPath.getElementInPath(complicatedPath);
        List<DomTemplate> domTemplates = parentDomTemplate.getElements(element);
        String keyAttributeName = ConfigBeanPath.getAttributeNameInPath(complicatedPath);
        String keyAttributeValue = ConfigBeanPath.getAttributeValueInPath(complicatedPath);
        if (keyAttributeName != null && keyAttributeValue != null) {
            for (DomTemplate item : domTemplates) {
                String itemKeyAttributeValue = item.getAttribute(keyAttributeName);
                if (!keyAttributeValue.equals(itemKeyAttributeValue)) continue;
                return item;
            }
            return null;
        }
        if (domTemplates.size() == 1) {
            return domTemplates.get(0);
        }
        if (domTemplates.size() > 1) {
            throw new ConfigBindingException(String.format("Child element %s of %s is a collection element.", element, parentDomTemplate.getTagName()));
        }
        return null;
    }

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(this.tagName);
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            String attributeName = entry.getKey();
            String attributeValue = entry.getValue();
            if (this.needEncryptedAttribute(attributeName) || this.isEncryptedAttribute(attributeName)) {
                try {
                    attributeValue = cipherAlgorithmProviderFactory.encrypt(attributeValue);
                }
                catch (Exception ex) {
                    throw new ConfigBindingException(String.format("Failure to persistent attribute <%s>.", attributeName), ex);
                }
            }
            writer.writeAttribute(attributeName, attributeValue);
        }
        if (this.elementText != null && !this.elementText.matches("\\s*")) {
            if (this.encryptedElementText) {
                try {
                    this.elementText = cipherAlgorithmProviderFactory.encrypt(this.elementText);
                }
                catch (Exception ex) {
                    throw new ConfigBindingException(String.format("Failure to encrypted text for element  <%s>.", this.tagName), ex);
                }
            }
            writer.writeComment(this.elementText);
            writer.writeEndElement();
            return;
        }
        for (Map.Entry<String, Object> entry : this.children.entrySet()) {
            List brotherChildElments = (List)entry.getValue();
            for (DomTemplate childDomTemplate : brotherChildElments) {
                childDomTemplate.write(writer);
            }
        }
        writer.writeEndElement();
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + Objects.hashCode(this.tagName);
        hash = 43 * hash + Objects.hashCode(this.keyAttributeName);
        hash = 43 * hash + Objects.hashCode(this.attributes);
        hash = 43 * hash + Objects.hashCode(this.elementText);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DomTemplate other = (DomTemplate)obj;
        if (!Objects.equals(this.tagName, other.tagName)) {
            return false;
        }
        if (!Objects.equals(this.keyAttributeName, other.keyAttributeName)) {
            return false;
        }
        if (!Objects.equals(this.attributes, other.attributes)) {
            return false;
        }
        return Objects.equals(this.elementText, other.elementText);
    }

    public static void persistence(XMLStreamWriter writer, DomTemplate domTemplate) {
        String rootElementName = domTemplate.getTagName();
        try {
            writer.writeStartDocument("UTF-8", "1.0");
            domTemplate.write(writer);
            writer.writeEndDocument();
        }
        catch (XMLStreamException streamEx) {
            throw new ConfigBindingException(String.format("Failure to persistent element <%s>.", rootElementName), streamEx);
        }
    }
}

