/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.config.miniparser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SystemPropertyValueTranslator {
    private static final Pattern variablePattern = Pattern.compile("(\\$\\{)([^\\}]*)(\\})");
    private static final SystemPropertyValueTranslator instance = new SystemPropertyValueTranslator();

    public static SystemPropertyValueTranslator getInstance() {
        return instance;
    }

    public boolean isVariable(String value) {
        int endIndex;
        if (value == null) {
            return false;
        }
        int beginIndex = value.indexOf("${");
        return beginIndex != -1 && (endIndex = value.indexOf("}")) != -1 && endIndex > beginIndex + 1;
    }

    public String getTranslatedValue(String value) {
        if (!this.isVariable(value)) {
            return value;
        }
        Matcher macher = variablePattern.matcher(value);
        StringBuffer buffer = new StringBuffer();
        int lastEnd = 0;
        while (macher.find()) {
            int start = macher.start();
            int end = macher.end();
            String newValue = System.getProperty(macher.group(2).trim());
            if (newValue == null) {
                newValue = macher.group(0);
            }
            buffer.append(value.substring(lastEnd, start));
            buffer.append(newValue);
            lastEnd = end;
        }
        if (lastEnd != value.length()) {
            buffer.append(value.substring(lastEnd, value.length()));
        }
        return buffer.toString();
    }
}

