/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.config.provider;

import com.bes.enterprise.appserver.common.util.SPIUtils;
import com.bes.enterprise.appserver.common.util.StringUtils;
import com.bes.enterprise.config.provider.CipherAlgorithmProvider;
import com.bes.enterprise.config.provider.DefaultCipherAlgorithmProviderImpl;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CipherAlgorithmProviderFactory {
    private Logger logger = null;
    private static final String EXTENT_CIPHER_ALGO_PROVIDER_CLASS_NAME = System.getProperty("com.bes.enterprise.cipher.algorithm.className");
    private static final String EXTENT_CIPHER_ALGO_PROVIDER_ENCRYPT_METHOD_NAME = System.getProperty("com.bes.enterprise.cipher.algorithm.encryptMethod");
    private static final String EXTENT_CIPHER_ALGO_PROVIDER_DECRYPT_METHOD_NAME = System.getProperty("com.bes.enterprise.cipher.algorithm.decryptMethod");
    private static final String EXT_TAG = "{EXT}";
    private CipherAlgorithmProvider cipherAlgorithmProvider = null;
    private static CipherAlgorithmProviderFactory factory = null;
    private boolean initialized = false;

    public static CipherAlgorithmProviderFactory getInstance() {
        if (factory == null) {
            factory = new CipherAlgorithmProviderFactory();
        }
        return factory;
    }

    public String encrypt(String context) throws Exception {
        CipherAlgorithmProvider provider = this.getCipherAlgorithmProvider();
        return provider.encrypt(context);
    }

    public String decrypt(String cipherText) throws Exception {
        CipherAlgorithmProvider provider = this.getCipherAlgorithmProvider();
        return provider.decrypt(cipherText);
    }

    public boolean isCipherText(String cipherText) throws Exception {
        return this.getCipherAlgorithmProvider().isCipherText(cipherText);
    }

    private void init() throws Exception {
        if (this.isNotImplementInterface()) {
            this.cipherAlgorithmProvider = this.getCipherAlgorithmProviderWrapper();
            this.initialized = true;
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String cipherAlgorithmProviderName = SPIUtils.findServiceProvider(CipherAlgorithmProvider.class.getCanonicalName(), classLoader);
        if (StringUtils.ok(cipherAlgorithmProviderName)) {
            try {
                this.cipherAlgorithmProvider = (CipherAlgorithmProvider)classLoader.loadClass(cipherAlgorithmProviderName).newInstance();
            }
            catch (Exception e2) {
                if (this.getLogger().isLoggable(Level.SEVERE)) {
                    this.getLogger().log(Level.SEVERE, "Failed to construct instance of CipherAlgorithmProvider.", e2);
                }
                throw e2;
            }
        } else {
            this.cipherAlgorithmProvider = new DefaultCipherAlgorithmProviderImpl();
        }
        this.initialized = true;
    }

    private CipherAlgorithmProvider getCipherAlgorithmProvider() throws Exception {
        if (!this.initialized) {
            this.init();
        }
        return this.cipherAlgorithmProvider;
    }

    private CipherAlgorithmProvider getCipherAlgorithmProviderWrapper() throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> decryptClass = classLoader.loadClass(EXTENT_CIPHER_ALGO_PROVIDER_CLASS_NAME);
        final Object delegate = decryptClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        final Method encryptMethod = decryptClass.getMethod(EXTENT_CIPHER_ALGO_PROVIDER_ENCRYPT_METHOD_NAME, String.class);
        final Method decryptMethod = decryptClass.getMethod(EXTENT_CIPHER_ALGO_PROVIDER_DECRYPT_METHOD_NAME, String.class);
        return new CipherAlgorithmProvider(){

            @Override
            public String encrypt(String context) throws Exception {
                return encryptMethod.invoke(delegate, context.substring(CipherAlgorithmProviderFactory.EXT_TAG.length())).toString();
            }

            @Override
            public String decrypt(String cipherText) throws Exception {
                return decryptMethod.invoke(delegate, cipherText.substring(CipherAlgorithmProviderFactory.EXT_TAG.length())).toString();
            }

            @Override
            public boolean isCipherText(String cipherText) {
                return cipherText != null && cipherText.startsWith(CipherAlgorithmProviderFactory.EXT_TAG);
            }
        };
    }

    private boolean isNotImplementInterface() {
        boolean ok = StringUtils.ok(EXTENT_CIPHER_ALGO_PROVIDER_CLASS_NAME) && StringUtils.ok(EXTENT_CIPHER_ALGO_PROVIDER_ENCRYPT_METHOD_NAME) && StringUtils.ok(EXTENT_CIPHER_ALGO_PROVIDER_ENCRYPT_METHOD_NAME);
        return ok;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger("javax.enterprise.system.util");
        }
        return this.logger;
    }
}

