/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gmssl.adapter;

import com.bes.enterprise.gmssl.GMKeyStore;
import com.bes.enterprise.gmssl.adapter.GMSSLContext;
import com.bes.enterprise.gmssl.adapter.PEMFile;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.file.ConfigFileLoader;
import com.bes.enterprise.web.util.net.SSLContext;
import com.bes.enterprise.web.util.net.SSLHostConfig;
import com.bes.enterprise.web.util.net.SSLHostConfigCertificate;
import com.bes.enterprise.web.util.net.SSLUtil;
import com.bes.enterprise.web.util.net.jsse.JSSEKeyManager;
import com.bes.enterprise.web.util.res.StringManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;

public class GMSSLUtil
implements SSLUtil {
    protected final SSLHostConfigCertificate certificate;
    private final SSLHostConfig sslHostConfig;
    private static final Log log = LogFactory.getLog(GMSSLUtil.class);
    private static final StringManager sm = StringManager.getManager(GMSSLUtil.class);

    public GMSSLUtil(SSLHostConfigCertificate certificate) {
        this.certificate = certificate;
        this.sslHostConfig = this.certificate.getSSLHostConfig();
    }

    @Override
    public SSLContext createSSLContext(List<String> negotiableProtocols) throws Exception {
        GMSSLContext sslContext = new GMSSLContext();
        sslContext.init(this.getKeyManagers(), this.getTrustManagers(), null);
        return sslContext;
    }

    @Override
    public KeyManager[] getKeyManagers() throws Exception {
        KeyStore ks;
        String keyAlias = this.certificate.getCertificateKeyAlias();
        String algorithm = this.sslHostConfig.getKeyManagerAlgorithm();
        String keyPass = this.certificate.getCertificateKeyPassword();
        if (keyPass == null) {
            keyPass = this.certificate.getCertificateKeystorePassword();
        }
        KeyStore ksUsed = ks = GMSSLUtil.getStore(this.certificate.getCertificateKeystoreType(), null, this.certificate.getCertificateKeystoreFile(), this.certificate.getCertificateKeystorePassword());
        char[] keyPassArray = keyPass.toCharArray();
        if (ks == null) {
            if (this.certificate.getCertificateFile() == null) {
                throw new IOException(sm.getString("jsse.noCertFile"));
            }
            PEMFile privateKeyFile = new PEMFile(SSLHostConfig.adjustRelativePath(this.certificate.getCertificateKeyFile() != null ? this.certificate.getCertificateKeyFile() : this.certificate.getCertificateFile()), keyPass);
            PEMFile certificateFile = new PEMFile(SSLHostConfig.adjustRelativePath(this.certificate.getCertificateFile()));
            ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
            chain.addAll(certificateFile.getCertificates());
            if (this.certificate.getCertificateChainFile() != null) {
                PEMFile certificateChainFile = new PEMFile(SSLHostConfig.adjustRelativePath(this.certificate.getCertificateChainFile()));
                chain.addAll(certificateChainFile.getCertificates());
            }
            if (keyAlias == null) {
                keyAlias = "bes";
            }
            ksUsed = GMSSLUtil.getStore("bks", null);
            ksUsed.load(null, null);
            ksUsed.setKeyEntry(keyAlias, privateKeyFile.getPrivateKey(), keyPass.toCharArray(), chain.toArray(new Certificate[chain.size()]));
        } else {
            Key k2;
            if (keyAlias != null && !ks.isKeyEntry(keyAlias)) {
                throw new IOException(sm.getString("jsse.alias_no_key_entry", keyAlias));
            }
            if (keyAlias == null) {
                Enumeration<String> aliases = ks.aliases();
                if (!aliases.hasMoreElements()) {
                    throw new IOException(sm.getString("jsse.noKeys"));
                }
                while (aliases.hasMoreElements() && keyAlias == null) {
                    keyAlias = aliases.nextElement();
                    if (ks.isKeyEntry(keyAlias)) continue;
                    keyAlias = null;
                }
                if (keyAlias == null) {
                    throw new IOException(sm.getString("jsse.alias_no_key_entry", new Object[]{null}));
                }
            }
            if ((k2 = ks.getKey(keyAlias, keyPassArray)) != null && "PKCS#8".equalsIgnoreCase(k2.getFormat())) {
                String provider = this.certificate.getCertificateKeystoreProvider();
                ksUsed = provider == null ? GMSSLUtil.getStore(this.certificate.getCertificateKeystoreType(), null) : GMSSLUtil.getStore(this.certificate.getCertificateKeystoreType(), provider);
                ksUsed.load(null, null);
                ksUsed.setKeyEntry(keyAlias, k2, keyPassArray, ks.getCertificateChain(keyAlias));
            }
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(ksUsed, keyPassArray);
        KeyManager[] kms = kmf.getKeyManagers();
        if (kms != null && ksUsed == ks) {
            String alias = keyAlias;
            if ("JKS".equals(this.certificate.getCertificateKeystoreType())) {
                alias = alias.toLowerCase(Locale.ENGLISH);
            }
            for (int i2 = 0; i2 < kms.length; ++i2) {
                kms[i2] = new JSSEKeyManager((X509KeyManager)kms[i2], alias);
            }
        }
        return kms;
    }

    @Override
    public TrustManager[] getTrustManagers() throws Exception {
        if (this.sslHostConfig.getCertificateVerification().equals((Object)SSLHostConfig.CertificateVerification.NONE)) {
            return new TrustManager[0];
        }
        String className = this.sslHostConfig.getTrustManagerClassName();
        if (className != null && className.length() > 0) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class<?> clazz = classLoader.loadClass(className);
            if (!TrustManager.class.isAssignableFrom(clazz)) {
                throw new InstantiationException(sm.getString("jsse.invalidTrustManagerClassName", className));
            }
            Object trustManagerObject = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            TrustManager trustManager = (TrustManager)trustManagerObject;
            return new TrustManager[]{trustManager};
        }
        TrustManager[] tms = null;
        String trustStoreType = this.sslHostConfig.getTruststoreType();
        KeyStore trustStore = GMSSLUtil.getStore(trustStoreType, null, this.sslHostConfig.getTruststoreFile(), this.sslHostConfig.getTruststorePassword());
        if (trustStore != null) {
            this.checkTrustStoreEntries(trustStore);
            String algorithm = this.sslHostConfig.getTruststoreAlgorithm();
            String crlf = this.sslHostConfig.getCertificateRevocationListFile();
            boolean revocationEnabled = this.sslHostConfig.getRevocationEnabled();
            if ("PKIX".equalsIgnoreCase(algorithm)) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                CertPathParameters params = this.getParameters(crlf, trustStore, revocationEnabled);
                CertPathTrustManagerParameters mfp = new CertPathTrustManagerParameters(params);
                tmf.init(mfp);
                tms = tmf.getTrustManagers();
            } else {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                tmf.init(trustStore);
                tms = tmf.getTrustManagers();
                if (crlf != null && crlf.length() > 0) {
                    throw new CRLException(sm.getString("jsseUtil.noCrlSupport", algorithm));
                }
                if (this.sslHostConfig.isCertificateVerificationDepthConfigured()) {
                    log.warn(sm.getString("jsseUtil.noVerificationDepth", algorithm));
                }
            }
        }
        return tms;
    }

    private void checkTrustStoreEntries(KeyStore trustStore) throws Exception {
        Enumeration<String> aliases = trustStore.aliases();
        if (aliases != null) {
            Date now = new Date();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!trustStore.isCertificateEntry(alias)) continue;
                Certificate cert = trustStore.getCertificate(alias);
                if (cert instanceof X509Certificate) {
                    try {
                        ((X509Certificate)cert).checkValidity(now);
                    }
                    catch (CertificateExpiredException | CertificateNotYetValidException e2) {
                        String msg = sm.getString("jsseUtil.trustedCertNotValid", alias, ((X509Certificate)cert).getSubjectDN(), e2.getMessage());
                        if (!log.isDebugEnabled()) continue;
                        log.debug(msg, e2);
                    }
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug(sm.getString("jsseUtil.trustedCertNotChecked", alias));
            }
        }
    }

    @Override
    public void configureSessionContext(SSLSessionContext sslSessionContext) {
        sslSessionContext.setSessionCacheSize(this.sslHostConfig.getSessionCacheSize());
        sslSessionContext.setSessionTimeout(this.sslHostConfig.getSessionTimeout());
    }

    protected CertPathParameters getParameters(String crlf, KeyStore trustStore, boolean revocationEnabled) throws Exception {
        PKIXBuilderParameters xparams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
        if (crlf != null && crlf.length() > 0) {
            Collection<? extends CRL> crls = this.getCRLs(crlf);
            CollectionCertStoreParameters csp = new CollectionCertStoreParameters(crls);
            CertStore store = CertStore.getInstance("Collection", csp);
            xparams.addCertStore(store);
            xparams.setRevocationEnabled(true);
        } else {
            xparams.setRevocationEnabled(revocationEnabled);
        }
        xparams.setMaxPathLength(this.sslHostConfig.getCertificateVerificationDepth());
        return xparams;
    }

    protected Collection<? extends CRL> getCRLs(String crlf) throws IOException, CRLException, CertificateException {
        Collection<? extends CRL> crls = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            try (InputStream is = ConfigFileLoader.getInputStream(crlf);){
                crls = cf.generateCRLs(is);
            }
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (CRLException crle) {
            throw crle;
        }
        catch (CertificateException ce) {
            throw ce;
        }
        return crls;
    }

    @Override
    public String[] getEnabledProtocols() {
        return new String[]{"GMSSLv1.1"};
    }

    @Override
    public String[] getEnabledCiphers() {
        return new String[]{"ECC_SM4_SM3"};
    }

    protected static KeyStore getStore(String type, String provider) throws IOException {
        KeyStore ks = null;
        try {
            ks = type.equalsIgnoreCase("bks") ? GMKeyStore.getInstance() : (provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return ks;
    }

    static KeyStore getStore(String type, String provider, String path, String pass) throws IOException {
        KeyStore ks = null;
        InputStream istream = null;
        try {
            ks = GMSSLUtil.getStore(type, provider);
            if (!"PKCS11".equalsIgnoreCase(type) && !"".equalsIgnoreCase(path) || "NONE".equalsIgnoreCase(path)) {
                istream = ConfigFileLoader.getInputStream(path);
            }
            char[] storePass = null;
            if (pass != null && !"".equals(pass)) {
                storePass = pass.toCharArray();
            }
            ks.load(istream, storePass);
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            String msg = sm.getString("jsse.keystore_load_failed", type, path, ex.getMessage());
            log.error(msg, ex);
            throw new IOException(msg);
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ks;
    }
}

