/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.impl;

import com.bes.enterprise.hc.core.annotation.Contract;
import com.bes.enterprise.hc.core.annotation.ThreadingBehavior;
import com.bes.enterprise.hc.core.http.ContentLengthStrategy;
import com.bes.enterprise.hc.core.http.Header;
import com.bes.enterprise.hc.core.http.HttpException;
import com.bes.enterprise.hc.core.http.HttpMessage;
import com.bes.enterprise.hc.core.http.NotImplementedException;
import com.bes.enterprise.hc.core.http.ProtocolException;
import com.bes.enterprise.hc.core.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultContentLengthStrategy
implements ContentLengthStrategy {
    public static final DefaultContentLengthStrategy INSTANCE = new DefaultContentLengthStrategy();

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        Args.notNull(message, "HTTP message");
        Header transferEncodingHeader = message.getFirstHeader("Transfer-Encoding");
        if (transferEncodingHeader != null) {
            String headerValue = transferEncodingHeader.getValue();
            if ("chunked".equalsIgnoreCase(headerValue)) {
                return -1L;
            }
            throw new NotImplementedException("Unsupported transfer encoding: " + headerValue);
        }
        if (message.countHeaders("Content-Length") > 1) {
            throw new ProtocolException("Multiple Content-Length headers");
        }
        Header contentLengthHeader = message.getFirstHeader("Content-Length");
        if (contentLengthHeader != null) {
            String s2 = contentLengthHeader.getValue();
            try {
                long len = Long.parseLong(s2);
                if (len < 0L) {
                    throw new ProtocolException("Negative content length: " + s2);
                }
                return len;
            }
            catch (NumberFormatException e2) {
                throw new ProtocolException("Invalid content length: " + s2);
            }
        }
        return -9223372036854775807L;
    }
}

