/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.impl;

import com.bes.enterprise.hc.core.http.protocol.HttpProcessor;
import com.bes.enterprise.hc.core.http.protocol.HttpProcessorBuilder;
import com.bes.enterprise.hc.core.http.protocol.RequestConnControl;
import com.bes.enterprise.hc.core.http.protocol.RequestContent;
import com.bes.enterprise.hc.core.http.protocol.RequestExpectContinue;
import com.bes.enterprise.hc.core.http.protocol.RequestTargetHost;
import com.bes.enterprise.hc.core.http.protocol.RequestUserAgent;
import com.bes.enterprise.hc.core.http.protocol.RequestValidateHost;
import com.bes.enterprise.hc.core.http.protocol.ResponseConnControl;
import com.bes.enterprise.hc.core.http.protocol.ResponseContent;
import com.bes.enterprise.hc.core.http.protocol.ResponseDate;
import com.bes.enterprise.hc.core.http.protocol.ResponseServer;
import com.bes.enterprise.hc.core.util.TextUtils;
import com.bes.enterprise.hc.core.util.VersionInfo;

public final class HttpProcessors {
    private static final String SOFTWARE = "Apache-HttpCore";

    public static HttpProcessorBuilder customServer(String serverInfo) {
        return HttpProcessorBuilder.create().addAll(new ResponseDate(), new ResponseServer(!TextUtils.isBlank(serverInfo) ? serverInfo : VersionInfo.getSoftwareInfo(SOFTWARE, "org.apache.hc.core5", HttpProcessors.class)), new ResponseContent(), new ResponseConnControl()).addAll(new RequestValidateHost());
    }

    public static HttpProcessor server(String serverInfo) {
        return HttpProcessors.customServer(serverInfo).build();
    }

    public static HttpProcessor server() {
        return HttpProcessors.customServer(null).build();
    }

    public static HttpProcessorBuilder customClient(String agentInfo) {
        return HttpProcessorBuilder.create().addAll(new RequestContent(), new RequestTargetHost(), new RequestConnControl(), new RequestUserAgent(!TextUtils.isBlank(agentInfo) ? agentInfo : VersionInfo.getSoftwareInfo(SOFTWARE, "org.apache.hc.core5", HttpProcessors.class)), new RequestExpectContinue());
    }

    public static HttpProcessor client(String agentInfo) {
        return HttpProcessors.customClient(agentInfo).build();
    }

    public static HttpProcessor client() {
        return HttpProcessors.customClient(null).build();
    }
}

