/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.impl.bootstrap;

import com.bes.enterprise.hc.core.annotation.Internal;
import com.bes.enterprise.hc.core.concurrent.FutureCallback;
import com.bes.enterprise.hc.core.function.Callback;
import com.bes.enterprise.hc.core.function.Decorator;
import com.bes.enterprise.hc.core.http.URIScheme;
import com.bes.enterprise.hc.core.http.impl.bootstrap.AsyncServer;
import com.bes.enterprise.hc.core.http.nio.command.ShutdownCommand;
import com.bes.enterprise.hc.core.reactor.EndpointParameters;
import com.bes.enterprise.hc.core.reactor.IOEventHandlerFactory;
import com.bes.enterprise.hc.core.reactor.IOReactorConfig;
import com.bes.enterprise.hc.core.reactor.IOSession;
import com.bes.enterprise.hc.core.reactor.IOSessionListener;
import com.bes.enterprise.hc.core.reactor.ListenerEndpoint;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Future;

public class HttpAsyncServer
extends AsyncServer {
    private final String canonicalName;

    @Internal
    public HttpAsyncServer(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig ioReactorConfig, Decorator<IOSession> ioSessionDecorator, Callback<Exception> exceptionCallback, IOSessionListener sessionListener, String canonicalName) {
        super(eventHandlerFactory, ioReactorConfig, ioSessionDecorator, exceptionCallback, sessionListener, ShutdownCommand.GRACEFUL_NORMAL_CALLBACK);
        this.canonicalName = canonicalName;
    }

    @Internal
    public HttpAsyncServer(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig ioReactorConfig, Decorator<IOSession> ioSessionDecorator, Callback<Exception> exceptionCallback, IOSessionListener sessionListener) {
        this(eventHandlerFactory, ioReactorConfig, ioSessionDecorator, exceptionCallback, sessionListener, (String)null);
    }

    public Future<ListenerEndpoint> listen(SocketAddress address, URIScheme scheme, Object attachment, FutureCallback<ListenerEndpoint> callback) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
        EndpointParameters parameters = new EndpointParameters(scheme.id, this.canonicalName != null ? this.canonicalName : "localhost", inetSocketAddress.getPort(), attachment);
        return super.listen(address, parameters, callback);
    }

    public Future<ListenerEndpoint> listen(SocketAddress address, URIScheme scheme, FutureCallback<ListenerEndpoint> callback) {
        return this.listen(address, scheme, null, callback);
    }

    public Future<ListenerEndpoint> listen(SocketAddress address, URIScheme scheme) {
        return this.listen(address, scheme, null, null);
    }

    @Override
    @Deprecated
    public Future<ListenerEndpoint> listen(SocketAddress address, FutureCallback<ListenerEndpoint> callback) {
        return super.listen(address, callback);
    }

    @Override
    @Deprecated
    public Future<ListenerEndpoint> listen(SocketAddress address) {
        return super.listen(address);
    }
}

