/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.impl.io;

import com.bes.enterprise.hc.core.http.ClassicHttpRequest;
import com.bes.enterprise.hc.core.http.ClassicHttpResponse;
import com.bes.enterprise.hc.core.http.ContentLengthStrategy;
import com.bes.enterprise.hc.core.http.HttpEntity;
import com.bes.enterprise.hc.core.http.HttpException;
import com.bes.enterprise.hc.core.http.HttpVersion;
import com.bes.enterprise.hc.core.http.ProtocolVersion;
import com.bes.enterprise.hc.core.http.UnsupportedHttpVersionException;
import com.bes.enterprise.hc.core.http.config.Http1Config;
import com.bes.enterprise.hc.core.http.impl.DefaultContentLengthStrategy;
import com.bes.enterprise.hc.core.http.impl.io.BHttpConnectionBase;
import com.bes.enterprise.hc.core.http.impl.io.DefaultHttpRequestParserFactory;
import com.bes.enterprise.hc.core.http.impl.io.DefaultHttpResponseWriterFactory;
import com.bes.enterprise.hc.core.http.impl.io.SocketHolder;
import com.bes.enterprise.hc.core.http.io.HttpMessageParser;
import com.bes.enterprise.hc.core.http.io.HttpMessageParserFactory;
import com.bes.enterprise.hc.core.http.io.HttpMessageWriter;
import com.bes.enterprise.hc.core.http.io.HttpMessageWriterFactory;
import com.bes.enterprise.hc.core.http.io.HttpServerConnection;
import com.bes.enterprise.hc.core.util.Args;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public class DefaultBHttpServerConnection
extends BHttpConnectionBase
implements HttpServerConnection {
    private final String scheme;
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final HttpMessageParser<ClassicHttpRequest> requestParser;
    private final HttpMessageWriter<ClassicHttpResponse> responseWriter;

    public DefaultBHttpServerConnection(String scheme, Http1Config http1Config, CharsetDecoder charDecoder, CharsetEncoder charEncoder, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, HttpMessageParserFactory<ClassicHttpRequest> requestParserFactory, HttpMessageWriterFactory<ClassicHttpResponse> responseWriterFactory) {
        super(http1Config, charDecoder, charEncoder);
        this.scheme = scheme;
        this.requestParser = (requestParserFactory != null ? requestParserFactory : DefaultHttpRequestParserFactory.INSTANCE).create(http1Config);
        this.responseWriter = (responseWriterFactory != null ? responseWriterFactory : DefaultHttpResponseWriterFactory.INSTANCE).create();
        this.incomingContentStrategy = incomingContentStrategy != null ? incomingContentStrategy : DefaultContentLengthStrategy.INSTANCE;
        this.outgoingContentStrategy = outgoingContentStrategy != null ? outgoingContentStrategy : DefaultContentLengthStrategy.INSTANCE;
    }

    public DefaultBHttpServerConnection(String scheme, Http1Config http1Config, CharsetDecoder charDecoder, CharsetEncoder charEncoder) {
        this(scheme, http1Config, charDecoder, charEncoder, null, null, null, null);
    }

    public DefaultBHttpServerConnection(String scheme, Http1Config http1Config) {
        this(scheme, http1Config, null, null);
    }

    protected void onRequestReceived(ClassicHttpRequest request) {
    }

    protected void onResponseSubmitted(ClassicHttpResponse response) {
    }

    @Override
    public void bind(Socket socket) throws IOException {
        super.bind(socket);
    }

    @Override
    public ClassicHttpRequest receiveRequestHeader() throws HttpException, IOException {
        SocketHolder socketHolder = this.ensureOpen();
        ClassicHttpRequest request = this.requestParser.parse(this.inBuffer, socketHolder.getInputStream());
        ProtocolVersion transportVersion = request.getVersion();
        if (transportVersion != null && transportVersion.greaterEquals(HttpVersion.HTTP_2)) {
            throw new UnsupportedHttpVersionException(transportVersion);
        }
        request.setScheme(this.scheme);
        this.version = transportVersion;
        this.onRequestReceived(request);
        this.incrementRequestCount();
        return request;
    }

    @Override
    public void receiveRequestEntity(ClassicHttpRequest request) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        SocketHolder socketHolder = this.ensureOpen();
        long len = this.incomingContentStrategy.determineLength(request);
        if (len == -9223372036854775807L) {
            return;
        }
        request.setEntity(this.createIncomingEntity(request, this.inBuffer, socketHolder.getInputStream(), len));
    }

    @Override
    public void sendResponseHeader(ClassicHttpResponse response) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        SocketHolder socketHolder = this.ensureOpen();
        this.responseWriter.write(response, this.outbuffer, socketHolder.getOutputStream());
        this.onResponseSubmitted(response);
        if (response.getCode() >= 200) {
            this.incrementResponseCount();
        }
    }

    @Override
    public void sendResponseEntity(ClassicHttpResponse response) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        SocketHolder socketHolder = this.ensureOpen();
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return;
        }
        long len = this.outgoingContentStrategy.determineLength(response);
        try (OutputStream outStream = this.createContentOutputStream(len, this.outbuffer, socketHolder.getOutputStream(), entity.getTrailers());){
            entity.writeTo(outStream);
        }
    }
}

