/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.impl.nio;

import com.bes.enterprise.hc.core.annotation.Contract;
import com.bes.enterprise.hc.core.annotation.ThreadingBehavior;
import com.bes.enterprise.hc.core.http.HttpHost;
import com.bes.enterprise.hc.core.http.URIScheme;
import com.bes.enterprise.hc.core.http.impl.nio.ClientHttp1IOEventHandler;
import com.bes.enterprise.hc.core.http.impl.nio.ClientHttp1StreamDuplexerFactory;
import com.bes.enterprise.hc.core.http.nio.ssl.TlsStrategy;
import com.bes.enterprise.hc.core.reactor.EndpointParameters;
import com.bes.enterprise.hc.core.reactor.IOEventHandler;
import com.bes.enterprise.hc.core.reactor.IOEventHandlerFactory;
import com.bes.enterprise.hc.core.reactor.ProtocolIOSession;
import com.bes.enterprise.hc.core.util.Args;
import com.bes.enterprise.hc.core.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ClientHttp1IOEventHandlerFactory
implements IOEventHandlerFactory {
    private final ClientHttp1StreamDuplexerFactory streamDuplexerFactory;
    private final TlsStrategy tlsStrategy;
    private final Timeout handshakeTimeout;

    public ClientHttp1IOEventHandlerFactory(ClientHttp1StreamDuplexerFactory streamDuplexerFactory, TlsStrategy tlsStrategy, Timeout handshakeTimeout) {
        this.streamDuplexerFactory = Args.notNull(streamDuplexerFactory, "Stream duplexer factory");
        this.tlsStrategy = tlsStrategy;
        this.handshakeTimeout = handshakeTimeout;
    }

    @Override
    public IOEventHandler createHandler(ProtocolIOSession ioSession, Object attachment) {
        if (attachment instanceof EndpointParameters) {
            EndpointParameters params = (EndpointParameters)attachment;
            if (this.tlsStrategy != null && URIScheme.HTTPS.same(params.getScheme())) {
                HttpHost host = new HttpHost(params.getScheme(), params.getHostName(), params.getPort());
                this.tlsStrategy.upgrade(ioSession, host, ioSession.getLocalAddress(), ioSession.getRemoteAddress(), params.getAttachment(), this.handshakeTimeout);
            }
        }
        return new ClientHttp1IOEventHandler(this.streamDuplexerFactory.create(ioSession));
    }
}

