/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.impl.nio;

import com.bes.enterprise.hc.core.annotation.Contract;
import com.bes.enterprise.hc.core.annotation.Internal;
import com.bes.enterprise.hc.core.annotation.ThreadingBehavior;
import com.bes.enterprise.hc.core.http.ConnectionReuseStrategy;
import com.bes.enterprise.hc.core.http.ContentLengthStrategy;
import com.bes.enterprise.hc.core.http.HttpRequest;
import com.bes.enterprise.hc.core.http.HttpResponse;
import com.bes.enterprise.hc.core.http.config.CharCodingConfig;
import com.bes.enterprise.hc.core.http.config.Http1Config;
import com.bes.enterprise.hc.core.http.impl.DefaultConnectionReuseStrategy;
import com.bes.enterprise.hc.core.http.impl.DefaultContentLengthStrategy;
import com.bes.enterprise.hc.core.http.impl.Http1StreamListener;
import com.bes.enterprise.hc.core.http.impl.nio.ClientHttp1StreamDuplexer;
import com.bes.enterprise.hc.core.http.impl.nio.DefaultHttpRequestWriterFactory;
import com.bes.enterprise.hc.core.http.impl.nio.DefaultHttpResponseParserFactory;
import com.bes.enterprise.hc.core.http.nio.NHttpMessageParserFactory;
import com.bes.enterprise.hc.core.http.nio.NHttpMessageWriterFactory;
import com.bes.enterprise.hc.core.http.protocol.HttpProcessor;
import com.bes.enterprise.hc.core.reactor.ProtocolIOSession;
import com.bes.enterprise.hc.core.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public final class ClientHttp1StreamDuplexerFactory {
    private final HttpProcessor httpProcessor;
    private final Http1Config http1Config;
    private final CharCodingConfig charCodingConfig;
    private final ConnectionReuseStrategy connectionReuseStrategy;
    private final NHttpMessageParserFactory<HttpResponse> responseParserFactory;
    private final NHttpMessageWriterFactory<HttpRequest> requestWriterFactory;
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final Http1StreamListener streamListener;

    public ClientHttp1StreamDuplexerFactory(HttpProcessor httpProcessor, Http1Config http1Config, CharCodingConfig charCodingConfig, ConnectionReuseStrategy connectionReuseStrategy, NHttpMessageParserFactory<HttpResponse> responseParserFactory, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, Http1StreamListener streamListener) {
        this.httpProcessor = Args.notNull(httpProcessor, "HTTP processor");
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.charCodingConfig = charCodingConfig != null ? charCodingConfig : CharCodingConfig.DEFAULT;
        this.connectionReuseStrategy = connectionReuseStrategy != null ? connectionReuseStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.responseParserFactory = responseParserFactory != null ? responseParserFactory : new DefaultHttpResponseParserFactory(http1Config);
        this.requestWriterFactory = requestWriterFactory != null ? requestWriterFactory : DefaultHttpRequestWriterFactory.INSTANCE;
        this.incomingContentStrategy = incomingContentStrategy != null ? incomingContentStrategy : DefaultContentLengthStrategy.INSTANCE;
        this.outgoingContentStrategy = outgoingContentStrategy != null ? outgoingContentStrategy : DefaultContentLengthStrategy.INSTANCE;
        this.streamListener = streamListener;
    }

    public ClientHttp1StreamDuplexerFactory(HttpProcessor httpProcessor, Http1Config http1Config, CharCodingConfig charCodingConfig, ConnectionReuseStrategy connectionReuseStrategy, NHttpMessageParserFactory<HttpResponse> responseParserFactory, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, Http1StreamListener streamListener) {
        this(httpProcessor, http1Config, charCodingConfig, connectionReuseStrategy, responseParserFactory, requestWriterFactory, null, null, streamListener);
    }

    public ClientHttp1StreamDuplexerFactory(HttpProcessor httpProcessor, Http1Config http1Config, CharCodingConfig charCodingConfig, Http1StreamListener streamListener) {
        this(httpProcessor, http1Config, charCodingConfig, null, null, null, streamListener);
    }

    public ClientHttp1StreamDuplexerFactory(HttpProcessor httpProcessor, Http1Config http1Config, CharCodingConfig charCodingConfig) {
        this(httpProcessor, http1Config, charCodingConfig, null);
    }

    public ClientHttp1StreamDuplexer create(ProtocolIOSession ioSession) {
        return new ClientHttp1StreamDuplexer(ioSession, this.httpProcessor, this.http1Config, this.charCodingConfig, this.connectionReuseStrategy, this.responseParserFactory.create(), this.requestWriterFactory.create(), this.incomingContentStrategy, this.outgoingContentStrategy, this.streamListener);
    }
}

