/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.impl.nio;

import com.bes.enterprise.hc.core.http.HttpException;
import com.bes.enterprise.hc.core.http.HttpResponse;
import com.bes.enterprise.hc.core.http.HttpResponseFactory;
import com.bes.enterprise.hc.core.http.config.Http1Config;
import com.bes.enterprise.hc.core.http.impl.nio.AbstractMessageParser;
import com.bes.enterprise.hc.core.http.message.LineParser;
import com.bes.enterprise.hc.core.http.message.StatusLine;
import com.bes.enterprise.hc.core.util.Args;
import com.bes.enterprise.hc.core.util.CharArrayBuffer;

public class DefaultHttpResponseParser<T extends HttpResponse>
extends AbstractMessageParser<T> {
    private final HttpResponseFactory<T> responseFactory;

    public DefaultHttpResponseParser(HttpResponseFactory<T> responseFactory, LineParser parser, Http1Config http1Config) {
        super(parser, http1Config);
        this.responseFactory = Args.notNull(responseFactory, "Response factory");
    }

    public DefaultHttpResponseParser(HttpResponseFactory<T> responseFactory, Http1Config http1Config) {
        this(responseFactory, null, http1Config);
    }

    public DefaultHttpResponseParser(HttpResponseFactory<T> responseFactory) {
        this(responseFactory, null);
    }

    @Override
    protected T createMessage(CharArrayBuffer buffer) throws HttpException {
        StatusLine statusLine = this.getLineParser().parseStatusLine(buffer);
        T response = this.responseFactory.newHttpResponse(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        response.setVersion(statusLine.getProtocolVersion());
        return response;
    }
}

