/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.impl.nio;

import com.bes.enterprise.hc.core.annotation.Contract;
import com.bes.enterprise.hc.core.annotation.ThreadingBehavior;
import com.bes.enterprise.hc.core.http.URIScheme;
import com.bes.enterprise.hc.core.http.impl.nio.ServerHttp1IOEventHandler;
import com.bes.enterprise.hc.core.http.impl.nio.ServerHttp1StreamDuplexerFactory;
import com.bes.enterprise.hc.core.http.nio.ssl.TlsStrategy;
import com.bes.enterprise.hc.core.reactor.EndpointParameters;
import com.bes.enterprise.hc.core.reactor.IOEventHandler;
import com.bes.enterprise.hc.core.reactor.IOEventHandlerFactory;
import com.bes.enterprise.hc.core.reactor.ProtocolIOSession;
import com.bes.enterprise.hc.core.util.Args;
import com.bes.enterprise.hc.core.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ServerHttp1IOEventHandlerFactory
implements IOEventHandlerFactory {
    private final ServerHttp1StreamDuplexerFactory streamDuplexerFactory;
    private final TlsStrategy tlsStrategy;
    private final Timeout handshakeTimeout;

    public ServerHttp1IOEventHandlerFactory(ServerHttp1StreamDuplexerFactory streamDuplexerFactory, TlsStrategy tlsStrategy, Timeout handshakeTimeout) {
        this.streamDuplexerFactory = Args.notNull(streamDuplexerFactory, "Stream duplexer factory");
        this.tlsStrategy = tlsStrategy;
        this.handshakeTimeout = handshakeTimeout;
    }

    @Override
    public IOEventHandler createHandler(ProtocolIOSession ioSession, Object attachment) {
        String endpointScheme = URIScheme.HTTP.id;
        if (attachment instanceof EndpointParameters) {
            EndpointParameters params = (EndpointParameters)attachment;
            endpointScheme = params.getScheme();
            if (this.tlsStrategy != null && URIScheme.HTTPS.same(endpointScheme)) {
                this.tlsStrategy.upgrade(ioSession, null, ioSession.getLocalAddress(), ioSession.getRemoteAddress(), params.getAttachment(), this.handshakeTimeout);
            }
        } else if (this.tlsStrategy != null) {
            this.tlsStrategy.upgrade(ioSession, null, ioSession.getLocalAddress(), ioSession.getRemoteAddress(), attachment, this.handshakeTimeout);
        }
        return new ServerHttp1IOEventHandler(this.streamDuplexerFactory.create(endpointScheme, ioSession));
    }
}

