/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.impl.nio;

import com.bes.enterprise.hc.core.annotation.Contract;
import com.bes.enterprise.hc.core.annotation.Internal;
import com.bes.enterprise.hc.core.annotation.ThreadingBehavior;
import com.bes.enterprise.hc.core.http.ConnectionReuseStrategy;
import com.bes.enterprise.hc.core.http.ContentLengthStrategy;
import com.bes.enterprise.hc.core.http.HttpRequest;
import com.bes.enterprise.hc.core.http.HttpResponse;
import com.bes.enterprise.hc.core.http.config.CharCodingConfig;
import com.bes.enterprise.hc.core.http.config.Http1Config;
import com.bes.enterprise.hc.core.http.impl.DefaultConnectionReuseStrategy;
import com.bes.enterprise.hc.core.http.impl.DefaultContentLengthStrategy;
import com.bes.enterprise.hc.core.http.impl.Http1StreamListener;
import com.bes.enterprise.hc.core.http.impl.nio.DefaultHttpRequestParserFactory;
import com.bes.enterprise.hc.core.http.impl.nio.DefaultHttpResponseWriterFactory;
import com.bes.enterprise.hc.core.http.impl.nio.ServerHttp1StreamDuplexer;
import com.bes.enterprise.hc.core.http.nio.AsyncServerExchangeHandler;
import com.bes.enterprise.hc.core.http.nio.HandlerFactory;
import com.bes.enterprise.hc.core.http.nio.NHttpMessageParserFactory;
import com.bes.enterprise.hc.core.http.nio.NHttpMessageWriterFactory;
import com.bes.enterprise.hc.core.http.protocol.HttpProcessor;
import com.bes.enterprise.hc.core.reactor.ProtocolIOSession;
import com.bes.enterprise.hc.core.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public final class ServerHttp1StreamDuplexerFactory {
    private final HttpProcessor httpProcessor;
    private final HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory;
    private final ConnectionReuseStrategy connectionReuseStrategy;
    private final Http1Config http1Config;
    private final CharCodingConfig charCodingConfig;
    private final NHttpMessageParserFactory<HttpRequest> requestParserFactory;
    private final NHttpMessageWriterFactory<HttpResponse> responseWriterFactory;
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final Http1StreamListener streamListener;

    public ServerHttp1StreamDuplexerFactory(HttpProcessor httpProcessor, HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory, Http1Config http1Config, CharCodingConfig charCodingConfig, ConnectionReuseStrategy connectionReuseStrategy, NHttpMessageParserFactory<HttpRequest> requestParserFactory, NHttpMessageWriterFactory<HttpResponse> responseWriterFactory, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, Http1StreamListener streamListener) {
        this.httpProcessor = Args.notNull(httpProcessor, "HTTP processor");
        this.exchangeHandlerFactory = Args.notNull(exchangeHandlerFactory, "Exchange handler factory");
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.charCodingConfig = charCodingConfig != null ? charCodingConfig : CharCodingConfig.DEFAULT;
        this.connectionReuseStrategy = connectionReuseStrategy != null ? connectionReuseStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.requestParserFactory = requestParserFactory != null ? requestParserFactory : new DefaultHttpRequestParserFactory(http1Config);
        this.responseWriterFactory = responseWriterFactory != null ? responseWriterFactory : DefaultHttpResponseWriterFactory.INSTANCE;
        this.incomingContentStrategy = incomingContentStrategy != null ? incomingContentStrategy : DefaultContentLengthStrategy.INSTANCE;
        this.outgoingContentStrategy = outgoingContentStrategy != null ? outgoingContentStrategy : DefaultContentLengthStrategy.INSTANCE;
        this.streamListener = streamListener;
    }

    public ServerHttp1StreamDuplexerFactory(HttpProcessor httpProcessor, HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory, Http1Config http1Config, CharCodingConfig charCodingConfig, ConnectionReuseStrategy connectionReuseStrategy, NHttpMessageParserFactory<HttpRequest> requestParserFactory, NHttpMessageWriterFactory<HttpResponse> responseWriterFactory, Http1StreamListener streamListener) {
        this(httpProcessor, exchangeHandlerFactory, http1Config, charCodingConfig, connectionReuseStrategy, requestParserFactory, responseWriterFactory, null, null, streamListener);
    }

    public ServerHttp1StreamDuplexerFactory(HttpProcessor httpProcessor, HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory, Http1Config http1Config, CharCodingConfig charCodingConfig, Http1StreamListener streamListener) {
        this(httpProcessor, exchangeHandlerFactory, http1Config, charCodingConfig, null, null, null, streamListener);
    }

    public ServerHttp1StreamDuplexer create(String scheme, ProtocolIOSession ioSession) {
        return new ServerHttp1StreamDuplexer(ioSession, this.httpProcessor, this.exchangeHandlerFactory, scheme, this.http1Config, this.charCodingConfig, this.connectionReuseStrategy, this.requestParserFactory.create(), this.responseWriterFactory.create(), this.incomingContentStrategy, this.outgoingContentStrategy, this.streamListener);
    }
}

