/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.io.entity;

import com.bes.enterprise.hc.core.annotation.Contract;
import com.bes.enterprise.hc.core.annotation.ThreadingBehavior;
import com.bes.enterprise.hc.core.http.ContentType;
import com.bes.enterprise.hc.core.http.io.entity.AbstractHttpEntity;
import com.bes.enterprise.hc.core.util.Args;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ByteArrayEntity
extends AbstractHttpEntity {
    private final byte[] b;
    private final int off;
    private final int len;

    public ByteArrayEntity(byte[] b2, int off, int len, ContentType contentType, String contentEncoding, boolean chunked) {
        super(contentType, contentEncoding, chunked);
        Args.notNull(b2, "Source byte array");
        if (off < 0 || off > b2.length || len < 0 || off + len < 0 || off + len > b2.length) {
            throw new IndexOutOfBoundsException("off: " + off + " len: " + len + " b.length: " + b2.length);
        }
        this.b = b2;
        this.off = off;
        this.len = len;
    }

    public ByteArrayEntity(byte[] b2, int off, int len, ContentType contentType, String contentEncoding) {
        this(b2, off, len, contentType, contentEncoding, false);
    }

    public ByteArrayEntity(byte[] b2, ContentType contentType, String contentEncoding, boolean chunked) {
        super(contentType, contentEncoding, chunked);
        Args.notNull(b2, "Source byte array");
        this.b = b2;
        this.off = 0;
        this.len = this.b.length;
    }

    public ByteArrayEntity(byte[] b2, ContentType contentType, String contentEncoding) {
        this(b2, contentType, contentEncoding, false);
    }

    public ByteArrayEntity(byte[] b2, ContentType contentType, boolean chunked) {
        this(b2, contentType, null, chunked);
    }

    public ByteArrayEntity(byte[] b2, ContentType contentType) {
        this(b2, contentType, null, false);
    }

    public ByteArrayEntity(byte[] b2, int off, int len, ContentType contentType, boolean chunked) {
        this(b2, off, len, contentType, null, chunked);
    }

    public ByteArrayEntity(byte[] b2, int off, int len, ContentType contentType) {
        this(b2, off, len, contentType, null, false);
    }

    @Override
    public final boolean isRepeatable() {
        return true;
    }

    @Override
    public final long getContentLength() {
        return this.len;
    }

    @Override
    public final InputStream getContent() {
        return new ByteArrayInputStream(this.b, this.off, this.len);
    }

    @Override
    public final void writeTo(OutputStream outStream) throws IOException {
        Args.notNull(outStream, "Output stream");
        outStream.write(this.b, this.off, this.len);
        outStream.flush();
    }

    @Override
    public final boolean isStreaming() {
        return false;
    }

    @Override
    public final void close() throws IOException {
    }
}

