/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.io.entity;

import com.bes.enterprise.hc.core.annotation.Contract;
import com.bes.enterprise.hc.core.annotation.ThreadingBehavior;
import com.bes.enterprise.hc.core.http.ContentType;
import com.bes.enterprise.hc.core.http.io.entity.AbstractHttpEntity;
import com.bes.enterprise.hc.core.io.IOCallback;
import com.bes.enterprise.hc.core.util.Args;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public final class EntityTemplate
extends AbstractHttpEntity {
    private final long contentLength;
    private final IOCallback<OutputStream> callback;

    public EntityTemplate(long contentLength, ContentType contentType, String contentEncoding, IOCallback<OutputStream> callback) {
        super(contentType, contentEncoding);
        this.contentLength = contentLength;
        this.callback = Args.notNull(callback, "I/O callback");
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public InputStream getContent() throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        this.writeTo(buf);
        return new ByteArrayInputStream(buf.toByteArray());
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public void writeTo(OutputStream outStream) throws IOException {
        Args.notNull(outStream, "Output stream");
        this.callback.execute(outStream);
    }

    @Override
    public boolean isStreaming() {
        return false;
    }

    @Override
    public void close() throws IOException {
    }
}

