/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.io.support;

import com.bes.enterprise.hc.core.http.ClassicHttpRequest;
import com.bes.enterprise.hc.core.http.ClassicHttpResponse;
import com.bes.enterprise.hc.core.http.HttpException;
import com.bes.enterprise.hc.core.http.HttpRequestMapper;
import com.bes.enterprise.hc.core.http.HttpResponseFactory;
import com.bes.enterprise.hc.core.http.impl.io.DefaultClassicHttpResponseFactory;
import com.bes.enterprise.hc.core.http.io.HttpRequestHandler;
import com.bes.enterprise.hc.core.http.io.HttpServerRequestHandler;
import com.bes.enterprise.hc.core.http.protocol.HttpContext;
import com.bes.enterprise.hc.core.util.Args;
import java.io.IOException;

public class BasicHttpServerRequestHandler
implements HttpServerRequestHandler {
    private final HttpRequestMapper<HttpRequestHandler> handlerMapper;
    private final HttpResponseFactory<ClassicHttpResponse> responseFactory;

    public BasicHttpServerRequestHandler(HttpRequestMapper<HttpRequestHandler> handlerMapper, HttpResponseFactory<ClassicHttpResponse> responseFactory) {
        this.handlerMapper = Args.notNull(handlerMapper, "Handler mapper");
        this.responseFactory = responseFactory != null ? responseFactory : DefaultClassicHttpResponseFactory.INSTANCE;
    }

    public BasicHttpServerRequestHandler(HttpRequestMapper<HttpRequestHandler> handlerMapper) {
        this(handlerMapper, null);
    }

    @Override
    public void handle(ClassicHttpRequest request, HttpServerRequestHandler.ResponseTrigger responseTrigger, HttpContext context) throws HttpException, IOException {
        HttpRequestHandler handler;
        ClassicHttpResponse response = this.responseFactory.newHttpResponse(200);
        HttpRequestHandler httpRequestHandler = handler = this.handlerMapper != null ? this.handlerMapper.resolve(request, context) : null;
        if (handler != null) {
            handler.handle(request, response, context);
        } else {
            response.setCode(501);
        }
        responseTrigger.submitResponse(response);
    }
}

