/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.io.support;

import com.bes.enterprise.hc.core.annotation.Contract;
import com.bes.enterprise.hc.core.annotation.ThreadingBehavior;
import com.bes.enterprise.hc.core.http.ClassicHttpRequest;
import com.bes.enterprise.hc.core.http.Header;
import com.bes.enterprise.hc.core.http.HttpEntity;
import com.bes.enterprise.hc.core.http.HttpException;
import com.bes.enterprise.hc.core.http.HttpResponse;
import com.bes.enterprise.hc.core.http.io.HttpFilterChain;
import com.bes.enterprise.hc.core.http.io.HttpFilterHandler;
import com.bes.enterprise.hc.core.http.message.BasicClassicHttpResponse;
import com.bes.enterprise.hc.core.http.protocol.HttpContext;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.STATELESS)
public class HttpServerExpectationFilter
implements HttpFilterHandler {
    protected boolean verify(ClassicHttpRequest request, HttpContext context) throws HttpException {
        return true;
    }

    protected HttpEntity generateResponseContent(HttpResponse expectationFailed) throws HttpException {
        return null;
    }

    @Override
    public final void handle(ClassicHttpRequest request, HttpFilterChain.ResponseTrigger responseTrigger, HttpContext context, HttpFilterChain chain) throws HttpException, IOException {
        boolean expectContinue;
        Header expect = request.getFirstHeader("Expect");
        boolean bl = expectContinue = expect != null && "100-continue".equalsIgnoreCase(expect.getValue());
        if (expectContinue) {
            boolean verified = this.verify(request, context);
            if (verified) {
                responseTrigger.sendInformation(new BasicClassicHttpResponse(100));
            } else {
                BasicClassicHttpResponse expectationFailed = new BasicClassicHttpResponse(417);
                HttpEntity responseContent = this.generateResponseContent(expectationFailed);
                expectationFailed.setEntity(responseContent);
                responseTrigger.submitResponse(expectationFailed);
                return;
            }
        }
        chain.proceed(request, responseTrigger, context);
    }
}

