/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.message;

import com.bes.enterprise.hc.core.http.FormattedHeader;
import com.bes.enterprise.hc.core.http.ParseException;
import com.bes.enterprise.hc.core.util.Args;
import com.bes.enterprise.hc.core.util.CharArrayBuffer;
import com.bes.enterprise.hc.core.util.Tokenizer;
import java.io.Serializable;

public class BufferedHeader
implements FormattedHeader,
Serializable {
    private static final long serialVersionUID = -2768352615787625448L;
    private final String name;
    private final CharArrayBuffer buffer;
    private final int valuePos;

    public static BufferedHeader create(CharArrayBuffer buffer) {
        try {
            return new BufferedHeader(buffer);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public BufferedHeader(CharArrayBuffer buffer) throws ParseException {
        this(buffer, true);
    }

    BufferedHeader(CharArrayBuffer buffer, boolean strict) throws ParseException {
        Args.notNull(buffer, "Char array buffer");
        int colon = buffer.indexOf(58);
        if (colon <= 0) {
            throw new ParseException("Invalid header", buffer, 0, buffer.length());
        }
        if (strict && Tokenizer.isWhitespace(buffer.charAt(colon - 1))) {
            throw new ParseException("Invalid header", buffer, 0, buffer.length(), colon - 1);
        }
        String s2 = buffer.substringTrimmed(0, colon);
        if (s2.isEmpty()) {
            throw new ParseException("Invalid header", buffer, 0, buffer.length(), colon);
        }
        this.buffer = buffer;
        this.name = s2;
        this.valuePos = colon + 1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.buffer.substringTrimmed(this.valuePos, this.buffer.length());
    }

    @Override
    public boolean isSensitive() {
        return false;
    }

    @Override
    public int getValuePos() {
        return this.valuePos;
    }

    @Override
    public CharArrayBuffer getBuffer() {
        return this.buffer;
    }

    public String toString() {
        return this.buffer.toString();
    }
}

