/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.nio.ssl;

import com.bes.enterprise.hc.core.http.ssl.TLS;
import com.bes.enterprise.hc.core.http.ssl.TlsCiphers;
import com.bes.enterprise.hc.core.net.NamedEndpoint;
import com.bes.enterprise.hc.core.reactor.ssl.SSLSessionInitializer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public final class TlsSupport {
    public static SSLSessionInitializer enforceStrongSecurity(final SSLSessionInitializer initializer) {
        return new SSLSessionInitializer(){

            @Override
            public void initialize(NamedEndpoint endpoint, SSLEngine sslEngine) {
                SSLParameters sslParameters = sslEngine.getSSLParameters();
                sslParameters.setProtocols(TLS.excludeWeak(sslParameters.getProtocols()));
                sslParameters.setCipherSuites(TlsCiphers.excludeWeak(sslParameters.getCipherSuites()));
                sslEngine.setSSLParameters(sslParameters);
                if (initializer != null) {
                    initializer.initialize(endpoint, sslEngine);
                }
            }
        };
    }
}

