/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.nio.support;

import com.bes.enterprise.hc.core.annotation.Contract;
import com.bes.enterprise.hc.core.annotation.ThreadingBehavior;
import com.bes.enterprise.hc.core.http.EntityDetails;
import com.bes.enterprise.hc.core.http.Header;
import com.bes.enterprise.hc.core.http.HttpException;
import com.bes.enterprise.hc.core.http.HttpRequest;
import com.bes.enterprise.hc.core.http.HttpResponse;
import com.bes.enterprise.hc.core.http.message.BasicHttpResponse;
import com.bes.enterprise.hc.core.http.nio.AsyncDataConsumer;
import com.bes.enterprise.hc.core.http.nio.AsyncEntityProducer;
import com.bes.enterprise.hc.core.http.nio.AsyncFilterChain;
import com.bes.enterprise.hc.core.http.nio.AsyncFilterHandler;
import com.bes.enterprise.hc.core.http.protocol.HttpContext;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.STATELESS)
public class AsyncServerExpectationFilter
implements AsyncFilterHandler {
    protected boolean verify(HttpRequest request, HttpContext context) throws HttpException {
        return true;
    }

    protected AsyncEntityProducer generateResponseContent(HttpResponse expectationFailed) throws HttpException {
        return null;
    }

    @Override
    public final AsyncDataConsumer handle(HttpRequest request, EntityDetails entityDetails, HttpContext context, AsyncFilterChain.ResponseTrigger responseTrigger, AsyncFilterChain chain) throws HttpException, IOException {
        Header h2;
        if (entityDetails != null && (h2 = request.getFirstHeader("Expect")) != null && "100-continue".equalsIgnoreCase(h2.getValue())) {
            boolean verified = this.verify(request, context);
            if (verified) {
                responseTrigger.sendInformation(new BasicHttpResponse(100));
            } else {
                BasicHttpResponse expectationFailed = new BasicHttpResponse(417);
                AsyncEntityProducer responseContentProducer = this.generateResponseContent(expectationFailed);
                responseTrigger.submitResponse(expectationFailed, responseContentProducer);
                return null;
            }
        }
        return chain.proceed(request, entityDetails, context, responseTrigger);
    }
}

