/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.nio.support;

import com.bes.enterprise.hc.core.http.HttpException;
import com.bes.enterprise.hc.core.http.HttpHost;
import com.bes.enterprise.hc.core.http.HttpRequest;
import com.bes.enterprise.hc.core.http.Method;
import com.bes.enterprise.hc.core.http.message.BasicHttpRequest;
import com.bes.enterprise.hc.core.http.nio.AsyncEntityProducer;
import com.bes.enterprise.hc.core.http.nio.AsyncRequestProducer;
import com.bes.enterprise.hc.core.http.nio.DataStreamChannel;
import com.bes.enterprise.hc.core.http.nio.RequestChannel;
import com.bes.enterprise.hc.core.http.protocol.HttpContext;
import java.io.IOException;
import java.net.URI;

public class BasicRequestProducer
implements AsyncRequestProducer {
    private final HttpRequest request;
    private final AsyncEntityProducer dataProducer;

    public BasicRequestProducer(HttpRequest request, AsyncEntityProducer dataProducer) {
        this.request = request;
        this.dataProducer = dataProducer;
    }

    public BasicRequestProducer(String method, HttpHost host, String path, AsyncEntityProducer dataProducer) {
        this(new BasicHttpRequest(method, host, path), dataProducer);
    }

    public BasicRequestProducer(String method, HttpHost host, String path) {
        this(method, host, path, null);
    }

    public BasicRequestProducer(String method, URI requestUri, AsyncEntityProducer dataProducer) {
        this(new BasicHttpRequest(method, requestUri), dataProducer);
    }

    public BasicRequestProducer(String method, URI requestUri) {
        this(method, requestUri, null);
    }

    public BasicRequestProducer(Method method, HttpHost host, String path, AsyncEntityProducer dataProducer) {
        this(new BasicHttpRequest(method, host, path), dataProducer);
    }

    public BasicRequestProducer(Method method, HttpHost host, String path) {
        this(method, host, path, null);
    }

    public BasicRequestProducer(Method method, URI requestUri, AsyncEntityProducer dataProducer) {
        this(new BasicHttpRequest(method, requestUri), dataProducer);
    }

    public BasicRequestProducer(Method method, URI requestUri) {
        this(method, requestUri, null);
    }

    @Override
    public void sendRequest(RequestChannel requestChannel, HttpContext httpContext) throws HttpException, IOException {
        requestChannel.sendRequest(this.request, this.dataProducer, httpContext);
    }

    @Override
    public int available() {
        return this.dataProducer != null ? this.dataProducer.available() : 0;
    }

    @Override
    public void produce(DataStreamChannel channel) throws IOException {
        if (this.dataProducer != null) {
            this.dataProducer.produce(channel);
        }
    }

    @Override
    public boolean isRepeatable() {
        return this.dataProducer == null || this.dataProducer.isRepeatable();
    }

    @Override
    public void failed(Exception cause) {
        try {
            if (this.dataProducer != null) {
                this.dataProducer.failed(cause);
            }
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    public void releaseResources() {
        if (this.dataProducer != null) {
            this.dataProducer.releaseResources();
        }
    }
}

