/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.nio.support;

import com.bes.enterprise.hc.core.annotation.Contract;
import com.bes.enterprise.hc.core.annotation.ThreadingBehavior;
import com.bes.enterprise.hc.core.http.EntityDetails;
import com.bes.enterprise.hc.core.http.HttpException;
import com.bes.enterprise.hc.core.http.HttpRequest;
import com.bes.enterprise.hc.core.http.HttpResponse;
import com.bes.enterprise.hc.core.http.message.BasicHttpResponse;
import com.bes.enterprise.hc.core.http.nio.AsyncDataConsumer;
import com.bes.enterprise.hc.core.http.nio.AsyncEntityProducer;
import com.bes.enterprise.hc.core.http.nio.AsyncFilterChain;
import com.bes.enterprise.hc.core.http.nio.AsyncFilterHandler;
import com.bes.enterprise.hc.core.http.nio.AsyncPushProducer;
import com.bes.enterprise.hc.core.http.nio.AsyncServerExchangeHandler;
import com.bes.enterprise.hc.core.http.nio.DataStreamChannel;
import com.bes.enterprise.hc.core.http.nio.HandlerFactory;
import com.bes.enterprise.hc.core.http.nio.ResponseChannel;
import com.bes.enterprise.hc.core.http.nio.entity.AsyncEntityProducers;
import com.bes.enterprise.hc.core.http.protocol.HttpContext;
import com.bes.enterprise.hc.core.util.Args;
import java.io.IOException;
import java.util.Set;

@Contract(threading=ThreadingBehavior.STATELESS)
public final class TerminalAsyncServerFilter
implements AsyncFilterHandler {
    private final HandlerFactory<AsyncServerExchangeHandler> handlerFactory;

    public TerminalAsyncServerFilter(HandlerFactory<AsyncServerExchangeHandler> handlerFactory) {
        this.handlerFactory = Args.notNull(handlerFactory, "Handler factory");
    }

    @Override
    public AsyncDataConsumer handle(HttpRequest request, EntityDetails entityDetails, HttpContext context, final AsyncFilterChain.ResponseTrigger responseTrigger, AsyncFilterChain chain) throws HttpException, IOException {
        final AsyncServerExchangeHandler exchangeHandler = this.handlerFactory.create(request, context);
        if (exchangeHandler != null) {
            exchangeHandler.handleRequest(request, entityDetails, new ResponseChannel(){

                @Override
                public void sendInformation(HttpResponse response, HttpContext httpContext) throws HttpException, IOException {
                    responseTrigger.sendInformation(response);
                }

                @Override
                public void sendResponse(HttpResponse response, final EntityDetails entityDetails, HttpContext httpContext) throws HttpException, IOException {
                    responseTrigger.submitResponse(response, entityDetails != null ? new AsyncEntityProducer(){

                        @Override
                        public void failed(Exception cause) {
                            exchangeHandler.failed(cause);
                        }

                        @Override
                        public boolean isRepeatable() {
                            return false;
                        }

                        @Override
                        public long getContentLength() {
                            return entityDetails.getContentLength();
                        }

                        @Override
                        public String getContentType() {
                            return entityDetails.getContentType();
                        }

                        @Override
                        public String getContentEncoding() {
                            return entityDetails.getContentEncoding();
                        }

                        @Override
                        public boolean isChunked() {
                            return entityDetails.isChunked();
                        }

                        @Override
                        public Set<String> getTrailerNames() {
                            return entityDetails.getTrailerNames();
                        }

                        @Override
                        public int available() {
                            return exchangeHandler.available();
                        }

                        @Override
                        public void produce(DataStreamChannel channel) throws IOException {
                            exchangeHandler.produce(channel);
                        }

                        @Override
                        public void releaseResources() {
                            exchangeHandler.releaseResources();
                        }
                    } : null);
                }

                @Override
                public void pushPromise(HttpRequest promise, AsyncPushProducer pushProducer, HttpContext httpContext) throws HttpException, IOException {
                    responseTrigger.pushPromise(promise, pushProducer);
                }
            }, context);
            return exchangeHandler;
        }
        responseTrigger.submitResponse(new BasicHttpResponse(404), AsyncEntityProducers.create("Not found"));
        return null;
    }
}

