/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.http.nio.support.classic;

import com.bes.enterprise.hc.core.http.nio.support.classic.ContentOutputBuffer;
import com.bes.enterprise.hc.core.util.Args;
import java.io.IOException;
import java.io.OutputStream;

public class ContentOutputStream
extends OutputStream {
    private final ContentOutputBuffer buffer;

    public ContentOutputStream(ContentOutputBuffer buffer) {
        Args.notNull(buffer, "Output buffer");
        this.buffer = buffer;
    }

    @Override
    public void close() throws IOException {
        this.buffer.writeCompleted();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        this.buffer.write(b2, off, len);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        if (b2 == null) {
            return;
        }
        this.buffer.write(b2, 0, b2.length);
    }

    @Override
    public void write(int b2) throws IOException {
        this.buffer.write(b2);
    }
}

