/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.reactor;

import com.bes.enterprise.hc.core.concurrent.FutureCallback;
import com.bes.enterprise.hc.core.net.NamedEndpoint;
import com.bes.enterprise.hc.core.reactor.ConnectionInitiator;
import com.bes.enterprise.hc.core.reactor.IOReactorService;
import com.bes.enterprise.hc.core.reactor.IOReactorShutdownException;
import com.bes.enterprise.hc.core.reactor.IOReactorStatus;
import com.bes.enterprise.hc.core.reactor.IOSession;
import com.bes.enterprise.hc.core.reactor.IOWorkers;
import com.bes.enterprise.hc.core.util.Args;
import com.bes.enterprise.hc.core.util.Timeout;
import java.net.SocketAddress;
import java.util.concurrent.Future;

abstract class AbstractIOReactorBase
implements ConnectionInitiator,
IOReactorService {
    AbstractIOReactorBase() {
    }

    @Override
    public final Future<IOSession> connect(NamedEndpoint remoteEndpoint, SocketAddress remoteAddress, SocketAddress localAddress, Timeout timeout, Object attachment, FutureCallback<IOSession> callback) throws IOReactorShutdownException {
        Args.notNull(remoteEndpoint, "Remote endpoint");
        if (this.getStatus().compareTo(IOReactorStatus.ACTIVE) > 0) {
            throw new IOReactorShutdownException("I/O reactor has been shut down");
        }
        try {
            return this.getWorkerSelector().next().connect(remoteEndpoint, remoteAddress, localAddress, timeout, attachment, callback);
        }
        catch (IOReactorShutdownException ex) {
            this.initiateShutdown();
            throw ex;
        }
    }

    abstract IOWorkers.Selector getWorkerSelector();
}

