/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.reactor;

import com.bes.enterprise.hc.core.annotation.Internal;
import com.bes.enterprise.hc.core.http.HttpHost;
import com.bes.enterprise.hc.core.net.NamedEndpoint;
import com.bes.enterprise.hc.core.net.Ports;
import com.bes.enterprise.hc.core.util.Args;

@Internal
public final class EndpointParameters
implements NamedEndpoint {
    private final String scheme;
    private final String hostName;
    private final int port;
    private final Object attachment;

    public EndpointParameters(String scheme, String hostName, int port, Object attachment) {
        this.scheme = Args.notBlank(scheme, "Protocol scheme");
        this.hostName = Args.notBlank(hostName, "Endpoint name");
        this.port = Ports.checkWithDefault(port);
        this.attachment = attachment;
    }

    public EndpointParameters(HttpHost host, Object attachment) {
        Args.notNull(host, "HTTP host");
        this.scheme = host.getSchemeName();
        this.hostName = host.getHostName();
        this.port = host.getPort();
        this.attachment = attachment;
    }

    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public String toString() {
        return "EndpointParameters{scheme='" + this.scheme + '\'' + ", name='" + this.hostName + '\'' + ", port=" + this.port + ", attachment=" + this.attachment + '}';
    }
}

