/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.hc.core.reactor;

import com.bes.enterprise.hc.core.io.CloseMode;
import com.bes.enterprise.hc.core.io.Closer;
import com.bes.enterprise.hc.core.reactor.IOReactor;
import com.bes.enterprise.hc.core.reactor.IOReactorStatus;
import com.bes.enterprise.hc.core.util.Args;
import com.bes.enterprise.hc.core.util.TimeValue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

class MultiCoreIOReactor
implements IOReactor {
    private final IOReactor[] ioReactors;
    private final Thread[] threads;
    private final AtomicReference<IOReactorStatus> status;
    private final AtomicBoolean terminated;

    MultiCoreIOReactor(IOReactor[] ioReactors, Thread[] threads) {
        this.ioReactors = (IOReactor[])ioReactors.clone();
        this.threads = (Thread[])threads.clone();
        this.status = new AtomicReference<IOReactorStatus>(IOReactorStatus.INACTIVE);
        this.terminated = new AtomicBoolean();
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.status.get();
    }

    public final void start() {
        if (this.status.compareAndSet(IOReactorStatus.INACTIVE, IOReactorStatus.ACTIVE)) {
            for (int i2 = 0; i2 < this.threads.length; ++i2) {
                this.threads[i2].start();
            }
        }
    }

    @Override
    public final void initiateShutdown() {
        if (this.status.compareAndSet(IOReactorStatus.INACTIVE, IOReactorStatus.SHUT_DOWN) || this.status.compareAndSet(IOReactorStatus.ACTIVE, IOReactorStatus.SHUTTING_DOWN)) {
            for (int i2 = 0; i2 < this.ioReactors.length; ++i2) {
                IOReactor ioReactor = this.ioReactors[i2];
                ioReactor.initiateShutdown();
            }
        }
    }

    @Override
    public final void awaitShutdown(TimeValue waitTime) throws InterruptedException {
        int i2;
        Args.notNull(waitTime, "Wait time");
        long deadline = System.currentTimeMillis() + waitTime.toMilliseconds();
        long remaining = waitTime.toMilliseconds();
        for (i2 = 0; i2 < this.ioReactors.length; ++i2) {
            IOReactor ioReactor = this.ioReactors[i2];
            if (ioReactor.getStatus().compareTo(IOReactorStatus.SHUT_DOWN) >= 0) continue;
            ioReactor.awaitShutdown(TimeValue.of(remaining, TimeUnit.MILLISECONDS));
            remaining = deadline - System.currentTimeMillis();
            if (remaining > 0L) continue;
            return;
        }
        for (i2 = 0; i2 < this.threads.length; ++i2) {
            Thread thread = this.threads[i2];
            thread.join(remaining);
            remaining = deadline - System.currentTimeMillis();
            if (remaining > 0L) continue;
            return;
        }
    }

    @Override
    public final void close(CloseMode closeMode) {
        if (closeMode == CloseMode.GRACEFUL) {
            this.initiateShutdown();
            try {
                this.awaitShutdown(TimeValue.ofSeconds(5L));
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
        }
        this.status.set(IOReactorStatus.SHUT_DOWN);
        if (this.terminated.compareAndSet(false, true)) {
            int i2;
            for (i2 = 0; i2 < this.ioReactors.length; ++i2) {
                Closer.close(this.ioReactors[i2], CloseMode.IMMEDIATE);
            }
            for (i2 = 0; i2 < this.threads.length; ++i2) {
                this.threads[i2].interrupt();
            }
        }
    }

    @Override
    public final void close() {
        this.close(CloseMode.GRACEFUL);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [status=" + this.status + "]";
    }
}

