/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.logging;

import com.bes.enterprise.logging.AsyncRecord;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class BESLogFormatter
extends Formatter {
    private static final char FIELD_SEPARATOR = '|';
    public static final char NVPAIR_SEPARATOR = ';';
    public static final char NV_SEPARATOR = '=';
    private static final String RECORD_BEGIN_MARKER = "##|";
    private static final String LINE_SEPARATOR;
    private static final String RECORD_END_MARKER;
    private static boolean LOG_SOURCE_IN_KEY_VALUE;
    private static boolean RECORD_NUMBER_IN_KEY_VALUE;
    private long recordNumber = 0L;
    private static final String timeFormat = "yyyy-MM-dd HH:mm:ss.SSS";

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        sb.append(RECORD_BEGIN_MARKER);
        SimpleDateFormat dateFormatter = new SimpleDateFormat(timeFormat);
        sb.append(dateFormatter.format(record.getMillis()));
        sb.append('|');
        sb.append(record.getLevel());
        sb.append('|');
        String moduleName = LogManager.getLogManager().getProperty(record.getLoggerName() + ".module");
        if (moduleName == null || "null".equals(moduleName)) {
            moduleName = record.getLoggerName();
        }
        sb.append(moduleName);
        sb.append('|');
        sb.append("_ThreadID").append('=');
        sb.append(record.getThreadID());
        sb.append(";");
        sb.append("_ThreadName").append('=');
        if (record instanceof AsyncRecord) {
            sb.append(((AsyncRecord)record).getThreadName());
        } else {
            sb.append(Thread.currentThread().getName());
        }
        sb.append('|');
        Level level = record.getLevel();
        if (LOG_SOURCE_IN_KEY_VALUE || level.intValue() <= Level.FINE.intValue()) {
            sb.append("ClassName").append('=');
            sb.append(record.getSourceClassName());
            sb.append(';');
            sb.append("MethodName").append('=');
            sb.append(record.getSourceMethodName());
            sb.append(';');
        }
        if (RECORD_NUMBER_IN_KEY_VALUE) {
            sb.append("RecordNumber").append('=');
            sb.append(this.recordNumber++).append(';');
        }
        if (LOG_SOURCE_IN_KEY_VALUE || RECORD_NUMBER_IN_KEY_VALUE) {
            sb.append('|');
        }
        sb.append(this.formatMessage(record));
        if (record.getThrown() != null) {
            sb.append(LINE_SEPARATOR);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            record.getThrown().printStackTrace(pw);
            pw.close();
            sb.append(sw.getBuffer());
        }
        sb.append(RECORD_END_MARKER);
        return sb.toString();
    }

    static {
        String recordCount;
        LINE_SEPARATOR = System.getProperty("line.separator", "\n");
        RECORD_END_MARKER = "|##" + LINE_SEPARATOR;
        LOG_SOURCE_IN_KEY_VALUE = false;
        RECORD_NUMBER_IN_KEY_VALUE = false;
        String logSource = System.getProperty("com.bes.logging.keyvalue.logsource");
        if (logSource != null && logSource.equals("true")) {
            LOG_SOURCE_IN_KEY_VALUE = true;
        }
        if ((recordCount = System.getProperty("com.bes.logging.keyvalue.recordnumber")) != null && recordCount.equals("true")) {
            RECORD_NUMBER_IN_KEY_VALUE = true;
        }
    }
}

