/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.logging;

import com.bes.enterprise.appserver.common.util.ServerLayoutConstants;
import com.bes.enterprise.config.miniparser.ConfigBindingException;
import com.bes.enterprise.config.miniparser.DomTemplate;
import com.bes.enterprise.config.provider.ConfigProvider;
import com.bes.enterprise.config.provider.ConfigProviderException;
import com.bes.enterprise.config.provider.ConfigProviderFactory;
import com.bes.enterprise.config.provider.ConfigProviderGlobals;
import com.bes.enterprise.config.provider.ConfigProviderHelper;
import com.bes.enterprise.config.provider.FileConfigProvider;
import com.bes.enterprise.logging.ClassLoaderLogManager;
import com.bes.enterprise.logging.WebappProperties;
import com.bes.enterprise.logging.internal.LogConfigurationException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;

public class BESLogManager
extends ClassLoaderLogManager {
    private DomTemplate logService = null;
    private String ROOT_HANDLERS = "com.bes.enterprise.logging.AsyncFileHandlerEx,com.bes.enterprise.logging.AsyncConsoleHandlerEx";
    private static final boolean VERBOSE;

    public BESLogManager() {
        try {
            DomTemplate server = BESLogManager.initConfig();
            this.logService = server.getElement("log-service");
        }
        catch (Exception ex) {
            throw new RuntimeException("Failure to initialize configuration!", ex);
        }
        if (!VERBOSE) {
            this.ROOT_HANDLERS = "com.bes.enterprise.logging.AsyncFileHandlerEx";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void readConfiguration(ClassLoader classLoader) throws IOException {
        String configFileStr;
        ClassLoaderLogManager.ClassLoaderLogInfo info;
        InputStream is;
        block23: {
            is = null;
            try {
                if (classLoader instanceof WebappProperties) {
                    if (((WebappProperties)((Object)classLoader)).hasLoggingConfig()) {
                        is = classLoader.getResourceAsStream("logging.properties");
                    }
                } else if (classLoader instanceof URLClassLoader) {
                    URL logConfig = ((URLClassLoader)classLoader).findResource("logging.properties");
                    if (null != logConfig) {
                        if (Boolean.getBoolean(DEBUG_PROPERTY)) {
                            System.err.println(this.getClass().getName() + ".readConfiguration(): Found logging.properties at " + logConfig);
                        }
                        is = classLoader.getResourceAsStream("logging.properties");
                    } else if (Boolean.getBoolean(DEBUG_PROPERTY)) {
                        System.err.println(this.getClass().getName() + ".readConfiguration(): Found no logging.properties");
                    }
                }
            }
            catch (AccessControlException ace) {
                Logger log;
                info = (ClassLoaderLogManager.ClassLoaderLogInfo)this.classLoaderLoggers.get(ClassLoader.getSystemClassLoader());
                if (info == null || (log = info.loggers.get("")) == null) break block23;
                Permission perm = ace.getPermission();
                if (perm instanceof FilePermission && perm.getActions().equals("read")) {
                    log.warning("Reading " + perm.getName() + " is not permitted. See \"per context logging\" in the default server.policy file.");
                }
                log.warning("Reading logging.properties is not permitted in some context. See \"per context logging\" in the default server.policy file.");
                log.warning("Original error was: " + ace.getMessage());
            }
        }
        if (is == null && classLoader == ClassLoader.getSystemClassLoader() && (configFileStr = System.getProperty("java.util.logging.config.file")) != null) {
            try {
                is = new FileInputStream(this.replace(configFileStr));
            }
            catch (IOException e2) {
                System.err.println("Configuration error");
                e2.printStackTrace();
            }
        }
        ClassLoaderLogManager.RootLogger localRootLogger = new ClassLoaderLogManager.RootLogger();
        if (is == null && classLoader != ClassLoader.getSystemClassLoader()) {
            ClassLoaderLogManager.ClassLoaderLogInfo info2 = null;
            for (ClassLoader current = classLoader.getParent(); current != null && info2 == null; current = current.getParent()) {
                info2 = this.getClassLoaderInfo(current);
            }
            if (info2 != null) {
                localRootLogger.setParent(info2.rootNode.logger);
            }
        }
        info = new ClassLoaderLogManager.ClassLoaderLogInfo(new ClassLoaderLogManager.LogNode(null, localRootLogger));
        this.classLoaderLoggers.put(classLoader, info);
        if (is != null) {
            this.readConfiguration(is, classLoader);
        } else if (classLoader == ClassLoader.getSystemClassLoader()) {
            this.readBESConfiguration(classLoader);
        }
        try {
            addingLocalRootLogger.set(Boolean.TRUE);
            this.addLogger(localRootLogger);
        }
        finally {
            addingLocalRootLogger.set(Boolean.FALSE);
        }
    }

    protected synchronized void readBESConfiguration(ClassLoader classLoader) throws IOException {
        ClassLoaderLogManager.ClassLoaderLogInfo info = (ClassLoaderLogManager.ClassLoaderLogInfo)this.classLoaderLoggers.get(classLoader);
        List<DomTemplate> mLevels = this.logService.getElements("module-log-level");
        for (DomTemplate moduleLogLevel : mLevels) {
            String[] names;
            String loggerNames = moduleLogLevel.getAttribute("logger-names");
            String moduleNmae = moduleLogLevel.getAttribute("module-name");
            if (!info.props.contains(moduleNmae + ".level")) {
                info.props.put(moduleNmae + ".level", moduleLogLevel.getAttribute("level"));
            }
            for (String name : names = loggerNames.split(";")) {
                if ("".equals(name)) continue;
                if (!info.props.contains(name + ".level")) {
                    info.props.put(name + ".level", moduleLogLevel.getAttribute("level"));
                }
                if (info.props.contains(name + ".level")) continue;
                info.props.put(name + ".module", moduleNmae);
            }
        }
        String handlers = this.ROOT_HANDLERS;
        if (this.logService.getAttribute("log-handlers") != null) {
            handlers = handlers + "," + this.logService.getAttribute("log-handlers");
        }
        if (!info.props.contains(".handlers")) {
            info.props.put(".handlers", this.ROOT_HANDLERS);
        }
        if (handlers != null) {
            StringTokenizer tok = new StringTokenizer(handlers, ",");
            while (tok.hasMoreTokens()) {
                int pos;
                String handlerName = tok.nextToken().trim();
                if (info.handlers.containsKey(handlerName)) continue;
                String handlerClassName = handlerName;
                String prefix = "";
                if (handlerClassName.length() <= 0) continue;
                if (Character.isDigit(handlerClassName.charAt(0)) && (pos = handlerClassName.indexOf(46)) >= 0) {
                    prefix = handlerClassName.substring(0, pos + 1);
                    handlerClassName = handlerClassName.substring(pos + 1);
                }
                try {
                    this.prefix.set(prefix);
                    Handler handler = (Handler)classLoader.loadClass(handlerClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.prefix.set(null);
                    info.handlers.put(handlerName, handler);
                }
                catch (Exception e2) {
                    System.err.println("Handler error");
                    e2.printStackTrace();
                }
            }
        }
    }

    @Override
    public String getProperty(String name) {
        if (name.endsWith(".filter")) {
            return this.getLoggerFilter();
        }
        if (!name.endsWith(".module")) {
            return super.getProperty(name);
        }
        String result = super.getProperty(name);
        String loggerName = name.substring(0, name.indexOf(".module"));
        while ((result == null || result.isEmpty()) && loggerName.indexOf(".") != -1) {
            loggerName = loggerName.substring(0, loggerName.lastIndexOf("."));
            result = super.getProperty(loggerName + ".module");
        }
        return result;
    }

    private String getLoggerFilter() {
        return this.logService.getAttribute("log-filter");
    }

    private static String absoluteConfigFile(String configFile) {
        File file = new File(configFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("com.bes.instanceRoot"), configFile);
        }
        return file.getAbsolutePath();
    }

    public static DomTemplate initConfig() throws ConfigProviderException, LogConfigurationException, ConfigBindingException, XMLStreamException {
        String installRootPath = System.getProperty(ServerLayoutConstants.INSTALL_ROOT_PROPERTY);
        if (installRootPath == null) {
            File jarLocation = BESLogManager.jarLocatation(BESLogManager.class);
            installRootPath = jarLocation.getParent();
            System.setProperty(ServerLayoutConstants.INSTALL_ROOT_PROPERTY, installRootPath);
        }
        File installRoot = new File(installRootPath);
        ClassLoader configProviderClasslaoder = null;
        try {
            configProviderClasslaoder = BESLogManager.buildConfigProviderClassLoader(installRoot);
        }
        catch (MalformedURLException mlfEx) {
            mlfEx.printStackTrace();
            System.out.println("Failure to create config provider classloader!");
            System.exit(1);
        }
        Thread.currentThread().setContextClassLoader(configProviderClasslaoder);
        String instanceRoot = System.getProperty(ServerLayoutConstants.INSTANCE_ROOT_PROPERTY);
        File confDir = new File(instanceRoot, ServerLayoutConstants.CONFIG_DIR);
        File configFile = new File(confDir, ServerLayoutConstants.CONFIG_FILENAME);
        ConfigProvider provider = BESLogManager.getConfigProvider(configFile.getAbsolutePath());
        System.out.println("Loading configuration from: " + provider.getIdentifier() + ".");
        String configText = BESLogManager.getConfigText(provider);
        DomTemplate domTemplate = BESLogManager.parseConfig(configText);
        ConfigProviderGlobals.addGlobalItem("rootConfig", domTemplate);
        Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        return domTemplate;
    }

    protected static ConfigProvider getConfigProvider(String defaultConfigFile) throws ConfigProviderException {
        Map<String, String> configProperties = ConfigProviderFactory.getConfigProperites();
        String provider = configProperties.get(ConfigProvider.PROVIDER_CLASS);
        if (provider == null) {
            configProperties.put(ConfigProvider.PROVIDER_CLASS, FileConfigProvider.class.getCanonicalName());
            configProperties.put(FileConfigProvider.FILE_URI, defaultConfigFile);
        }
        ConfigProvider configProvider = ConfigProviderFactory.getConfigProvider(configProperties);
        return configProvider;
    }

    protected static String getConfigText(ConfigProvider provider) throws ConfigProviderException {
        String providentifier = provider.getIdentifier();
        String configText = provider.getConfigText();
        if (configText == null) {
            throw new ConfigProviderException("Failure to loading configuration from: " + provider.getIdentifier() + "!");
        }
        return configText;
    }

    private static DomTemplate parseConfig(String configText) throws ConfigBindingException, XMLStreamException {
        DomTemplate domTemplate = ConfigProviderHelper.parse(configText);
        return domTemplate;
    }

    private static ClassLoader buildConfigProviderClassLoader(File installRootDir) throws MalformedURLException {
        File[] libJars;
        ArrayList<URL> urls = new ArrayList<URL>();
        FileFilter jarFileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".jar");
            }
        };
        File libDir = new File(installRootDir, "lib");
        for (File jarFile : libJars = libDir.listFiles(jarFileFilter)) {
            urls.add(jarFile.toURI().toURL());
        }
        File pluginJarsDir = new File(installRootDir, "plugins");
        if (pluginJarsDir.exists()) {
            File[] pluginJars;
            for (File jarFile : pluginJars = pluginJarsDir.listFiles(jarFileFilter)) {
                urls.add(jarFile.toURI().toURL());
            }
        }
        URLClassLoader urlClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), ClassLoader.getSystemClassLoader());
        return urlClassLoader;
    }

    private static File jarLocatation(Class clazz) {
        String resourceName = clazz.getName().replace(".", "/") + ".class";
        URL resource = clazz.getClassLoader().getResource(resourceName);
        if (resource == null) {
            throw new IllegalArgumentException("Cannot get install path from " + clazz + " class location!");
        }
        if (resource.getProtocol().equals("jar")) {
            try {
                JarURLConnection c2 = (JarURLConnection)resource.openConnection();
                URL jarFile = c2.getJarFileURL();
                try {
                    return new File(jarFile.toURI());
                }
                catch (URISyntaxException e2) {
                    return new File(jarFile.getPath());
                }
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Cannot open jar file " + resource + "!", ex);
            }
        }
        throw new IllegalArgumentException("Don't support packaging " + resource + "!");
    }

    static {
        System.setProperty(ServerLayoutConstants.LOGGING_NOT_REDIRECT_PROP, System.getProperty(ServerLayoutConstants.LOGGING_NOT_REDIRECT_PROP, "true"));
        System.setProperty(ServerLayoutConstants.LOGGING_VERBOSE_PROP, System.getProperty(ServerLayoutConstants.LOGGING_VERBOSE_PROP, "true"));
        VERBOSE = Boolean.getBoolean("com.bes.enterprise.log.verbose");
    }
}

