/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.naming;

import java.util.Enumeration;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class GlobalResourceRef
extends Reference {
    public static final String DEFAULT_FACTORY = "com.bes.enterprise.naming.factory.GlobalResourceRefFactory";
    public static final String LOOKUP_NAME = "lookupName";

    public GlobalResourceRef(String className) {
        super(className);
    }

    public GlobalResourceRef(String className, String factory, String factoryLocation) {
        super(className, factory, factoryLocation);
    }

    public GlobalResourceRef(String resourceClass, String description, String scope, String auth, boolean singleton) {
        this(resourceClass, description, scope, auth, singleton, null, null);
    }

    public GlobalResourceRef(String resourceClass, String description, String scope, String auth, boolean singleton, String factory, String factoryLocation) {
        super(resourceClass, factory, factoryLocation);
        StringRefAddr refAddr = null;
        if (description != null) {
            refAddr = new StringRefAddr("description", description);
            this.add(refAddr);
        }
        if (scope != null) {
            refAddr = new StringRefAddr("scope", scope);
            this.add(refAddr);
        }
        if (auth != null) {
            refAddr = new StringRefAddr("auth", auth);
            this.add(refAddr);
        }
        refAddr = new StringRefAddr("singleton", Boolean.toString(singleton));
        this.add(refAddr);
    }

    @Override
    public String getFactoryClassName() {
        String factory = super.getFactoryClassName();
        if (factory != null) {
            return factory;
        }
        return DEFAULT_FACTORY;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ContextResourceRef[");
        sb.append("className=");
        sb.append(this.getClassName());
        sb.append(",factoryClassLocation=");
        sb.append(this.getFactoryClassLocation());
        sb.append(",factoryClassName=");
        sb.append(this.getFactoryClassName());
        Enumeration<RefAddr> refAddrs = this.getAll();
        while (refAddrs.hasMoreElements()) {
            RefAddr refAddr = refAddrs.nextElement();
            sb.append(",{type=");
            sb.append(refAddr.getType());
            sb.append(",content=");
            sb.append(refAddr.getContent());
            sb.append("}");
        }
        sb.append("]");
        return sb.toString();
    }
}

