/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.naming.factory;

import com.bes.enterprise.naming.EjbRef;
import com.bes.enterprise.naming.factory.FactoryBase;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class EjbFactory
extends FactoryBase {
    @Override
    protected boolean isReferenceTypeSupported(Object obj) {
        return obj instanceof EjbRef;
    }

    @Override
    protected ObjectFactory getDefaultFactory(Reference ref) throws NamingException {
        ObjectFactory factory;
        String javaxEjbFactoryClassName = System.getProperty("javax.ejb.Factory", "com.bes.enterprise.naming.factory.BesFactory");
        try {
            factory = (ObjectFactory)Class.forName(javaxEjbFactoryClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t2) {
            if (t2 instanceof NamingException) {
                throw (NamingException)t2;
            }
            if (t2 instanceof ThreadDeath) {
                throw (ThreadDeath)t2;
            }
            if (t2 instanceof VirtualMachineError) {
                throw (VirtualMachineError)t2;
            }
            NamingException ex = new NamingException("Could not create resource factory instance");
            ex.initCause(t2);
            throw ex;
        }
        return factory;
    }

    @Override
    protected Object getLinked(Reference ref) throws NamingException {
        RefAddr linkRefAddr = ref.get("link");
        if (linkRefAddr != null) {
            String ejbLink = linkRefAddr.getContent().toString();
            Object beanObj = new InitialContext().lookup(ejbLink);
            return beanObj;
        }
        return null;
    }
}

