/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.naming.factory;

import com.bes.enterprise.naming.ContextBindings;
import com.bes.enterprise.naming.GlobalResourceRef;
import com.bes.enterprise.naming.StringManager;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class GlobalResourceRefFactory
implements ObjectFactory {
    private static final StringManager sm = StringManager.getManager(GlobalResourceRefFactory.class);

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (!(obj instanceof GlobalResourceRef)) {
            return null;
        }
        Reference ref = (Reference)obj;
        String globalName = null;
        RefAddr refAddr = ref.get("lookupName");
        if (refAddr != null) {
            globalName = refAddr.getContent().toString();
            String expectedClassName = ref.getClassName();
            if (expectedClassName == null) {
                throw new IllegalArgumentException(sm.getString("globalResourceRefFactory.nullType", name, globalName));
            }
            Context globalContext = ContextBindings.getSystemRootContext();
            Object result = globalContext.lookup(globalName);
            if (result == null) {
                return null;
            }
            try {
                Class<?> expectedClazz = Class.forName(expectedClassName, true, Thread.currentThread().getContextClassLoader());
                if (!expectedClazz.isAssignableFrom(result.getClass())) {
                    throw new IllegalArgumentException(sm.getString("globalResourceRefFactory.wrongType", name, globalName, expectedClassName, result.getClass().getName()));
                }
            }
            catch (ClassNotFoundException e2) {
                throw new IllegalArgumentException(sm.getString("globalResourceRefFactory.unknownType", name, globalName, expectedClassName), e2);
            }
            return result;
        }
        return null;
    }
}

