/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.naming.factory;

import com.bes.enterprise.naming.ResourceRef;
import com.bes.enterprise.naming.StringManager;
import com.bes.enterprise.naming.factory.FactoryBase;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class ResourceFactory
extends FactoryBase {
    private static final StringManager sm = StringManager.getManager(ResourceFactory.class);

    @Override
    protected boolean isReferenceTypeSupported(Object obj) {
        return obj instanceof ResourceRef;
    }

    @Override
    protected ObjectFactory getDefaultFactory(Reference ref) throws NamingException {
        ObjectFactory factory = null;
        if (ref.getClassName().equals("javax.sql.DataSource") || ref.getClassName().equals("javax.sql.XADataSource") || ref.getClassName().equals("javax.sql.ConnectionPoolDataSource") || ref.getClassName().equals("java.sql.Driver")) {
            String javaxSqlDataSourceFactoryClassName = System.getProperty("javax.sql.DataSource.Factory", "com.bes.enterprise.gjc.spi.BasicDataSourceFactory");
            try {
                factory = (ObjectFactory)Class.forName(javaxSqlDataSourceFactoryClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e2) {
                NamingException ex = new NamingException(sm.getString("resourceFactory.factoryCreationError"));
                ex.initCause(e2);
                throw ex;
            }
        }
        if (ref.getClassName().equals("javax.mail.Session")) {
            String javaxMailSessionFactoryClassName = System.getProperty("javax.mail.Session.Factory", "com.bes.enterprise.naming.factory.MailSessionFactory");
            try {
                factory = (ObjectFactory)Class.forName(javaxMailSessionFactoryClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t2) {
                if (t2 instanceof NamingException) {
                    throw (NamingException)t2;
                }
                if (t2 instanceof ThreadDeath) {
                    throw (ThreadDeath)t2;
                }
                if (t2 instanceof VirtualMachineError) {
                    throw (VirtualMachineError)t2;
                }
                NamingException ex = new NamingException(sm.getString("resourceFactory.factoryCreationError"));
                ex.initCause(t2);
                throw ex;
            }
        }
        return factory;
    }

    @Override
    protected Object getLinked(Reference ref) {
        return null;
    }
}

