/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.naming.plus.jndi;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.naming.plus.jndi.NamingEntryUtil;
import com.bes.enterprise.naming.plus.jndi.NamingUtil;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;

public abstract class NamingEntry {
    private static final Log log = LogFactory.getLog(NamingEntry.class);
    public static final String __contextName = "__";
    protected final Object _scope;
    protected final String _jndiName;
    protected String _namingEntryNameString;
    protected String _objectNameString;

    protected NamingEntry(Object scope, String jndiName) throws NamingException {
        if (jndiName == null) {
            throw new NamingException("jndi name is null");
        }
        this._scope = scope;
        this._jndiName = jndiName;
    }

    protected NamingEntry(String jndiName) throws NamingException {
        this(null, jndiName);
    }

    public void bindToENC(String localName) throws NamingException {
        InitialContext ic = new InitialContext();
        Context env = (Context)ic.lookup("java:comp/env");
        if (log.isDebugEnabled()) {
            log.debug("Binding java:comp/env/" + localName + " to " + this._objectNameString);
        }
        NamingUtil.bind(env, localName, new LinkRef(this._objectNameString));
    }

    public void unbindENC() {
        try {
            InitialContext ic = new InitialContext();
            Context env = (Context)ic.lookup("java:comp/env");
            if (log.isDebugEnabled()) {
                log.debug("Unbinding java:comp/env/" + this.getJndiName());
            }
            env.unbind(this.getJndiName());
        }
        catch (NamingException e2) {
            log.warn(e2);
        }
    }

    public void release() {
        try {
            InitialContext ic = new InitialContext();
            ic.unbind(this._objectNameString);
            ic.unbind(this._namingEntryNameString);
            this._namingEntryNameString = null;
            this._objectNameString = null;
        }
        catch (NamingException e2) {
            log.warn(e2);
        }
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public String getJndiNameInScope() {
        return this._objectNameString;
    }

    protected void save(Object object) throws NamingException {
        InitialContext ic = new InitialContext();
        NameParser parser = ic.getNameParser("");
        Name prefix = NamingEntryUtil.getNameForScope(this._scope);
        Name namingEntryName = NamingEntryUtil.makeNamingEntryName(parser, this.getJndiName());
        namingEntryName.addAll(0, prefix);
        this._namingEntryNameString = namingEntryName.toString();
        NamingUtil.bind(ic, this._namingEntryNameString, this);
        Name objectName = parser.parse(this.getJndiName());
        objectName.addAll(0, prefix);
        this._objectNameString = objectName.toString();
        NamingUtil.bind(ic, this._objectNameString, object);
    }

    protected String toStringMetaData() {
        return null;
    }

    public String toString() {
        String metadata = this.toStringMetaData();
        if (metadata == null) {
            return String.format("%s@%x{name=%s}", this.getClass().getName(), this.hashCode(), this.getJndiName());
        }
        return String.format("%s@%x{name=%s,%s}", this.getClass().getName(), this.hashCode(), this.getJndiName(), metadata);
    }
}

