/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.naming.plus.jndi;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.naming.plus.jndi.NamingEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class NamingEntryUtil {
    private static final Log log = LogFactory.getLog(NamingEntryUtil.class);

    public static boolean bindToENC(Object scope, String asName, String mappedName) throws NamingException {
        NamingEntry entry;
        if (asName == null || asName.trim().equals("")) {
            throw new NamingException("No name for NamingEntry");
        }
        if (mappedName == null || "".equals(mappedName)) {
            mappedName = asName;
        }
        if ((entry = NamingEntryUtil.lookupNamingEntry(scope, mappedName)) == null) {
            return false;
        }
        entry.bindToENC(asName);
        return true;
    }

    public static NamingEntry lookupNamingEntry(Object scope, String jndiName) throws NamingException {
        NamingEntry entry = null;
        try {
            Name scopeName = NamingEntryUtil.getNameForScope(scope);
            InitialContext ic = new InitialContext();
            NameParser parser = ic.getNameParser("");
            Name namingEntryName = NamingEntryUtil.makeNamingEntryName(parser, jndiName);
            scopeName.addAll(namingEntryName);
            entry = (NamingEntry)ic.lookup(scopeName);
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return entry;
    }

    public static Object lookup(Object scope, String jndiName) throws NamingException {
        Name scopeName = NamingEntryUtil.getNameForScope(scope);
        InitialContext ic = new InitialContext();
        NameParser parser = ic.getNameParser("");
        scopeName.addAll(parser.parse(jndiName));
        return ic.lookup(scopeName);
    }

    public static <T> List<? extends T> lookupNamingEntries(Object scope, Class<T> clazz) throws NamingException {
        try {
            Context scopeContext = NamingEntryUtil.getContextForScope(scope);
            Context namingEntriesContext = (Context)scopeContext.lookup("__");
            ArrayList<Object> list = new ArrayList<Object>();
            NamingEntryUtil.lookupNamingEntries(list, namingEntriesContext, clazz);
            return list;
        }
        catch (NameNotFoundException e2) {
            return Collections.emptyList();
        }
    }

    public static Name makeNamingEntryName(NameParser parser, NamingEntry namingEntry) throws NamingException {
        return NamingEntryUtil.makeNamingEntryName(parser, namingEntry == null ? null : namingEntry.getJndiName());
    }

    public static Name makeNamingEntryName(NameParser parser, String jndiName) throws NamingException {
        if (jndiName == null) {
            return null;
        }
        if (parser == null) {
            InitialContext ic = new InitialContext();
            parser = ic.getNameParser("");
        }
        Name name = parser.parse("");
        name.add("__");
        name.addAll(parser.parse(jndiName));
        return name;
    }

    public static Name getNameForScope(Object scope) {
        try {
            InitialContext ic = new InitialContext();
            NameParser parser = ic.getNameParser("");
            Name name = parser.parse("");
            if (scope != null) {
                name.add(NamingEntryUtil.canonicalizeScope(scope));
            }
            return name;
        }
        catch (NamingException e2) {
            log.warn(e2);
            return null;
        }
    }

    public static Context getContextForScope(Object scope) throws NamingException {
        InitialContext ic = new InitialContext();
        NameParser parser = ic.getNameParser("");
        Name name = parser.parse("");
        if (scope != null) {
            name.add(NamingEntryUtil.canonicalizeScope(scope));
        }
        return (Context)ic.lookup(name);
    }

    public static Context getContextForNamingEntries(Object scope) throws NamingException {
        Context scopeContext = NamingEntryUtil.getContextForScope(scope);
        return (Context)scopeContext.lookup("__");
    }

    private static List<Object> lookupNamingEntries(List<Object> list, Context context, Class<?> clazz) throws NamingException {
        block4: {
            try {
                NamingEnumeration<Binding> nenum = context.listBindings("");
                while (nenum.hasMoreElements()) {
                    Binding binding = nenum.next();
                    if (binding.getObject() instanceof Context) {
                        NamingEntryUtil.lookupNamingEntries(list, (Context)binding.getObject(), clazz);
                        continue;
                    }
                    if (!clazz.isInstance(binding.getObject())) continue;
                    list.add(binding.getObject());
                }
            }
            catch (NameNotFoundException e2) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("No entries of type " + clazz.getName() + " in context=" + context);
            }
        }
        return list;
    }

    private static String canonicalizeScope(Object scope) {
        if (scope == null) {
            return "";
        }
        String str = scope.getClass().getName() + "@" + Long.toHexString(scope.hashCode());
        str = NamingEntryUtil.replace(str, '/', '_');
        str = NamingEntryUtil.replace(str, ' ', '_');
        return str;
    }

    private static String replace(String str, char find, char with) {
        if (str == null) {
            return null;
        }
        if (find == with) {
            return str;
        }
        int c2 = 0;
        int idx = str.indexOf(find, c2);
        if (idx == -1) {
            return str;
        }
        char[] chars = str.toCharArray();
        int len = chars.length;
        for (int i2 = idx; i2 < len; ++i2) {
            if (chars[i2] != find) continue;
            chars[i2] = with;
        }
        return String.valueOf(chars);
    }
}

