/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.naming.plus.jndi;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class NamingUtil {
    private static final Log log = LogFactory.getLog(NamingUtil.class);

    public static Context bind(Context ctx, String nameStr, Object obj) throws NamingException {
        Name name = ctx.getNameParser("").parse(nameStr);
        if (name.size() == 0) {
            return null;
        }
        Context subCtx = ctx;
        for (int i2 = 0; i2 < name.size() - 1; ++i2) {
            try {
                subCtx = (Context)subCtx.lookup(name.get(i2));
                if (!log.isDebugEnabled()) continue;
                log.debug("Subcontext " + name.get(i2) + " already exists");
                continue;
            }
            catch (NameNotFoundException e2) {
                subCtx = subCtx.createSubcontext(name.get(i2));
                if (!log.isDebugEnabled()) continue;
                log.debug("Subcontext " + name.get(i2) + " created");
            }
        }
        subCtx.rebind(name.get(name.size() - 1), obj);
        if (log.isDebugEnabled()) {
            log.debug("Bound object to " + name.get(name.size() - 1));
        }
        return subCtx;
    }

    public static void unbind(Context ctx) throws NamingException {
        NamingEnumeration<Binding> ne = ctx.listBindings(ctx.getNameInNamespace());
        while (ne.hasMoreElements()) {
            Binding b2 = (Binding)ne.nextElement();
            if (b2.getObject() instanceof Context) {
                NamingUtil.unbind((Context)b2.getObject());
                continue;
            }
            ctx.unbind(b2.getName());
        }
    }

    public static Map flattenBindings(Context ctx, String name) throws NamingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Context c2 = (Context)ctx.lookup(name);
        NameParser parser = c2.getNameParser("");
        NamingEnumeration<Binding> enm = ctx.listBindings(name);
        while (enm.hasMore()) {
            Binding b2 = enm.next();
            if (b2.getObject() instanceof Context) {
                map.putAll(NamingUtil.flattenBindings(c2, b2.getName()));
                continue;
            }
            Name compoundName = parser.parse(c2.getNameInNamespace());
            compoundName.add(b2.getName());
            map.put(compoundName.toString(), b2.getObject());
        }
        return map;
    }
}

