/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.security.serializer;

import com.bes.enterprise.common.cache.Cache;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class JavaSerializerChecker {
    protected static final Logger _logger = Logger.getLogger(JavaSerializerChecker.class.getName());
    private static final String SERIALIZER_CHECKER_ENABLED = "com.bes.enterprise.security.serializer.JavaSerializerChecker.enabled";
    private static final String BLACK_LIST_FILE = "com.bes.enterprise.security.serializer.JavaSerializerChecker.blacklistFile";
    private static final String WHITE_LIST_FILE = "com.bes.enterprise.security.serializer.JavaSerializerChecker.whitelistFile";
    private static final String DEFAULT_BLACK_LIST_FILE = "javaSerializerSecurity/javaBlackList";
    private static final String DEFAULT_WHITE_LIST_FILE = "javaSerializerSecurity/javaWhitelist";
    private static final String CACHE_CLASS = "com.bes.enterprise.security.serializer.JavaSerializerChecker.cacheClass";
    private static final String DEFAULT_CACHE_CLASS = "com.bes.enterprise.common.cache.ConcurrentLRUCache";
    private static final String MAX_CACHE_SIZE = "com.bes.enterprise.security.serializer.JavaSerializerChecker.maxCacheSize";
    private static final int DEFAULT_MAX_CACHE_SIZE = 10240;
    private static final boolean enabled = Boolean.parseBoolean(System.getProperty("com.bes.enterprise.security.serializer.JavaSerializerChecker.enabled", "true"));
    private static final List<String> blackList = new ArrayList<String>();
    private static final List<String> whiteList = new ArrayList<String>();
    private static Cache<String, Boolean> checkResult;
    private static volatile boolean initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() throws IOException {
        if (initialized) {
            return;
        }
        Class<JavaSerializerChecker> clazz = JavaSerializerChecker.class;
        synchronized (JavaSerializerChecker.class) {
            if (initialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            if (enabled) {
                String blackListFile = System.getProperty(BLACK_LIST_FILE);
                if (blackListFile == null) {
                    blackListFile = DEFAULT_BLACK_LIST_FILE;
                }
                JavaSerializerChecker.loadConfig(blackListFile, blackList);
                String whiteListFile = System.getProperty(WHITE_LIST_FILE);
                if (whiteListFile == null) {
                    whiteListFile = DEFAULT_WHITE_LIST_FILE;
                }
                JavaSerializerChecker.loadConfig(whiteListFile, whiteList);
                JavaSerializerChecker.initCache();
            }
            initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    private static void initCache() throws IOException {
        String cacheClassVal;
        String maxCacheVal = System.getProperty(MAX_CACHE_SIZE);
        int maxCache = 10240;
        if (maxCacheVal != null) {
            try {
                int value = Integer.parseInt(maxCacheVal);
                if (value > 0) {
                    maxCache = value;
                }
            }
            catch (NumberFormatException value) {
                // empty catch block
            }
        }
        if ((cacheClassVal = System.getProperty(CACHE_CLASS)) == null) {
            cacheClassVal = DEFAULT_CACHE_CLASS;
        }
        try {
            ClassLoader loader = JavaSerializerChecker.class.getClassLoader();
            Class<?> cacheClass = loader.loadClass(cacheClassVal);
            Constructor<?> constructor = cacheClass.getDeclaredConstructor(Integer.TYPE);
            checkResult = (Cache)constructor.newInstance(maxCache);
        }
        catch (Exception ex) {
            throw new IOException("Failure to initialize cache!", ex);
        }
    }

    public static void allow(String className) throws IOException {
        if (!initialized) {
            JavaSerializerChecker.init();
        }
        if (!enabled) {
            return;
        }
        Boolean allow = checkResult.get(className);
        if (allow == null) {
            allow = JavaSerializerChecker.allowSerialize(className);
            checkResult.add(className, allow);
        }
        if (!allow.booleanValue()) {
            throw new IOException("Class " + className + " is in blacklist!");
        }
    }

    private static boolean allowSerialize(String className) {
        if (whiteList != null) {
            for (String prefix : whiteList) {
                if (!JavaSerializerChecker.matches(className, prefix)) continue;
                return Boolean.TRUE;
            }
        }
        for (String prefix : blackList) {
            if (!JavaSerializerChecker.matches(className, prefix)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static boolean matches(String className, String prefix) {
        return prefix.endsWith(".*") ? className.startsWith(prefix = prefix.substring(0, prefix.length() - 2)) : (prefix.endsWith("*") ? className.startsWith(prefix = prefix.substring(0, prefix.length() - 1)) : className.equals(prefix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadConfig(String configFile, List<String> nameList) {
        InputStream in = null;
        BufferedReader reader = null;
        try {
            in = JavaSerializerChecker.getInputStream(configFile);
            if (in != null) {
                String line;
                reader = new BufferedReader(new InputStreamReader(in));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.startsWith("//")) continue;
                    nameList.add(line);
                }
            }
        }
        catch (IOException ex) {
            _logger.warning(ex.getClass().getName() + ":" + ex.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static InputStream getInputStream(String configFile) throws IOException {
        ClassLoader loader = JavaSerializerChecker.class.getClassLoader();
        InputStream in = loader.getResourceAsStream(configFile);
        if (in != null) {
            return in;
        }
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        if (contextLoader != loader && (in = contextLoader.getResourceAsStream(configFile)) != null) {
            return in;
        }
        throw new IOException("Could not read config file: " + configFile + "!");
    }

    static {
        initialized = false;
    }
}

