/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.server.builder;

import com.bes.enterprise.appserver.common.util.JvmInfoUtil;
import com.bes.enterprise.appserver.common.util.ServerLayoutConstants;
import com.bes.enterprise.config.miniparser.DomTemplate;
import com.bes.enterprise.config.provider.ConfigProviderGlobals;
import com.bes.enterprise.config.provider.ShutdownHolder;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.server.builder.WebModuleBuilder;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.core.ApplicationServer;
import com.bes.enterprise.webtier.startup.ASMain;
import com.bes.enterprise.webtier.startup.Heaven;
import java.io.File;

public class BesWebModule
extends Heaven
implements ShutdownHolder {
    private static final Log log = LogFactory.getLog(BesWebModule.class);
    private String serverConfigFile = "conf/" + ServerLayoutConstants.CONFIG_FILENAME;
    private String pidFile = "conf/.pid";

    @Override
    public void load(String[] args) {
        this.load();
    }

    @Override
    public void load() {
        long t1 = System.nanoTime();
        File _pidFile = this.pidFile();
        JvmInfoUtil.logPID(_pidFile.getAbsolutePath());
        this.initDirs();
        this.initNaming();
        try {
            DomTemplate rootConfig = (DomTemplate)ConfigProviderGlobals.getGlobalItem("rootConfig");
            ConfigProviderGlobals.clear();
            ConfigProviderGlobals.setShutdownHolder(this);
            WebModuleBuilder builder = new WebModuleBuilder();
            builder.setClassLoader(this.parentClassLoader);
            builder.setBcsClassLoader(this.getBcsClassLoader());
            this.server = builder.buildWebContainer(rootConfig);
        }
        catch (Exception e2) {
            log.warn("Failure to start server!", e2);
            throw e2;
        }
        this.getServer().setHeaven(this);
        this.getServer().setHeavenHome(ASMain.getHeavenHomeFile());
        this.getServer().setHeavenBase(ASMain.getHeavenBaseFile());
        this.initStreams();
        try {
            this.getServer().init();
        }
        catch (LifecycleException e3) {
            if (Boolean.getBoolean("com.bes.enterprise.startup.EXIT_ON_INIT_FAILURE")) {
                throw new Error(e3);
            }
            log.error("Heaven.start", e3);
        }
        long t2 = System.nanoTime();
        if (log.isInfoEnabled()) {
            log.info("Application server initialization complete in " + (t2 - t1) / 1000000L + " ms");
        }
    }

    @Override
    public void start() {
        super.setAwait(false);
        super.start();
        super.await();
        super.stop();
    }

    @Override
    protected void initStreams() {
        super.initStreams();
    }

    @Override
    public void stop() {
        log.info("Stopping application server");
        ApplicationServer server = (ApplicationServer)super.getServer();
        server.stopAwait();
    }

    @Override
    public void shutdown() {
        this.stop();
    }

    @Override
    protected File configFile() {
        File file = new File(this.serverConfigFile);
        if (!file.isAbsolute()) {
            file = new File(ASMain.getHeavenBase(), this.serverConfigFile);
        }
        return file;
    }

    protected String absoluteConfigFile(String configFile) {
        File file = new File(configFile);
        if (!file.isAbsolute()) {
            file = new File(ASMain.getHeavenBase(), configFile);
        }
        return file.getAbsolutePath();
    }

    protected File pidFile() {
        File file = new File(this.pidFile);
        if (!file.isAbsolute()) {
            file = new File(ASMain.getHeavenBase(), this.pidFile);
        }
        return file;
    }

    @Override
    public String getConfigFile() {
        return this.serverConfigFile;
    }
}

