/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.server.builder;

import com.bes.enterprise.appserver.common.util.CommonUtils;
import com.bes.enterprise.appserver.common.util.ServerLayoutConstants;
import com.bes.enterprise.config.miniparser.ConfigBindingException;
import com.bes.enterprise.config.miniparser.DomParserContext;
import com.bes.enterprise.config.miniparser.DomTemplate;
import com.bes.enterprise.config.miniparser.DomTemplateParser;
import com.bes.enterprise.config.provider.ConfigProvider;
import com.bes.enterprise.config.provider.ConfigProviderException;
import com.bes.enterprise.config.provider.ConfigProviderFactory;
import com.bes.enterprise.config.provider.FileConfigProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ConfigHelper {
    public static DomTemplate getDomTemplate() throws Exception {
        String installRoot = System.getProperty(ServerLayoutConstants.INSTALL_ROOT_PROPERTY);
        File confDir = new File(installRoot, ServerLayoutConstants.CONFIG_DIR);
        File configFile = new File(confDir, ServerLayoutConstants.CONFIG_FILENAME);
        String configText = null;
        if (configFile.exists()) {
            ConfigProvider provider = ConfigHelper.getConfigProvider(configFile.getAbsolutePath());
            System.out.println("Loading configuration from: " + provider.getIdentifier() + ".");
            configText = ConfigHelper.getConfigText(provider);
        } else {
            configText = ConfigHelper.getConfigTextFromClassLoader();
        }
        DomTemplate domTemplate = ConfigHelper.parseConfig(configText);
        return domTemplate;
    }

    private static ConfigProvider getConfigProvider(String defaultConfigFile) throws ConfigProviderException {
        Map<String, String> configProperties = ConfigProviderFactory.getConfigProperites();
        String provider = configProperties.get(ConfigProvider.PROVIDER_CLASS);
        if (provider == null) {
            configProperties.put(ConfigProvider.PROVIDER_CLASS, FileConfigProvider.class.getCanonicalName());
            configProperties.put(FileConfigProvider.FILE_URI, defaultConfigFile);
        }
        ConfigProvider configProvider = ConfigProviderFactory.getConfigProvider(configProperties);
        return configProvider;
    }

    private static String getConfigTextFromClassLoader() {
        BufferedReader reader = null;
        InputStream in = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            in = loader.getResourceAsStream(ServerLayoutConstants.CONFIG_FILENAME);
            reader = new BufferedReader(new InputStreamReader(in));
            StringBuilder builder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            String string = builder.toString();
            return string;
        }
        catch (IOException ioEx) {
            throw new RuntimeException("Failure to load the config from context classloader!", ioEx);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getConfigText(ConfigProvider provider) throws ConfigProviderException {
        String configText = provider.getConfigText();
        if (configText == null) {
            throw new ConfigProviderException("Failure to loading configuration from: " + provider.getIdentifier() + "!");
        }
        return configText;
    }

    private static DomTemplate parseConfig(String configText) throws ConfigBindingException, XMLStreamException {
        XMLStreamReader reader = null;
        try {
            DomTemplate domTemplate;
            DomParserContext parseContext = ConfigHelper.getEmbeddedServerConfigParserContext();
            DomTemplateParser parser = new DomTemplateParser();
            StringReader sr = new StringReader(configText);
            reader = CommonUtils.newXMLInputFactory().createXMLStreamReader(sr);
            DomTemplate domTemplate2 = domTemplate = parser.parse(reader, parseContext);
            return domTemplate2;
        }
        catch (ConfigBindingException bindEx) {
            throw bindEx;
        }
        catch (XMLStreamException ex) {
            throw ex;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static DomParserContext getEmbeddedServerConfigParserContext() {
        DomParserContext parserContext = new DomParserContext();
        parserContext.addDomTemplateHandlers(new DomParserContext.PasswordEncryptedHandler());
        parserContext.addAttributeConfig("server", new DomParserContext.AttributeConfig().name("adminhost").defaultValue("127.0.0.1")).addAttributeConfig("server", new DomParserContext.AttributeConfig().name("adminport").defaultValue("-1")).addAttributeConfig("server", new DomParserContext.AttributeConfig().name("stop").defaultValue("stop"));
        parserContext.addAttributeConfig("server/system-property", new DomParserContext.AttributeConfig().name("name").required(true));
        parserContext.addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("enabled").defaultValue("true")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("jta-managed").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("driver-class-path")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("initial-pool-size").defaultValue("8")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("min-idle").defaultValue("8")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("max-pool-size").defaultValue("32")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("max-wait-time-in-millis").defaultValue("60000")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("validation-query")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("validation-query-timeout").defaultValue("0")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("test-on-borrow").defaultValue("true")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("test-while-idle").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("time-between-eviction-runs-millis")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("num-tests-per-eviction-run")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("idle-timeout").defaultValue("300")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("max-evictable-idle-timeout").defaultValue("-1")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("pool-prepared-statements").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("statement-cache-size").defaultValue("10")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("statement-timeout-in-seconds").defaultValue("-1")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("fetch-size").defaultValue("0")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("fail-all-connection").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("max-connection-age").defaultValue("0")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("isolation-level")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("access-to-underlying-connection-allowed").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("connection-leak-timeout-in-seconds").defaultValue("0")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("validate-atmost-once-period-in-seconds").defaultValue("120")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("enable-leakage-recovery").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("log-abandoned").defaultValue("true")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("rollback-on-return").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("enable-auto-commit-on-return").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("pool-statements").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("default-catalog")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("sql-trace").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("max-queries").defaultValue("1000")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("log-slow").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("log-failed").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("using-trace").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("connection-init-sqls")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("enable-sharing-resources").defaultValue("false")).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("fairness").defaultValue("false"));
        parserContext.addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("driver-class-name").required(true)).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("resource-type").required(true)).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("url").required(true)).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("username").required(true)).addAttributeConfig("server/resources/jdbc-resource", new DomParserContext.AttributeConfig().name("password").required(true));
        parserContext.addAttributeConfig("server/web-container", new DomParserContext.AttributeConfig().name("default-virtual-server").defaultValue("server"));
        parserContext.addAttributeConfig("server/web-container/http-service", new DomParserContext.AttributeConfig().name("global-access-log-enabled").defaultValue("false"));
        parserContext.addAttributeConfig("server/web-container/http-service/access-log", new DomParserContext.AttributeConfig().name("format").defaultValue("%h %l %u %t \"%r\" %s %b %D")).addAttributeConfig("server/web-container/http-service/access-log", new DomParserContext.AttributeConfig().name("rotation-enabled").defaultValue("true"));
        parserContext.addAttributeConfig("server/web-container/http-service/http-file", new DomParserContext.AttributeConfig().name("allow-linking").defaultValue("false")).addAttributeConfig("server/web-container/http-service/http-file", new DomParserContext.AttributeConfig().name("cache-max-size").defaultValue("262144")).addAttributeConfig("server/web-container/http-service/http-file", new DomParserContext.AttributeConfig().name("caching-allowed").defaultValue("true")).addAttributeConfig("server/web-container/http-service/http-file", new DomParserContext.AttributeConfig().name("cache-ttl").defaultValue("5000"));
        parserContext.addAttributeConfig("server/thread-pools/thread-pool", new DomParserContext.AttributeConfig().name("class-name").defaultValue("com.bes.enterprise.webtier.core.WorkThreadExecutor"));
        parserContext.addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("enabled").defaultValue("true")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("security-enabled").defaultValue("false")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("io-mode").defaultValue("NIO")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("gmssl-enabled").defaultValue("false")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("http2-enabled").defaultValue("false")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("address").defaultValue("0.0.0.0")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("use-ip-vhosts").defaultValue("false")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("accept-count").defaultValue("100")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("acceptor-thread").defaultValue("1")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("acceptor-thread-priority").defaultValue("5")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("bind-on-init").defaultValue("false")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("connection-linger").defaultValue("-1")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("connection-timeout").defaultValue("60000")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("max-connections").defaultValue("10000")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("processor-cache").defaultValue("200")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("socket-buffer").defaultValue("9000")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("tcp-no-delay").defaultValue("true")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("thread-priority").defaultValue("5")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("upgrade-async-write-buffer-size").defaultValue("8192")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("app-read-buf-size").defaultValue("8192")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("app-write-buf-size").defaultValue("8192")).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("default-virtual-server").defaultValue("server"));
        parserContext.addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("thread-pool").required(true)).addAttributeConfig("server/web-container/http-listener", new DomParserContext.AttributeConfig().name("port").required(true));
        parserContext.addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("allow-trace").defaultValue("false")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("async-timeout").defaultValue("30000")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("dns-lookup-enabled").defaultValue("false")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("max-parameter-count").defaultValue("10000")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("max-post-size").defaultValue("2097152")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("xpowered-by").defaultValue("false")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("uri-encoding").defaultValue("UTF-8")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("compressible-mime-type").defaultValue("text/html,text/xml,text/plain,text/css,text/javascript,application/javascript")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("compression").defaultValue("off")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("compression-min-size").defaultValue("2048")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("no-compression-user-agents").defaultValue("")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("connection-upload-timeout").defaultValue("300000")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("disable-upload-timeout").defaultValue("true")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("restricted-user-agents").defaultValue("")).addAttributeConfig("server/web-container/http-listener/http-protocol", new DomParserContext.AttributeConfig().name("use-keep-alive-response-header").defaultValue("false"));
        parserContext.addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("enabled").defaultValue("false")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("class-name").defaultValue("com.bes.enterprise.web.crane.http2.Http2Protocol")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("compressible-mime-type").defaultValue("text/html,text/xml,text/plain,text/css,text/javascript,application/javascript")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("compression").defaultValue("off")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("compression-min-size").defaultValue("2048")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("initial-window-size").defaultValue("65535")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("max-concurrent-stream-execution").defaultValue("200")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("max-concurrent-stream").defaultValue("200")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("max-header-count").defaultValue("100")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("max-header-size").defaultValue("8192")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("max-trailer-count").defaultValue("100")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("max-trailer-size").defaultValue("8192")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("no-compression-user-agents").defaultValue("")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("read-timeout").defaultValue("10000")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("write-timeout").defaultValue("10000")).addAttributeConfig("server/web-container/http-listener/http2-protocol", new DomParserContext.AttributeConfig().name("keep-alive-timeout").defaultValue("-1"));
        parserContext.addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("keystore-file").defaultValue("${com.bes.instanceRoot}/conf/security/keystore.jks")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("truststore-file").defaultValue("${com.bes.instanceRoot}/conf/security/cacerts.jks")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("keystore-type").defaultValue("JKS")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("keystore-pass").defaultValue("changeit")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("truststore-type").defaultValue("JKS")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("cert-type").defaultValue("CER")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("truststore-pass").defaultValue("changeit")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("key-alias").defaultValue("bes")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("key-pass").defaultValue("changeit")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("client-auth").defaultValue("false")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("ssl-protocol").defaultValue("TLS")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("ssl3-enabled").defaultValue("false")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("tls-enabled").defaultValue("true")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("tls11-enabled").defaultValue("true")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("tls12-enabled").defaultValue("true")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("tls13-enabled").defaultValue("false")).addAttributeConfig("server/web-container/http-listener/ssl", new DomParserContext.AttributeConfig().name("ciphers").defaultValue("HIGH:!aNULL:!eNULL:!EXPORT:!DES:!RC4:!MD5:!DHE:!kRSA"));
        parserContext.addAttributeConfig("server/web-container/http-listener/keep-alive", new DomParserContext.AttributeConfig().name("keep-alive-timeout").defaultValue("60")).addAttributeConfig("server/web-container/http-listener/keep-alive", new DomParserContext.AttributeConfig().name("max-keep-alive-requests").defaultValue("1024"));
        parserContext.addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("app-base").defaultValue("hotdeploy")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("error-report-valve-class").defaultValue("com.bes.enterprise.webtier.valves.ErrorReportValve")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("state").defaultValue("on")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("state").defaultValue("on")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("create-dirs").defaultValue("true")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("auto-deploy").defaultValue("true")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("background-processor-delay").defaultValue("-1")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("deploy-on-startup").defaultValue("true")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("fail-ctx-if-servlet-start-fails").defaultValue("false")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("start-stop-threads").defaultValue("1")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("undeploy-old-versions").defaultValue("false")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("copy-xml").defaultValue("false")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("unpack-wars").defaultValue("true")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("stuck-thread-max-time").defaultValue("0")).addAttributeConfig("server/web-container/virtual-server", new DomParserContext.AttributeConfig().name("stuck-thread-timer-interval").defaultValue("10"));
        parserContext.addAttributeConfig("server/jmx-connector", new DomParserContext.AttributeConfig().name("enabled").defaultValue("true")).addAttributeConfig("server/jmx-connector", new DomParserContext.AttributeConfig().name("address").defaultValue("0.0.0.0")).addAttributeConfig("server/jmx-connector", new DomParserContext.AttributeConfig().name("security-enabled").defaultValue("false"));
        parserContext.addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("keystore-file").defaultValue("${com.bes.instanceRoot}/conf/security/keystore.jks")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("truststore-file").defaultValue("${com.bes.instanceRoot}/conf/security/cacerts.jks")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("keystore-type").defaultValue("JKS")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("keystore-pass").defaultValue("changeit")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("truststore-type").defaultValue("JKS")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("truststore-pass").defaultValue("changeit")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("key-alias").defaultValue("bes")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("key-pass").defaultValue("changeit")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("client-auth").defaultValue("false")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("ssl-protocol").defaultValue("TLS")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("ssl3-enabled").defaultValue("false")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("tls-enabled").defaultValue("true")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("tls11-enabled").defaultValue("true")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("tls12-enabled").defaultValue("true")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("tls13-enabled").defaultValue("false")).addAttributeConfig("server/jmx-connector/ssl", new DomParserContext.AttributeConfig().name("ciphers").defaultValue("HIGH:!aNULL:!eNULL:!EXPORT:!DES:!RC4:!MD5:!DHE:!kRSA"));
        return parserContext;
    }
}

