/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.springboot.autoconfigure;

import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.boot.origin.OriginTrackedValue;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class BESEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final String BES_SYSTEM_PROPERTY_KEY = "server.bes.system.properties";

    public void postProcessEnvironment(ConfigurableEnvironment env, SpringApplication application) {
        String[] activeProfiles = env.getActiveProfiles();
        if (activeProfiles.length == 0) {
            activeProfiles = env.getDefaultProfiles();
        }
        MutablePropertySources propertySources = env.getPropertySources();
        for (PropertySource propertySource : propertySources) {
            if (propertySource.getSource() instanceof Map && ((Map)propertySource.getSource()).get(BES_SYSTEM_PROPERTY_KEY) != null && !(propertySource instanceof OriginTrackedMapPropertySource)) {
                Map source = (Map)propertySource.getSource();
                this.processSystemProperties((String)source.get(BES_SYSTEM_PROPERTY_KEY));
                continue;
            }
            if (!(propertySource.getSource() instanceof Map) || ((Map)propertySource.getSource()).get(BES_SYSTEM_PROPERTY_KEY) == null || !(propertySource instanceof OriginTrackedMapPropertySource)) continue;
            Object value = ((Map)propertySource.getSource()).get(BES_SYSTEM_PROPERTY_KEY);
            String defaultPropName = "applicationConfig: [classpath:/application.properties]";
            String defaultYamlName = "applicationConfig: [classpath:/application.yaml]";
            for (String profile : activeProfiles) {
                String propName = "applicationConfig: [classpath:/application-" + profile + ".properties]";
                String yamlName = "applicationConfig: [classpath:/application-" + profile + ".yaml]";
                if ("default".equals(profile) && (defaultPropName.equals(propertySource.getName()) || defaultYamlName.equals(propertySource.getName())) && value != null) {
                    this.processSystemProperties((String)((OriginTrackedValue)value).getValue());
                    continue;
                }
                if (!propName.equals(propertySource.getName()) && !yamlName.equals(propertySource.getName()) || value == null) continue;
                this.processSystemProperties((String)((OriginTrackedValue)value).getValue());
            }
        }
    }

    private void processSystemProperties(String value) {
        String[] values;
        for (String val : values = value.split("\\s*[|,]\\s*")) {
            String[] kv = val.split("=");
            if (kv.length < 2 || System.getProperty(kv[0]) != null) continue;
            System.setProperty(kv[0], kv[1]);
        }
    }
}

