/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.springboot.autoconfigure;

import com.bes.enterprise.appserver.common.util.StringUtils;
import com.bes.enterprise.springboot.autoconfigure.BesCompression;
import com.bes.enterprise.springboot.autoconfigure.BesProperties;
import com.bes.enterprise.springboot.embedded.BesServletWebServerFactory;
import com.bes.enterprise.web.crane.ProtocolHandler;
import com.bes.enterprise.web.crane.http11.AbstractHttp11JsseProtocol;
import com.bes.enterprise.web.crane.http11.AbstractHttp11Protocol;
import com.bes.enterprise.web.util.net.SSLHostConfig;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.core.Ordered;

public class BESServletWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableServletWebServerFactory>,
Ordered {
    private final BesProperties besProperties;

    public BESServletWebServerFactoryCustomizer(BesProperties besProperties) {
        this.besProperties = besProperties;
    }

    public int getOrder() {
        return 0;
    }

    public void customize(ConfigurableServletWebServerFactory factory) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(this.besProperties::getPort).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setPort(arg_0));
        map.from(this.besProperties::getAddress).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setAddress(arg_0));
        map.from(this.besProperties::getIoMode).whenNonNull().to(ioModel -> this.customizeProtocol(factory, (String)ioModel));
        map.from(this.besProperties::getAppReadBufSize).when(value -> value > 0).to(value -> this.customizeConnectorProperty(factory, "socket.appReadBufSize", String.valueOf(value)));
        map.from(this.besProperties::getAppWriteBufSize).when(value -> value > 0).to(value -> this.customizeConnectorProperty(factory, "socket.appWriteBufSize", String.valueOf(value)));
        map.from(this.besProperties::getTcpNoDelay).whenNonNull().to(value -> this.customizeConnectorProperty(factory, "tcpNoDelay", String.valueOf(value)));
        map.from(this.besProperties.getServlet()::getContextPath).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setContextPath(arg_0));
        map.from(this.besProperties.getServlet()::getApplicationDisplayName).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setDisplayName(arg_0));
        map.from(this.besProperties.getServlet()::getSession).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setSession(arg_0));
        map.from(this.besProperties::getSsl).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setSsl(arg_0));
        map.from(this.besProperties.getServlet()::getJsp).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setJsp(arg_0));
        map.from(this.besProperties::getCompression).to(value -> this.customizeBesCompression(factory, this.besProperties.getCompression()));
        map.from(this.besProperties::getHttp2).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setHttp2(arg_0));
        map.from(this.besProperties::getServerHeader).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setServerHeader(arg_0));
        map.from(this.besProperties.getServlet()::getContextParameters).to(arg_0 -> ((ConfigurableServletWebServerFactory)factory).setInitParameters(arg_0));
        map.from(this.besProperties::getGmsslEnabled).whenTrue().to(enabled -> this.customizeGmSSL(factory, this.besProperties.getBes().getGmssl()));
    }

    private void customizeProtocol(ConfigurableServletWebServerFactory factory, String protocol) {
        switch (protocol) {
            case "AIO": {
                protocol = "com.bes.enterprise.web.crane.http11.Http11Nio2Protocol";
                break;
            }
            default: {
                protocol = "com.bes.enterprise.web.crane.http11.Http11NioProtocol";
            }
        }
        ((BesServletWebServerFactory)factory).setProtocol(protocol);
    }

    private void customizeConnectorProperty(ConfigurableServletWebServerFactory factory, String name, String value) {
        ((BesServletWebServerFactory)factory).addConnectorCustomizers(connector -> connector.setProperty(name, value));
    }

    private void customizeGmSSL(ConfigurableServletWebServerFactory factory, BesProperties.Bes.Gmssl gmSSL) {
        ((BesServletWebServerFactory)factory).addConnectorCustomizers(connector -> {
            String keyPass;
            String keyAlias;
            SSLHostConfig defaultSSLHostConfig = new SSLHostConfig();
            connector.setScheme("https");
            connector.setSecure(true);
            String keystoreFile = gmSSL.getKeyStoreFile();
            if (!StringUtils.isBlank(keystoreFile)) {
                defaultSSLHostConfig.setCertificateKeystoreFile(keystoreFile);
            } else {
                String prop = System.getProperty("javax.net.ssl.keyStoreFile");
                if (prop != null) {
                    defaultSSLHostConfig.setCertificateKeystoreFile(prop);
                }
            }
            defaultSSLHostConfig.setCertificateKeystoreType("BKS");
            String keystorePass = gmSSL.getKeyStorePassword();
            if (keystorePass == null) {
                keystorePass = System.getProperty("javax.net.ssl.keyStorePassword");
            }
            if (keystorePass != null) {
                defaultSSLHostConfig.setCertificateKeystorePassword(keystorePass);
            }
            if ((keyAlias = gmSSL.getKeyAlias()) != null) {
                defaultSSLHostConfig.setCertificateKeyAlias(keyAlias);
            }
            if ((keyPass = gmSSL.getKeyPassword()) != null) {
                defaultSSLHostConfig.setCertificateKeyPassword(keyPass);
            }
            connector.addSslHostConfig(defaultSSLHostConfig);
            if (connector.getProtocolHandler() instanceof AbstractHttp11JsseProtocol) {
                AbstractHttp11JsseProtocol protocolHandler = (AbstractHttp11JsseProtocol)connector.getProtocolHandler();
                protocolHandler.setDefaultSSLHostConfigName(defaultSSLHostConfig.getHostName());
                protocolHandler.setSSLEnabled(true);
            }
            connector.setProperty("sslImplementationName", "com.bes.enterprise.gmssl.adapter.GMSSLImplementation");
        });
    }

    private void customizeBesCompression(ConfigurableServletWebServerFactory factory, BesCompression besCompression) {
        ((BesServletWebServerFactory)factory).addConnectorCustomizers(connector -> {
            ProtocolHandler protocolHandler;
            if (besCompression != null && besCompression.getEnabled() && (protocolHandler = connector.getProtocolHandler()) instanceof AbstractHttp11Protocol) {
                this.customize((AbstractHttp11Protocol)protocolHandler, besCompression);
            }
        });
    }

    private void customize(AbstractHttp11Protocol<?> protocol, BesCompression besCompression) {
        protocol.setCompression("on");
        protocol.setCompressionMinSize(besCompression.getMinResponseSize());
        protocol.setCompressibleMimeType(org.springframework.util.StringUtils.arrayToCommaDelimitedString((Object[])besCompression.getMimeTypes()));
        if (besCompression.getExcludedUserAgents() != null) {
            protocol.setNoCompressionUserAgents(org.springframework.util.StringUtils.arrayToCommaDelimitedString((Object[])besCompression.getExcludedUserAgents()));
        }
    }
}

