/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.springboot.autoconfigure;

import com.bes.enterprise.config.provider.CipherAlgorithmProviderFactory;
import com.bes.enterprise.springboot.autoconfigure.BesHttpsProperties;
import com.bes.enterprise.springboot.embedded.BesServletWebServerFactory;
import com.bes.enterprise.web.crane.http11.AbstractHttp11JsseProtocol;
import com.bes.enterprise.web.util.descriptor.web.SecurityCollection;
import com.bes.enterprise.web.util.descriptor.web.SecurityConstraint;
import com.bes.enterprise.web.util.net.SSLHostConfig;
import com.bes.enterprise.webtier.Realm;
import com.bes.enterprise.webtier.connector.Connector;
import com.bes.enterprise.webtier.core.WorkThreadExecutor;
import com.bes.enterprise.webtier.realm.RealmBase;
import java.io.FileNotFoundException;
import java.util.concurrent.Executor;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.http.HttpStatus;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class BesHttpsWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<BesServletWebServerFactory> {
    private final BesHttpsProperties besHttpsProperties;
    private final CipherAlgorithmProviderFactory algorithmProviderFactory = CipherAlgorithmProviderFactory.getInstance();

    public BesHttpsWebServerFactoryCustomizer(BesHttpsProperties besHttpsProperties) {
        this.besHttpsProperties = besHttpsProperties;
    }

    public void customize(BesServletWebServerFactory besFactory) {
        besFactory.addAdditionalBesConnectors(this.initHttpsConnector());
        if (!this.besHttpsProperties.getRedirectEnabled().booleanValue()) {
            return;
        }
        besFactory.addContextCustomizers(context -> {
            SecurityConstraint securityConstraint = new SecurityConstraint();
            securityConstraint.setUserConstraint("CONFIDENTIAL");
            SecurityCollection collection = new SecurityCollection();
            collection.addPattern("/*");
            securityConstraint.addCollection(collection);
            context.addConstraint(securityConstraint);
            Realm realm = context.getRealm();
            if (realm instanceof RealmBase) {
                RealmBase realmBase = (RealmBase)realm;
                realmBase.setTransportGuaranteeRedirectStatus(HttpStatus.TEMPORARY_REDIRECT.value());
            }
        });
        besFactory.addConnectorCustomizers(connector -> connector.setRedirectPort(this.besHttpsProperties.getPort()));
    }

    private Connector initHttpsConnector() {
        Connector connector = new Connector("com.bes.enterprise.web.crane.http11.Http11NioProtocol");
        connector.setScheme("https");
        connector.setSecure(true);
        connector.setPort(this.besHttpsProperties.getPort());
        this.customizeSsl(connector);
        this.rebuildThreadNamePrefix(connector);
        return connector;
    }

    private void customizeSsl(Connector connector) {
        AbstractHttp11JsseProtocol protocol = (AbstractHttp11JsseProtocol)connector.getProtocolHandler();
        protocol.setSSLEnabled(true);
        BesHttpsProperties.Ssl ssl = this.besHttpsProperties.getSsl();
        protocol.setSslProtocol(ssl.getProtocol());
        this.configureSslClientAuth(protocol, ssl);
        protocol.setKeystorePass(this.decryptPass(ssl.getKeyStorePassword()));
        protocol.setKeyPass(this.decryptPass(ssl.getKeyPassword()));
        protocol.setKeyAlias(ssl.getKeyAlias());
        Object[] cipherArray = ssl.getCiphers();
        String ciphers = StringUtils.arrayToCommaDelimitedString((Object[])cipherArray);
        if (StringUtils.hasText((String)ciphers)) {
            protocol.setCiphers(ciphers);
        }
        if (ssl.getEnabledProtocols() != null) {
            for (SSLHostConfig sslHostConfig : protocol.findSslHostConfigs()) {
                sslHostConfig.setProtocols(StringUtils.arrayToCommaDelimitedString((Object[])ssl.getEnabledProtocols()));
            }
        }
        this.configureSslKeyStore(protocol, ssl);
        this.configureSslTrustStore(protocol, ssl);
    }

    private void configureSslClientAuth(AbstractHttp11JsseProtocol<?> protocol, BesHttpsProperties.Ssl ssl) {
        if (ssl.getClientAuth() == Ssl.ClientAuth.NEED) {
            protocol.setClientAuth(Boolean.TRUE.toString());
        } else if (ssl.getClientAuth() == Ssl.ClientAuth.WANT) {
            protocol.setClientAuth("want");
        }
    }

    private void configureSslKeyStore(AbstractHttp11JsseProtocol<?> protocol, BesHttpsProperties.Ssl ssl) {
        try {
            protocol.setKeystoreFile(ResourceUtils.getURL((String)ssl.getKeyStore()).toString());
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("Could not load key store: " + ex.getMessage(), ex);
        }
        if (ssl.getKeyStoreType() != null) {
            protocol.setKeystoreType(ssl.getKeyStoreType());
        }
        if (ssl.getKeyStoreProvider() != null) {
            protocol.setKeystoreProvider(ssl.getKeyStoreProvider());
        }
    }

    private void configureSslTrustStore(AbstractHttp11JsseProtocol<?> protocol, BesHttpsProperties.Ssl ssl) {
        if (ssl.getTrustStore() != null) {
            try {
                protocol.setTruststoreFile(ResourceUtils.getURL((String)ssl.getTrustStore()).toString());
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException("Could not load trust store: " + ex.getMessage(), ex);
            }
        }
        protocol.setTruststorePass(this.decryptPass(ssl.getTrustStorePassword()));
        if (ssl.getTrustStoreType() != null) {
            protocol.setTruststoreType(ssl.getTrustStoreType());
        }
        if (ssl.getTrustStoreProvider() != null) {
            protocol.setTruststoreProvider(ssl.getTrustStoreProvider());
        }
    }

    private String decryptPass(String password) {
        try {
            if (this.algorithmProviderFactory.isCipherText(password)) {
                password = this.algorithmProviderFactory.decrypt(password);
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return password;
    }

    private void rebuildThreadNamePrefix(Connector connector) {
        Executor executor = connector.getProtocolHandler().getExecutor();
        if (executor instanceof WorkThreadExecutor) {
            WorkThreadExecutor workThreadExecutor = (WorkThreadExecutor)executor;
            String prefix = connector.getSecure() ? "httpSSLWorkerThread-" : "httpWorkerThread-";
            String name = prefix + connector.getPort();
            prefix = name + "-";
            workThreadExecutor.setName(name);
            workThreadExecutor.setNamePrefix(prefix);
        }
    }
}

