/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.springboot.autoconfigure;

import com.bes.enterprise.naming.ContextBindings;
import com.bes.enterprise.springboot.autoconfigure.BesApplication;
import com.bes.enterprise.springboot.autoconfigure.BesCompression;
import com.bes.enterprise.springboot.autoconfigure.BesJdbcResource;
import java.io.File;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.boot.web.server.Http2;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.servlet.server.Jsp;
import org.springframework.boot.web.servlet.server.Session;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="server", ignoreUnknownFields=true)
public class BesProperties {
    private Integer port;
    private InetAddress address;
    private String ioMode;
    private Integer storeLicInterval;
    private Integer appReadBufSize = 8192;
    private Integer appWriteBufSize = 8192;
    private Boolean tcpNoDelay;
    private Boolean gmsslEnabled;
    @NestedConfigurationProperty
    private final ErrorProperties error = new ErrorProperties();
    private Boolean useForwardHeaders;
    private String serverHeader;
    private int maxHttpHeaderSize = 0;
    private Duration connectionTimeout;
    @NestedConfigurationProperty
    private Ssl ssl;
    @NestedConfigurationProperty
    private final BesCompression compression = new BesCompression();
    @NestedConfigurationProperty
    private final Http2 http2 = new Http2();
    private final Servlet servlet = new Servlet();
    private final Bes besServer = new Bes();

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public Boolean isUseForwardHeaders() {
        return this.useForwardHeaders;
    }

    public void setUseForwardHeaders(Boolean useForwardHeaders) {
        this.useForwardHeaders = useForwardHeaders;
    }

    public String getServerHeader() {
        return this.serverHeader;
    }

    public void setServerHeader(String serverHeader) {
        this.serverHeader = serverHeader;
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
        this.maxHttpHeaderSize = maxHttpHeaderSize;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public ErrorProperties getError() {
        return this.error;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public BesCompression getCompression() {
        return this.compression;
    }

    public Http2 getHttp2() {
        return this.http2;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public Bes getBes() {
        return this.besServer;
    }

    public String getIoMode() {
        return this.ioMode;
    }

    public void setIoMode(String ioMode) {
        this.ioMode = ioMode;
    }

    public int getAppReadBufSize() {
        return this.appReadBufSize;
    }

    public void setAppReadBufSize(Integer appReadBufSize) {
        this.appReadBufSize = appReadBufSize;
    }

    public int getAppWriteBufSize() {
        return this.appWriteBufSize;
    }

    public void setAppWriteBufSize(Integer appWriteBufSize) {
        this.appWriteBufSize = appWriteBufSize;
    }

    public Boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(Boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public Boolean getGmsslEnabled() {
        return this.gmsslEnabled;
    }

    public void setGmsslEnabled(Boolean gmsslEnabled) {
        this.gmsslEnabled = gmsslEnabled;
    }

    public Integer getStoreLicInterval() {
        return this.storeLicInterval;
    }

    public void setStoreLicInterval(Integer storeLicInterval) {
        this.storeLicInterval = storeLicInterval;
    }

    public static class Bes {
        @NestedConfigurationProperty
        List<BesApplication> apps = new ArrayList<BesApplication>();
        @NestedConfigurationProperty
        private final BesJdbcResource jdbc = new BesJdbcResource();
        private final Accesslog accesslog = new Accesslog();
        private final Gmssl gmssl = new Gmssl();
        private final Resource resource = new Resource();
        private String internalProxies = "10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|192\\.168\\.\\d{1,3}\\.\\d{1,3}|169\\.254\\.\\d{1,3}\\.\\d{1,3}|127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|172\\.1[6-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.2[0-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.3[0-1]{1}\\.\\d{1,3}\\.\\d{1,3}";
        private String protocolHeader;
        private String protocolHeaderHttpsValue = "https";
        private String portHeader = "X-Forwarded-Port";
        private String remoteIpHeader;
        private File basedir;
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration backgroundProcessorDelay = Duration.ofSeconds(30L);
        private int maxThreads = 200;
        private int minSpareThreads = 8;
        private int maxQueueSize = 4096;
        private int maxIdleTime = 60000;
        private int maxHttpPostSize = 0;
        private int maxHttpHeaderSize = 0;
        private int maxPartCount = Integer.MAX_VALUE;
        private int maxPartHeaderSize = Integer.MAX_VALUE;
        private Boolean redirectContextRoot;
        private Boolean useRelativeRedirects;
        private Boolean jspPreCompile;
        private Charset uriEncoding;
        private int maxConnections = 0;
        private int acceptCount = 0;
        private int stuckThreadMaxTime = 0;
        private String requestCharacterEncoding = "ISO-8859-1";
        private String responseCharacterEncoding = "ISO-8859-1";
        private boolean useBodyEncodingForUri = false;
        private Integer maxKeepAliveRequests;
        private Integer keepAliveTimeout;
        private Integer maxHeaderCount = 100;
        private int stuckThreadTimerInterval = 10;
        private Boolean xpoweredBy;
        private long asyncTimeout = 3000L;
        private int maxParameterCount = 10000;
        private Integer connectionUploadTimeout;
        private Boolean disableUploadTimeout;
        private Boolean dnsLookupEnabled;
        private List<String> additionalTldSkipPatterns = new ArrayList<String>();
        private Boolean overrideSystemRootContextEnabled;
        private Boolean useNaming = false;
        private Boolean ignoreAnnotations = false;
        private Boolean scanClassPath = true;
        private Boolean scanManifest = false;
        private Boolean scanAllFiles = false;
        private Boolean scanAllDirectories = true;
        private Boolean scanBootstrapClassPath = false;
        private Boolean sharedContainer;
        private Boolean loadLocally = true;
        private Boolean registerDefaultServlet;

        public Boolean isRegisterDefaultServlet() {
            return this.registerDefaultServlet;
        }

        public void setRegisterDefaultServlet(Boolean registerDefaultServlet) {
            this.registerDefaultServlet = registerDefaultServlet;
        }

        public Boolean getSharedContainer() {
            return this.sharedContainer;
        }

        public void setSharedContainer(Boolean sharedContainer) {
            this.sharedContainer = sharedContainer;
        }

        public Boolean getScanClassPath() {
            return this.scanClassPath;
        }

        public void setScanClassPath(Boolean scanClassPath) {
            this.scanClassPath = scanClassPath;
        }

        public Boolean getScanManifest() {
            return this.scanManifest;
        }

        public void setScanManifest(Boolean scanManifest) {
            this.scanManifest = scanManifest;
        }

        public Boolean getScanAllFiles() {
            return this.scanAllFiles;
        }

        public void setScanAllFiles(Boolean scanAllFiles) {
            this.scanAllFiles = scanAllFiles;
        }

        public Boolean getScanAllDirectories() {
            return this.scanAllDirectories;
        }

        public void setScanAllDirectories(Boolean scanAllDirectories) {
            this.scanAllDirectories = scanAllDirectories;
        }

        public Boolean getScanBootstrapClassPath() {
            return this.scanBootstrapClassPath;
        }

        public void setScanBootstrapClassPath(Boolean scanBootstrapClassPath) {
            this.scanBootstrapClassPath = scanBootstrapClassPath;
        }

        public Boolean getUseNaming() {
            return this.useNaming;
        }

        public void setUseNaming(Boolean useNaming) {
            this.useNaming = useNaming;
        }

        public Boolean getIgnoreAnnotations() {
            return this.ignoreAnnotations;
        }

        public void setIgnoreAnnotations(Boolean ignoreAnnotations) {
            this.ignoreAnnotations = ignoreAnnotations;
        }

        public Boolean getXpoweredBy() {
            return this.xpoweredBy;
        }

        public void setXpoweredBy(Boolean xpoweredBy) {
            this.xpoweredBy = xpoweredBy;
        }

        public long getAsyncTimeout() {
            return this.asyncTimeout;
        }

        public void setAsyncTimeout(long asyncTimeout) {
            this.asyncTimeout = asyncTimeout;
        }

        public int getMaxParameterCount() {
            return this.maxParameterCount;
        }

        public void setMaxParameterCount(int maxParameterCount) {
            this.maxParameterCount = maxParameterCount;
        }

        public Integer getConnectionUploadTimeout() {
            return this.connectionUploadTimeout;
        }

        public void setConnectionUploadTimeout(Integer connectionUploadTimeout) {
            this.connectionUploadTimeout = connectionUploadTimeout;
        }

        public Boolean getDisableUploadTimeout() {
            return this.disableUploadTimeout;
        }

        public void setDisableUploadTimeout(Boolean disableUploadTimeout) {
            this.disableUploadTimeout = disableUploadTimeout;
        }

        public Boolean getDnsLookupEnabled() {
            return this.dnsLookupEnabled;
        }

        public void setDnsLookupEnabled(Boolean dnsLookupEnabled) {
            this.dnsLookupEnabled = dnsLookupEnabled;
        }

        public int getMaxThreads() {
            return this.maxThreads;
        }

        public void setMaxThreads(int maxThreads) {
            this.maxThreads = maxThreads;
        }

        public int getMinSpareThreads() {
            return this.minSpareThreads;
        }

        public void setMinSpareThreads(int minSpareThreads) {
            this.minSpareThreads = minSpareThreads;
        }

        public int getMaxHttpPostSize() {
            return this.maxHttpPostSize;
        }

        public void setMaxHttpPostSize(int maxHttpPostSize) {
            this.maxHttpPostSize = maxHttpPostSize;
        }

        public int getMaxPartCount() {
            return this.maxPartCount;
        }

        public void setMaxPartCount(int maxPartCount) {
            this.maxPartCount = maxPartCount;
        }

        public int getMaxPartHeaderSize() {
            return this.maxPartHeaderSize;
        }

        public void setMaxPartHeaderSize(int maxPartHeaderSize) {
            this.maxPartHeaderSize = maxPartHeaderSize;
        }

        public Accesslog getAccesslog() {
            return this.accesslog;
        }

        public Gmssl getGmssl() {
            return this.gmssl;
        }

        public Duration getBackgroundProcessorDelay() {
            return this.backgroundProcessorDelay;
        }

        public void setBackgroundProcessorDelay(Duration backgroundProcessorDelay) {
            this.backgroundProcessorDelay = backgroundProcessorDelay;
        }

        public File getBasedir() {
            return this.basedir;
        }

        public void setBasedir(File basedir) {
            this.basedir = basedir;
        }

        public String getInternalProxies() {
            return this.internalProxies;
        }

        public void setInternalProxies(String internalProxies) {
            this.internalProxies = internalProxies;
        }

        public String getProtocolHeader() {
            return this.protocolHeader;
        }

        public void setProtocolHeader(String protocolHeader) {
            this.protocolHeader = protocolHeader;
        }

        public String getProtocolHeaderHttpsValue() {
            return this.protocolHeaderHttpsValue;
        }

        public void setProtocolHeaderHttpsValue(String protocolHeaderHttpsValue) {
            this.protocolHeaderHttpsValue = protocolHeaderHttpsValue;
        }

        public String getPortHeader() {
            return this.portHeader;
        }

        public void setPortHeader(String portHeader) {
            this.portHeader = portHeader;
        }

        public Boolean getRedirectContextRoot() {
            return this.redirectContextRoot;
        }

        public void setRedirectContextRoot(Boolean redirectContextRoot) {
            this.redirectContextRoot = redirectContextRoot;
        }

        public Boolean getUseRelativeRedirects() {
            return this.useRelativeRedirects;
        }

        public void setUseRelativeRedirects(Boolean useRelativeRedirects) {
            this.useRelativeRedirects = useRelativeRedirects;
        }

        public Boolean getJspPreCompile() {
            return this.jspPreCompile;
        }

        public void setJspPreCompile(Boolean jspPreCompile) {
            this.jspPreCompile = jspPreCompile;
        }

        public String getRemoteIpHeader() {
            return this.remoteIpHeader;
        }

        public void setRemoteIpHeader(String remoteIpHeader) {
            this.remoteIpHeader = remoteIpHeader;
        }

        public Charset getUriEncoding() {
            return this.uriEncoding;
        }

        public void setUriEncoding(Charset uriEncoding) {
            this.uriEncoding = uriEncoding;
        }

        public int getMaxConnections() {
            return this.maxConnections;
        }

        public void setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
        }

        public int getMaxHttpHeaderSize() {
            return this.maxHttpHeaderSize;
        }

        public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
            this.maxHttpHeaderSize = maxHttpHeaderSize;
        }

        public int getAcceptCount() {
            return this.acceptCount;
        }

        public void setAcceptCount(int acceptCount) {
            this.acceptCount = acceptCount;
        }

        public List<String> getAdditionalTldSkipPatterns() {
            return this.additionalTldSkipPatterns;
        }

        public void setAdditionalTldSkipPatterns(List<String> additionalTldSkipPatterns) {
            this.additionalTldSkipPatterns = additionalTldSkipPatterns;
        }

        public Boolean getOverrideSystemRootContextEnabled() {
            return this.overrideSystemRootContextEnabled;
        }

        public void setOverrideSystemRootContextEnabled(Boolean overrideSystemRootContextEnabled) {
            this.overrideSystemRootContextEnabled = overrideSystemRootContextEnabled;
            ContextBindings.SYSTEM_ROOT_CONTEXT_OVERRIDE_ENABLED = overrideSystemRootContextEnabled;
        }

        public Resource getResource() {
            return this.resource;
        }

        public int getMaxQueueSize() {
            return this.maxQueueSize;
        }

        public void setMaxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
        }

        public int getMaxIdleTime() {
            return this.maxIdleTime;
        }

        public void setMaxIdleTime(int maxIdleTime) {
            this.maxIdleTime = maxIdleTime;
        }

        public int getStuckThreadMaxTime() {
            return this.stuckThreadMaxTime;
        }

        public void setStuckThreadMaxTime(int stuckThreadMaxTime) {
            this.stuckThreadMaxTime = stuckThreadMaxTime;
        }

        public int getStuckThreadTimerInterval() {
            return this.stuckThreadTimerInterval;
        }

        public void setStuckThreadTimerInterval(int stuckThreadTimerInterval) {
            this.stuckThreadTimerInterval = stuckThreadTimerInterval;
        }

        public List<BesApplication> getApps() {
            return this.apps;
        }

        public BesJdbcResource getJdbc() {
            return this.jdbc;
        }

        public Integer getMaxKeepAliveRequests() {
            return this.maxKeepAliveRequests;
        }

        public void setMaxKeepAliveRequests(Integer maxKeepAliveRequests) {
            this.maxKeepAliveRequests = maxKeepAliveRequests;
        }

        public Integer getKeepAliveTimeout() {
            return this.keepAliveTimeout;
        }

        public void setKeepAliveTimeout(Integer keepAliveTimeout) {
            this.keepAliveTimeout = keepAliveTimeout;
        }

        public Integer getMaxHeaderCount() {
            return this.maxHeaderCount;
        }

        public void setMaxHeaderCount(Integer maxHeaderCount) {
            this.maxHeaderCount = maxHeaderCount;
        }

        public String getRequestCharacterEncoding() {
            return this.requestCharacterEncoding;
        }

        public void setRequestCharacterEncoding(String requestCharacterEncoding) {
            this.requestCharacterEncoding = requestCharacterEncoding;
        }

        public String getResponseCharacterEncoding() {
            return this.responseCharacterEncoding;
        }

        public void setResponseCharacterEncoding(String responseCharacterEncoding) {
            this.responseCharacterEncoding = responseCharacterEncoding;
        }

        public boolean isUseBodyEncodingForUri() {
            return this.useBodyEncodingForUri;
        }

        public void setUseBodyEncodingForUri(boolean useBodyEncodingForUri) {
            this.useBodyEncodingForUri = useBodyEncodingForUri;
        }

        public Boolean getLoadLocally() {
            return this.loadLocally;
        }

        public void setLoadLocally(Boolean loadLocally) {
            this.loadLocally = loadLocally;
        }

        public static class Gmssl {
            private String keyAlias;
            private String keyPassword;
            private String keyStoreFile;
            private String keyStorePassword;

            public String getKeyAlias() {
                return this.keyAlias;
            }

            public void setKeyAlias(String keyAlias) {
                this.keyAlias = keyAlias;
            }

            public String getKeyPassword() {
                return this.keyPassword;
            }

            public void setKeyPassword(String keyPassword) {
                this.keyPassword = keyPassword;
            }

            public String getKeyStoreFile() {
                return this.keyStoreFile;
            }

            public void setKeyStoreFile(String keyStoreFile) {
                this.keyStoreFile = keyStoreFile;
            }

            public String getKeyStorePassword() {
                return this.keyStorePassword;
            }

            public void setKeyStorePassword(String keyStorePassword) {
                this.keyStorePassword = keyStorePassword;
            }
        }

        public static class Resource {
            private Boolean allowLinking = false;
            private String cacheObjectMaxSize;
            private Duration cacheTtl;
            private Boolean cachingAllowed = true;
            private Boolean trackLockedFiles = false;

            public Duration getCacheTtl() {
                return this.cacheTtl;
            }

            public void setCacheTtl(Duration cacheTtl) {
                this.cacheTtl = cacheTtl;
            }

            public Boolean getAllowLinking() {
                return this.allowLinking;
            }

            public void setAllowLinking(Boolean allowLinking) {
                this.allowLinking = allowLinking;
            }

            public String getCacheObjectMaxSize() {
                return this.cacheObjectMaxSize;
            }

            public void setCacheObjectMaxSize(String cacheObjectMaxSize) {
                this.cacheObjectMaxSize = cacheObjectMaxSize;
            }

            public Boolean getCachingAllowed() {
                return this.cachingAllowed;
            }

            public void setCachingAllowed(Boolean cachingAllowed) {
                this.cachingAllowed = cachingAllowed;
            }

            public Boolean getTrackLockedFiles() {
                return this.trackLockedFiles;
            }

            public void setTrackLockedFiles(Boolean trackLockedFiles) {
                this.trackLockedFiles = trackLockedFiles;
            }
        }

        public static class Accesslog {
            private boolean enabled = false;
            private boolean rotatableByTime = true;
            private boolean rotatableBySize = false;
            private String pattern = "common";
            private String directory = "logs";
            protected String prefix = "access_log";
            private String suffix = ".log";
            private boolean rotate = true;
            private boolean renameOnRotate = true;
            private String fileDateFormat = ".yyyy-MM-dd";
            private boolean requestAttributesEnabled;
            private boolean buffered = true;
            private int rotationSize = 10458760;
            private int maxHistoryFiles = 10;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public String getPattern() {
                return this.pattern;
            }

            public void setPattern(String pattern) {
                this.pattern = pattern;
            }

            public String getDirectory() {
                return this.directory;
            }

            public void setDirectory(String directory) {
                this.directory = directory;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public void setPrefix(String prefix) {
                this.prefix = prefix;
            }

            public String getSuffix() {
                return this.suffix;
            }

            public void setSuffix(String suffix) {
                this.suffix = suffix;
            }

            public boolean isRotate() {
                return this.rotate;
            }

            public void setRotate(boolean rotate) {
                this.rotate = rotate;
            }

            public boolean isRenameOnRotate() {
                return this.renameOnRotate;
            }

            public void setRenameOnRotate(boolean renameOnRotate) {
                this.renameOnRotate = renameOnRotate;
            }

            public String getFileDateFormat() {
                return this.fileDateFormat;
            }

            public void setFileDateFormat(String fileDateFormat) {
                this.fileDateFormat = fileDateFormat;
            }

            public boolean isRequestAttributesEnabled() {
                return this.requestAttributesEnabled;
            }

            public void setRequestAttributesEnabled(boolean requestAttributesEnabled) {
                this.requestAttributesEnabled = requestAttributesEnabled;
            }

            public boolean isBuffered() {
                return this.buffered;
            }

            public void setBuffered(boolean buffered) {
                this.buffered = buffered;
            }

            public int getRotationSize() {
                return this.rotationSize;
            }

            public void setRotationSize(int rotationSize) {
                this.rotationSize = rotationSize;
            }

            public boolean isRotatableByTime() {
                return this.rotatableByTime;
            }

            public void setRotatableByTime(boolean rotatableByTime) {
                this.rotatableByTime = rotatableByTime;
            }

            public boolean isRotatableBySize() {
                return this.rotatableBySize;
            }

            public void setRotatableBySize(boolean rotatableBySize) {
                this.rotatableBySize = rotatableBySize;
            }

            public int getMaxHistoryFiles() {
                return this.maxHistoryFiles;
            }

            public void setMaxHistoryFiles(int maxHistoryFiles) {
                this.maxHistoryFiles = maxHistoryFiles;
            }
        }
    }

    public static class BESJSP
    extends Jsp {
        public BESJSP() {
            this.setClassName("com.bes.enterprise.web.jasper.servlet.JspServlet");
        }
    }

    public static class Servlet {
        private final Map<String, String> contextParameters = new HashMap<String, String>();
        private String contextPath;
        private String applicationDisplayName = "application";
        private String path = "/";
        @NestedConfigurationProperty
        private final Jsp jsp = new BESJSP();
        @NestedConfigurationProperty
        private final Session session = new Session();

        public String getContextPath() {
            return this.contextPath;
        }

        public void setContextPath(String contextPath) {
            this.contextPath = this.cleanContextPath(contextPath);
        }

        private String cleanContextPath(String contextPath) {
            if (StringUtils.hasText((String)contextPath) && contextPath.endsWith("/")) {
                return contextPath.substring(0, contextPath.length() - 1);
            }
            return contextPath;
        }

        public String getApplicationDisplayName() {
            return this.applicationDisplayName;
        }

        public void setApplicationDisplayName(String displayName) {
            this.applicationDisplayName = displayName;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            Assert.notNull((Object)path, (String)"Path must not be null");
            this.path = path;
        }

        public Map<String, String> getContextParameters() {
            return this.contextParameters;
        }

        public Jsp getJsp() {
            return this.jsp;
        }

        public Session getSession() {
            return this.session;
        }

        public String getServletMapping() {
            if (this.path.equals("") || this.path.equals("/")) {
                return "/";
            }
            if (this.path.contains("*")) {
                return this.path;
            }
            if (this.path.endsWith("/")) {
                return this.path + "*";
            }
            return this.path + "/*";
        }

        public String getPath(String path) {
            String prefix = this.getServletPrefix();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            return prefix + path;
        }

        public String getServletPrefix() {
            String result = this.path;
            int index = result.indexOf(42);
            if (index != -1) {
                result = result.substring(0, index);
            }
            if (result.endsWith("/")) {
                result = result.substring(0, result.length() - 1);
            }
            return result;
        }

        public String[] getPathsArray(Collection<String> paths) {
            String[] result = new String[paths.size()];
            int i2 = 0;
            for (String path : paths) {
                result[i2++] = this.getPath(path);
            }
            return result;
        }

        public String[] getPathsArray(String[] paths) {
            String[] result = new String[paths.length];
            int i2 = 0;
            for (String path : paths) {
                result[i2++] = this.getPath(path);
            }
            return result;
        }
    }
}

