/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.springboot.autoconfigure;

import com.bes.enterprise.springboot.embedded.BesServletWebServerFactory;
import com.bes.enterprise.springboot.embedded.GracefulBesServletWebServerFactory;
import com.bes.enterprise.web.Embedded;
import com.bes.enterprise.web.crane.UpgradeProtocol;
import javax.servlet.Servlet;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryAutoConfiguration;
import org.springframework.boot.web.server.Shutdown;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={ServletWebServerFactoryAutoConfiguration.class})
public class BesServletWebServerFactoryConfiguration {

    @ConditionalOnClass(value={Servlet.class, Embedded.class, UpgradeProtocol.class, Shutdown.class})
    @ConditionalOnMissingBean(value={ServletWebServerFactory.class}, search=SearchStrategy.CURRENT)
    public static class GracefulEmbeddedBESContainer {
        @Bean
        public BesServletWebServerFactory besServletWebServerFactory() {
            return new GracefulBesServletWebServerFactory();
        }
    }

    @ConditionalOnClass(value={Servlet.class, Embedded.class, UpgradeProtocol.class})
    @ConditionalOnMissingBean(value={ServletWebServerFactory.class}, search=SearchStrategy.CURRENT)
    public static class EmbeddedBESContainer {
        @Bean
        public BesServletWebServerFactory besServletWebServerFactory() {
            return new BesServletWebServerFactory();
        }
    }
}

