/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.springboot.autoconfigure;

import com.bes.enterprise.config.provider.CipherAlgorithmProviderFactory;
import com.bes.enterprise.springboot.autoconfigure.BesJdbcResource;
import com.bes.enterprise.springboot.autoconfigure.BesProperties;
import com.bes.enterprise.springboot.embedded.BesServletWebServerFactory;
import com.bes.enterprise.springboot.embedded.ConfigurableBesWebServerFactory;
import com.bes.enterprise.web.JarScanner;
import com.bes.enterprise.web.crane.AbstractProtocol;
import com.bes.enterprise.web.crane.ProtocolHandler;
import com.bes.enterprise.web.crane.http11.AbstractHttp11Protocol;
import com.bes.enterprise.web.util.descriptor.besweb.Property;
import com.bes.enterprise.web.util.descriptor.web.ContextResource;
import com.bes.enterprise.web.util.scan.StandardJarScanFilter;
import com.bes.enterprise.web.util.scan.StandardJarScanner;
import com.bes.enterprise.webtier.Valve;
import com.bes.enterprise.webtier.valves.AccessLogValve;
import com.bes.enterprise.webtier.valves.ErrorReportValve;
import com.bes.enterprise.webtier.valves.RemoteIpValve;
import com.bes.enterprise.webtier.valves.StuckThreadDetectionValve;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BesWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableBesWebServerFactory>,
Ordered {
    private static final String timeBetweenEvictionRunsMillisUpper = System.getProperty("com.bes.enterprise.jdbc.timeBetweenEvictionRunsMillis.UpperLimit", "60000");
    public static final String INCLUDESTACKTRACE = "IncludeStacktrace";
    public static final String INCLUDEATTRIBUTE = "IncludeAttribute";
    private final Environment environment;
    private final BesProperties besProperties;

    public BesWebServerFactoryCustomizer(Environment environment, BesProperties besProperties) {
        this.environment = environment;
        this.besProperties = besProperties;
    }

    public int getOrder() {
        return 0;
    }

    public void customize(ConfigurableBesWebServerFactory factory) {
        BesProperties properties = this.besProperties;
        BesProperties.Bes besProperties = properties.getBes();
        PropertyMapper propertyMapper = PropertyMapper.get();
        propertyMapper.from(properties::getStoreLicInterval).whenNonNull().to(((BesServletWebServerFactory)factory)::setStoreLicInfoInterval);
        propertyMapper.from(besProperties::getLoadLocally).whenNonNull().to(((BesServletWebServerFactory)factory)::setLoadClassLocally);
        propertyMapper.from(besProperties::getBasedir).whenNonNull().to(factory::setBaseDirectory);
        propertyMapper.from(besProperties::getApps).whenNonNull().to(((BesServletWebServerFactory)factory)::setModules);
        propertyMapper.from(besProperties::getBackgroundProcessorDelay).whenNonNull().as(Duration::getSeconds).as(Long::intValue).to(factory::setBackgroundProcessorDelay);
        this.customizeRemoteIpValve(factory);
        propertyMapper.from(besProperties::getMaxThreads).when(this::isPositive).to(maxThreads -> this.customizeMaxThreads(factory, besProperties.getMaxThreads()));
        propertyMapper.from(besProperties::getMinSpareThreads).when(this::isPositive).to(minSpareThreads -> this.customizeMinThreads(factory, (int)minSpareThreads));
        propertyMapper.from(besProperties::getMaxQueueSize).when(this::isPositive).to(maxQueueSize -> this.customizeMaxQueueSize(factory, (int)maxQueueSize));
        propertyMapper.from(besProperties::getMaxIdleTime).when(this::isPositive).to(maxIdleTime -> this.customizeMaxIdleTime(factory, (int)maxIdleTime));
        propertyMapper.from(() -> this.determineMaxHttpHeaderSize()).when(this::isPositive).to(maxHttpHeaderSize -> this.customizeMaxHttpHeaderSize(factory, (int)maxHttpHeaderSize));
        propertyMapper.from(besProperties::getMaxHttpPostSize).when(maxHttpPostSize -> maxHttpPostSize != 0).to(maxHttpPostSize -> this.customizeMaxHttpPostSize(factory, (int)maxHttpPostSize));
        propertyMapper.from(besProperties::getAccesslog).when(BesProperties.Bes.Accesslog::isEnabled).to(enabled -> this.customizeAccessLog(factory));
        propertyMapper.from(besProperties::getUriEncoding).whenNonNull().to(factory::setUriEncoding);
        propertyMapper.from(properties::getConnectionTimeout).whenNonNull().to(connectionTimeout -> this.customizeConnectionTimeout(factory, (Duration)connectionTimeout));
        propertyMapper.from(besProperties::getMaxKeepAliveRequests).whenNonNull().to(maxKeepAliveRequest -> this.customizeMaxKeepaliveRequests(factory, (int)maxKeepAliveRequest));
        propertyMapper.from(besProperties::getKeepAliveTimeout).whenNonNull().to(keepAliveTimeout -> this.customizeKeepaliveTimeout(factory, (int)keepAliveTimeout));
        propertyMapper.from(besProperties::getMaxHeaderCount).whenNonNull().to(maxHeaderCount -> this.customizeMaxHeaderCount(factory, (int)maxHeaderCount));
        propertyMapper.from(besProperties::getRedirectContextRoot).whenNonNull().to(redirectContextRoot -> this.customizeRedirectContextRoot(factory, (boolean)redirectContextRoot));
        propertyMapper.from(besProperties::getMaxConnections).when(this::isPositive).to(maxConnections -> this.customizeMaxConnections(factory, (int)maxConnections));
        propertyMapper.from(besProperties::getAcceptCount).when(this::isPositive).to(acceptCount -> this.customizeAcceptCount(factory, (int)acceptCount));
        this.customizeStaticResources(factory);
        this.customizeVirtualServer(factory);
        this.customizeJdbcResource(factory);
        this.customizeErrorReportValve(properties.getError(), factory);
        propertyMapper.from(besProperties::getUseRelativeRedirects).whenNonNull().to(useRelativeRedirects -> this.customizeUseRelativeRedirects(factory, (boolean)useRelativeRedirects));
        propertyMapper.from(besProperties::getJspPreCompile).whenNonNull().to(jspPreCompile -> this.customizeJspPreCompile(factory, (Boolean)jspPreCompile));
        propertyMapper.from(besProperties::getAdditionalTldSkipPatterns).whenNot(ObjectUtils::isEmpty).to(additionalTldSkipPatterns -> this.customizeAdditionalTldSkipPatterns(factory, (List<String>)additionalTldSkipPatterns));
        propertyMapper.from(besProperties::getXpoweredBy).whenNonNull().to(xpoweredBy -> this.customizeXpoweredBy(factory, (Boolean)xpoweredBy));
        propertyMapper.from(besProperties::getAsyncTimeout).when(this::isPositive).to(asyncTimeout -> this.customizeAsyncTimeout(factory, (long)asyncTimeout));
        propertyMapper.from(besProperties::getMaxParameterCount).when(this::isPositive).to(maxParameterCount -> this.customizeMaxParameterCount(factory, (int)maxParameterCount));
        propertyMapper.from(besProperties::getMaxPartCount).when(this::isPositive).to(maxPartCount -> this.customizeMaxPartCount(factory, (int)maxPartCount));
        propertyMapper.from(besProperties::getMaxPartHeaderSize).when(this::isPositive).to(maxPartHeaderSize -> this.customizeMaxPartHeaderSize(factory, (int)maxPartHeaderSize));
        propertyMapper.from(besProperties::getRequestCharacterEncoding).whenNonNull().to(requestCharacterEncoding -> this.customizeRequestCharaterEncoding(factory, (String)requestCharacterEncoding));
        propertyMapper.from(besProperties::getResponseCharacterEncoding).whenNonNull().to(responseCharacterEncoding -> this.customizeResponseCharaterEncoding(factory, (String)responseCharacterEncoding));
        propertyMapper.from(besProperties::isUseBodyEncodingForUri).to(useBodyEncodingForURI -> this.customizeUseBodyEncodingForUri(factory, (boolean)useBodyEncodingForURI));
        propertyMapper.from(besProperties::getConnectionUploadTimeout).whenNonNull().to(connectionUploadTimeout -> this.customizeConnectionUploadTimeout(factory, (Integer)connectionUploadTimeout));
        propertyMapper.from(besProperties::getDisableUploadTimeout).whenNonNull().to(disableUploadTimeout -> this.customizeDisableUploadTimeout(factory, (Boolean)disableUploadTimeout));
        propertyMapper.from(besProperties::getDnsLookupEnabled).whenNonNull().to(dnsLookupEnabled -> this.customizeDnsLookupEnabled(factory, (Boolean)dnsLookupEnabled));
        propertyMapper.from(besProperties::getUseNaming).whenNonNull().to(useNaming -> this.customizeUseNaming(factory, (Boolean)useNaming));
        propertyMapper.from(besProperties::getIgnoreAnnotations).whenNonNull().to(ignoreAnnotations -> this.customizeIgnoreAnnotations(factory, (Boolean)ignoreAnnotations));
        propertyMapper.from(besProperties::isRegisterDefaultServlet).whenNonNull().to(registerDefaultServlet -> this.customizeRegisterBesDefaultServlet(factory, (Boolean)registerDefaultServlet));
        propertyMapper.from(besProperties::getScanClassPath).whenNonNull().to(scanClassPath -> this.customizeScanClassPath(factory, (Boolean)scanClassPath));
        propertyMapper.from(besProperties::getScanManifest).whenNonNull().to(scanManifest -> this.customizeScanManifest(factory, (Boolean)scanManifest));
        propertyMapper.from(besProperties::getScanAllFiles).whenNonNull().to(scanAllFiles -> this.customizeScanAllFiles(factory, (Boolean)scanAllFiles));
        propertyMapper.from(besProperties::getScanAllDirectories).whenNonNull().to(scanAllDirectories -> this.customizeScanAllDirectories(factory, (Boolean)scanAllDirectories));
        propertyMapper.from(besProperties::getScanBootstrapClassPath).whenNonNull().to(scanBootstrapClassPath -> this.customizeScanBootstrapClassPath(factory, (Boolean)scanBootstrapClassPath));
        propertyMapper.from(besProperties::getSharedContainer).whenNonNull().to(sharedContainer -> this.customizeSharedContainer((BesServletWebServerFactory)factory, (Boolean)sharedContainer));
    }

    private void customizeRegisterBesDefaultServlet(ConfigurableBesWebServerFactory factory, Boolean registerDefaultServlet) {
        factory.setRegisterBesDefaultServlet(registerDefaultServlet);
    }

    private void customizeScanClassPath(ConfigurableBesWebServerFactory factory, Boolean scanClassPath) {
        factory.addContextCustomizers(context -> {
            JarScanner jarScanner = context.getJarScanner();
            if (jarScanner instanceof StandardJarScanner) {
                StandardJarScanner standardJarScanner = (StandardJarScanner)jarScanner;
                standardJarScanner.setScanClassPath(scanClassPath);
            }
        });
    }

    private void customizeScanManifest(ConfigurableBesWebServerFactory factory, Boolean scanManifest) {
        factory.addContextCustomizers(context -> {
            JarScanner jarScanner = context.getJarScanner();
            if (jarScanner instanceof StandardJarScanner) {
                StandardJarScanner standardJarScanner = (StandardJarScanner)jarScanner;
                standardJarScanner.setScanManifest(scanManifest);
            }
        });
    }

    private void customizeScanAllFiles(ConfigurableBesWebServerFactory factory, Boolean scanAllFiles) {
        factory.addContextCustomizers(context -> {
            JarScanner jarScanner = context.getJarScanner();
            if (jarScanner instanceof StandardJarScanner) {
                StandardJarScanner standardJarScanner = (StandardJarScanner)jarScanner;
                standardJarScanner.setScanAllFiles(scanAllFiles);
            }
        });
    }

    private void customizeScanAllDirectories(ConfigurableBesWebServerFactory factory, Boolean scanAllDirectories) {
        factory.addContextCustomizers(context -> {
            JarScanner jarScanner = context.getJarScanner();
            if (jarScanner instanceof StandardJarScanner) {
                StandardJarScanner standardJarScanner = (StandardJarScanner)jarScanner;
                standardJarScanner.setScanAllDirectories(scanAllDirectories);
            }
        });
    }

    private void customizeScanBootstrapClassPath(ConfigurableBesWebServerFactory factory, Boolean scanBootstrapClassPath) {
        factory.addContextCustomizers(context -> {
            JarScanner jarScanner = context.getJarScanner();
            if (jarScanner instanceof StandardJarScanner) {
                StandardJarScanner standardJarScanner = (StandardJarScanner)jarScanner;
                standardJarScanner.setScanBootstrapClassPath(scanBootstrapClassPath);
            }
        });
    }

    private void customizeSharedContainer(BesServletWebServerFactory factory, Boolean sharedContainer) {
        factory.setSharedContainer(sharedContainer);
    }

    private void customizeIgnoreAnnotations(ConfigurableBesWebServerFactory factory, Boolean ignoreAnnotations) {
        factory.addContextCustomizers(context -> context.setIgnoreAnnotations(this.besProperties.getBes().getIgnoreAnnotations()));
    }

    private void customizeUseNaming(ConfigurableBesWebServerFactory factory, Boolean useNaming) {
        factory.setUseNaming(useNaming);
    }

    private void customizeDnsLookupEnabled(ConfigurableBesWebServerFactory factory, Boolean dnsLookupEnabled) {
        factory.addConnectorCustomizers(connector -> connector.setEnableLookups(dnsLookupEnabled));
    }

    private void customizeXpoweredBy(ConfigurableBesWebServerFactory factory, Boolean xpoweredBy) {
        factory.addConnectorCustomizers(connector -> connector.setXpoweredBy(xpoweredBy));
    }

    private void customizeAsyncTimeout(ConfigurableBesWebServerFactory factory, long asyncTimeout) {
        factory.addConnectorCustomizers(connector -> connector.setAsyncTimeout(asyncTimeout));
    }

    private void customizeDisableUploadTimeout(ConfigurableBesWebServerFactory factory, Boolean disableUploadTimeout) {
        factory.addConnectorCustomizers(connector -> connector.setProperty("disableUploadTimeout", String.valueOf(disableUploadTimeout)));
    }

    private void customizeConnectionUploadTimeout(ConfigurableBesWebServerFactory factory, Integer connectionUploadTimeout) {
        factory.addConnectorCustomizers(connector -> connector.setProperty("connectionUploadTimeout", String.valueOf(connectionUploadTimeout)));
    }

    private void customizeMaxParameterCount(ConfigurableBesWebServerFactory factory, int maxParameterCount) {
        factory.addConnectorCustomizers(connector -> connector.setMaxParameterCount(maxParameterCount));
    }

    private void customizeMaxPartCount(ConfigurableBesWebServerFactory factory, int maxPartCount) {
        factory.addConnectorCustomizers(connector -> connector.setMaxPartCount(maxPartCount));
    }

    private void customizeMaxPartHeaderSize(ConfigurableBesWebServerFactory factory, int maxPartHeaderSize) {
        factory.addConnectorCustomizers(connector -> connector.setMaxPartHeaderSize(maxPartHeaderSize));
    }

    private void customizeRequestCharaterEncoding(ConfigurableBesWebServerFactory factory, String requestCharaterEncoding) {
        factory.addConnectorCustomizers(connector -> connector.setDefaultRequestCharacterEncoding(requestCharaterEncoding));
    }

    private void customizeResponseCharaterEncoding(ConfigurableBesWebServerFactory factory, String responseCharaterEncoding) {
        factory.addConnectorCustomizers(connector -> connector.setDefaultResponseCharacterEncoding(responseCharaterEncoding));
    }

    private void customizeUseBodyEncodingForUri(ConfigurableBesWebServerFactory factory, boolean useBodyEncodingForUri) {
        factory.addConnectorCustomizers(connector -> connector.setUseBodyEncodingForURI(useBodyEncodingForUri));
    }

    private boolean isPositive(int value) {
        return value > 0;
    }

    private boolean isPositive(long value) {
        return value > 0L;
    }

    private int determineMaxHttpHeaderSize() {
        return this.besProperties.getMaxHttpHeaderSize() > 0 ? this.besProperties.getMaxHttpHeaderSize() : this.besProperties.getBes().getMaxHttpHeaderSize();
    }

    private void customizeAcceptCount(ConfigurableBesWebServerFactory factory, int acceptCount) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setAcceptCount(acceptCount);
            }
        });
    }

    private void customizeMaxConnections(ConfigurableBesWebServerFactory factory, int maxConnections) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setMaxConnections(maxConnections);
            }
        });
    }

    private void customizeConnectionTimeout(ConfigurableBesWebServerFactory factory, Duration connectionTimeout) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setConnectionTimeout((int)connectionTimeout.toMillis());
            }
        });
    }

    private void customizeMaxKeepaliveRequests(ConfigurableBesWebServerFactory factory, int maxKeepaliveRequests) {
        factory.addConnectorCustomizers(connector -> connector.setProperty("maxKeepAliveRequests", String.valueOf(maxKeepaliveRequests)));
    }

    private void customizeKeepaliveTimeout(ConfigurableBesWebServerFactory factory, int keepaliveTimeout) {
        factory.addConnectorCustomizers(connector -> connector.setProperty("keepAliveTimeout", String.valueOf(keepaliveTimeout * 1000)));
    }

    private void customizeMaxHeaderCount(ConfigurableBesWebServerFactory factory, int maxHeaderCount) {
        factory.addConnectorCustomizers(connector -> connector.setProperty("maxHeaderCount", String.valueOf(maxHeaderCount)));
    }

    private void customizeRedirectContextRoot(ConfigurableBesWebServerFactory factory, boolean redirectContextRoot) {
        factory.addContextCustomizers(context -> context.setMapperContextRootRedirectEnabled(redirectContextRoot));
    }

    private void customizeRemoteIpValve(ConfigurableBesWebServerFactory factory) {
        BesProperties.Bes besServer = this.besProperties.getBes();
        String protocolHeader = besServer.getProtocolHeader();
        String remoteIpHeader = besServer.getRemoteIpHeader();
        if (StringUtils.hasText((String)protocolHeader) || StringUtils.hasText((String)remoteIpHeader) || this.getOrDeduceUseForwardHeaders()) {
            RemoteIpValve valve = new RemoteIpValve();
            valve.setProtocolHeader(StringUtils.hasLength((String)protocolHeader) ? protocolHeader : "X-Forwarded-Proto");
            if (StringUtils.hasLength((String)remoteIpHeader)) {
                valve.setRemoteIpHeader(remoteIpHeader);
            }
            valve.setInternalProxies(besServer.getInternalProxies());
            valve.setPortHeader(besServer.getPortHeader());
            valve.setProtocolHeaderHttpsValue(besServer.getProtocolHeaderHttpsValue());
            factory.addEngineValves(valve);
        }
    }

    private boolean getOrDeduceUseForwardHeaders() {
        if (this.besProperties.isUseForwardHeaders() != null) {
            return this.besProperties.isUseForwardHeaders();
        }
        CloudPlatform platform = CloudPlatform.getActive((Environment)this.environment);
        return platform != null && platform.isUsingForwardHeaders();
    }

    private void customizeMaxThreads(ConfigurableBesWebServerFactory factory, int maxThreads) {
        factory.addExecutorCustomizers(executor -> executor.setMaxThreads(maxThreads));
    }

    private void customizeMinThreads(ConfigurableBesWebServerFactory factory, int minSpareThreads) {
        factory.addExecutorCustomizers(executor -> executor.setMinSpareThreads(minSpareThreads));
    }

    private void customizeMaxQueueSize(ConfigurableBesWebServerFactory factory, int maxQueueSize) {
        factory.addExecutorCustomizers(executor -> executor.setMaxQueueSize(maxQueueSize));
    }

    private void customizeMaxIdleTime(ConfigurableBesWebServerFactory factory, int maxIdleTime) {
        factory.addExecutorCustomizers(executor -> executor.setMaxIdleTime(maxIdleTime));
    }

    private void customizeVirtualServer(ConfigurableBesWebServerFactory factory) {
        BesProperties.Bes bes = this.besProperties.getBes();
        if (bes.getStuckThreadMaxTime() < 0) {
            return;
        }
        factory.addVirtualServerCustomizers(defaultHost -> {
            Valve[] valves = defaultHost.getPipeline().getValves();
            StuckThreadDetectionValve stuckThreadDetectionValve = null;
            for (Valve valve : valves) {
                if (!(valve instanceof StuckThreadDetectionValve)) continue;
                stuckThreadDetectionValve = (StuckThreadDetectionValve)valve;
                break;
            }
            if (stuckThreadDetectionValve == null) {
                stuckThreadDetectionValve = new StuckThreadDetectionValve();
                defaultHost.addValve(stuckThreadDetectionValve);
            }
            stuckThreadDetectionValve.setThreshold(bes.getStuckThreadMaxTime());
            defaultHost.setBackgroundProcessorDelay(bes.getStuckThreadTimerInterval());
        });
    }

    private void customizeJdbcResource(ConfigurableBesWebServerFactory factory) {
        BesJdbcResource jdbcResource = this.besProperties.getBes().getJdbc();
        String name = jdbcResource.getName();
        if (StringUtils.hasLength((String)name) && jdbcResource.isEnabled()) {
            factory.addJdbcResourceCustomizers(namingResources -> {
                String isolationLevel;
                Integer maxConnectionAge;
                Integer statementCacheSize;
                Integer validateAtmostOncePeriodInSeconds;
                Integer validationQueryTimeout;
                int finalValue;
                Integer timeBetweenEvictionRunsMillis;
                Integer connectionLeakTimeoutInSeconds;
                Integer maxEvictableIdleTimeout;
                String validationQuery;
                Long maxWaitTimeInMillis;
                Integer maxPoolSize;
                Integer minIdle;
                ContextResource contextResource = new ContextResource();
                contextResource.setName(name);
                contextResource.setType(jdbcResource.getResourceType());
                contextResource.setScope("Shareable");
                contextResource.setAuth("Container");
                contextResource.setSingleton(true);
                contextResource.setProperty("scope", "Shareable");
                contextResource.setProperty("auth", "Container");
                contextResource.setProperty("name", name);
                contextResource.setProperty("jmxName", "com.bes.enterprise.management:type=datasources,name=" + name);
                contextResource.setProperty("driverClassName", jdbcResource.getDriverClassName());
                contextResource.setProperty("url", jdbcResource.getUrl());
                contextResource.setProperty("username", jdbcResource.getUsername());
                CipherAlgorithmProviderFactory algorithmProviderFactory = CipherAlgorithmProviderFactory.getInstance();
                String password = jdbcResource.getPassword();
                try {
                    if (algorithmProviderFactory.isCipherText(password)) {
                        password = algorithmProviderFactory.decrypt(password);
                    }
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
                contextResource.setProperty("password", password);
                Integer initialPoolSize = jdbcResource.getInitialPoolSize();
                if (initialPoolSize != null) {
                    contextResource.setProperty("initialPoolSize", String.valueOf(initialPoolSize));
                }
                if ((minIdle = jdbcResource.getMinIdle()) != null) {
                    contextResource.setProperty("minIdle", String.valueOf(minIdle));
                }
                if ((maxPoolSize = jdbcResource.getMaxPoolSize()) != null) {
                    contextResource.setProperty("maxPoolSize", String.valueOf(maxPoolSize));
                }
                if ((maxWaitTimeInMillis = jdbcResource.getMaxWaitTimeInMillis()) != null) {
                    contextResource.setProperty("maxWaitTimeInMillis", String.valueOf(maxWaitTimeInMillis));
                }
                if (StringUtils.hasLength((String)(validationQuery = jdbcResource.getValidationQuery()))) {
                    contextResource.setProperty("validationQuery", validationQuery);
                }
                boolean testOnBorrow = jdbcResource.isTestOnBorrow();
                contextResource.setProperty("testOnBorrow", String.valueOf(testOnBorrow));
                boolean testWhileIdle = jdbcResource.isTestWhileIdle();
                contextResource.setProperty("testWhileIdle", String.valueOf(testWhileIdle));
                boolean failAllConnection = jdbcResource.isFailAllConnection();
                contextResource.setProperty("failAllConnection", String.valueOf(failAllConnection));
                Integer idleTimeout = jdbcResource.getIdleTimeout();
                if (idleTimeout != null) {
                    contextResource.setProperty("idleTimeout", String.valueOf(idleTimeout));
                }
                if ((maxEvictableIdleTimeout = jdbcResource.getMaxEvictableIdleTimeout()) != null) {
                    contextResource.setProperty("maxEvictableIdleTimeout", String.valueOf(maxEvictableIdleTimeout));
                }
                if ((connectionLeakTimeoutInSeconds = jdbcResource.getConnectionLeakTimeoutInSeconds()) != null) {
                    contextResource.setProperty("connectionLeakTimeoutInSeconds", String.valueOf(connectionLeakTimeoutInSeconds));
                }
                if ((timeBetweenEvictionRunsMillis = jdbcResource.getTimeBetweenEvictionRunsMillis()) != null) {
                    contextResource.setProperty("timeBetweenEvictionRunsMillis", String.valueOf(timeBetweenEvictionRunsMillis));
                } else {
                    int dataToCalculate;
                    int n2 = dataToCalculate = idleTimeout > 0 && connectionLeakTimeoutInSeconds > 0 ? Math.min(idleTimeout, connectionLeakTimeoutInSeconds) : Math.max(idleTimeout, connectionLeakTimeoutInSeconds);
                    if (dataToCalculate > 0) {
                        finalValue = Math.min(dataToCalculate * 1000 / 3, Integer.valueOf(timeBetweenEvictionRunsMillisUpper));
                        contextResource.setProperty("timeBetweenEvictionRunsMillis", String.valueOf(finalValue));
                    } else {
                        contextResource.setProperty("timeBetweenEvictionRunsMillis", timeBetweenEvictionRunsMillisUpper);
                    }
                }
                Integer numTestsPerEvictionRun = jdbcResource.getNumTestsPerEvictionRun();
                if (numTestsPerEvictionRun != null) {
                    if (numTestsPerEvictionRun >= 0) {
                        contextResource.setProperty("numTestsPerEvictionRun", String.valueOf(numTestsPerEvictionRun));
                    } else {
                        finalValue = (int)Math.ceil(maxPoolSize / Math.abs(numTestsPerEvictionRun));
                        contextResource.setProperty("numTestsPerEvictionRun", String.valueOf(finalValue));
                    }
                } else {
                    contextResource.setProperty("numTestsPerEvictionRun", String.valueOf(maxPoolSize));
                }
                Integer fetchSize = jdbcResource.getFetchSize();
                if (fetchSize != null) {
                    contextResource.setProperty("fetchSize", String.valueOf(fetchSize));
                }
                if ((validationQueryTimeout = jdbcResource.getValidationQueryTimeout()) != null) {
                    contextResource.setProperty("validationQueryTimeout", String.valueOf(validationQueryTimeout));
                }
                if ((validateAtmostOncePeriodInSeconds = jdbcResource.getValidateAtmostOncePeriodInSeconds()) != null) {
                    contextResource.setProperty("validateAtmostOncePeriodInSeconds", String.valueOf(validateAtmostOncePeriodInSeconds));
                }
                if ((statementCacheSize = jdbcResource.getStatementCacheSize()) != null) {
                    contextResource.setProperty("statementCacheSize", String.valueOf(statementCacheSize));
                }
                boolean poolPreparedStatements = jdbcResource.isPoolPreparedStatements();
                contextResource.setProperty("poolPreparedStatements", String.valueOf(poolPreparedStatements));
                boolean poolStatements = jdbcResource.isPoolStatements();
                contextResource.setProperty("poolStatements", String.valueOf(poolStatements));
                Integer statementTimeoutInSeconds = jdbcResource.getStatementTimeoutInSeconds();
                if (statementTimeoutInSeconds != null) {
                    contextResource.setProperty("statementTimeoutInSeconds", String.valueOf(statementTimeoutInSeconds));
                }
                if ((maxConnectionAge = jdbcResource.getMaxConnectionAge()) != null) {
                    contextResource.setProperty("maxConnectionAge", String.valueOf(maxConnectionAge));
                }
                if (StringUtils.hasLength((String)(isolationLevel = jdbcResource.getIsolationLevel()))) {
                    contextResource.setProperty("isolationLevel", isolationLevel);
                }
                boolean accessToUnderlyingConnectionAllowed = jdbcResource.isAccessToUnderlyingConnectionAllowed();
                contextResource.setProperty("accessToUnderlyingConnectionAllowed", String.valueOf(accessToUnderlyingConnectionAllowed));
                boolean enableLeakageRecovery = jdbcResource.isEnableLeakageRecovery();
                contextResource.setProperty("enableLeakageRecovery", String.valueOf(enableLeakageRecovery));
                boolean logAbandoned = jdbcResource.isLogAbandoned();
                contextResource.setProperty("logAbandoned", String.valueOf(logAbandoned));
                boolean enableAutoCommitOnReturn = jdbcResource.isEnableAutoCommitOnReturn();
                contextResource.setProperty("enableAutoCommitOnReturn", String.valueOf(enableAutoCommitOnReturn));
                boolean rollbackOnReturn = jdbcResource.isRollbackOnReturn();
                contextResource.setProperty("rollbackOnReturn", String.valueOf(rollbackOnReturn));
                String defaultCatalog = jdbcResource.getDefaultCatalog();
                if (StringUtils.hasLength((String)defaultCatalog)) {
                    contextResource.setProperty("defaultCatalog", defaultCatalog);
                }
                boolean sqlTrace = jdbcResource.isSqlTrace();
                contextResource.setProperty("sqlTrace", String.valueOf(sqlTrace));
                Integer maxQueries = jdbcResource.getMaxQueries();
                if (maxQueries != null) {
                    contextResource.setProperty("maxQueries", String.valueOf(maxQueries));
                }
                boolean logFailed = jdbcResource.isLogFailed();
                contextResource.setProperty("logFailed", String.valueOf(logFailed));
                boolean logSlow = jdbcResource.isLogSlow();
                contextResource.setProperty("logSlow", String.valueOf(logSlow));
                boolean usingTrace = jdbcResource.isUsingTrace();
                contextResource.setProperty("usingTrace", String.valueOf(usingTrace));
                String connectionInitSqls = jdbcResource.getConnectionInitSqls();
                if (StringUtils.hasLength((String)connectionInitSqls)) {
                    contextResource.setProperty("connectionInitSqls", connectionInitSqls);
                }
                boolean fairness = jdbcResource.isFairness();
                contextResource.setProperty("fairness", String.valueOf(fairness));
                boolean enableSharingResources = jdbcResource.isEnableSharingResources();
                contextResource.setProperty("enableSharingResources", String.valueOf(enableSharingResources));
                List<Property> properties = jdbcResource.getProperties();
                for (Property property : properties) {
                    String propName = property.getName();
                    String propValue = property.getValue();
                    contextResource.setProperty(propName, propValue);
                }
                namingResources.addResource(contextResource);
            });
        }
    }

    private void customizeMaxHttpHeaderSize(ConfigurableBesWebServerFactory factory, int maxHttpHeaderSize) {
        factory.addConnectorCustomizers(connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setMaxHttpHeaderSize(maxHttpHeaderSize);
            }
        });
    }

    private void customizeMaxHttpPostSize(ConfigurableBesWebServerFactory factory, int maxHttpPostSize) {
        factory.addConnectorCustomizers(connector -> connector.setMaxPostSize(maxHttpPostSize));
    }

    private void customizeAccessLog(ConfigurableBesWebServerFactory factory) {
        BesProperties.Bes besServer = this.besProperties.getBes();
        AccessLogValve valve = new AccessLogValve();
        valve.setPattern(besServer.getAccesslog().getPattern());
        valve.setRotatableByTime(besServer.getAccesslog().isRotatableByTime());
        valve.setRotatableBySize(besServer.getAccesslog().isRotatableBySize());
        valve.setDirectory(besServer.getAccesslog().getDirectory());
        valve.setPrefix(besServer.getAccesslog().getPrefix());
        valve.setSuffix(besServer.getAccesslog().getSuffix());
        valve.setRenameOnRotate(besServer.getAccesslog().isRenameOnRotate());
        valve.setFileDateFormat(besServer.getAccesslog().getFileDateFormat());
        valve.setRequestAttributesEnabled(besServer.getAccesslog().isRequestAttributesEnabled());
        valve.setRotatableByTime(besServer.getAccesslog().isRotate());
        valve.setBuffered(besServer.getAccesslog().isBuffered());
        valve.setRotationSize(besServer.getAccesslog().getRotationSize());
        valve.setMaxHistoryFiles(besServer.getAccesslog().getMaxHistoryFiles());
        factory.addEngineValves(valve);
    }

    private void customizeStaticResources(ConfigurableBesWebServerFactory factory) {
        BesProperties.Bes.Resource resource = this.besProperties.getBes().getResource();
        factory.addContextCustomizers(context -> context.addLifecycleListener(event -> {
            if (event.getType().equals("configure_start")) {
                context.getResources().setAllowLinking(resource.getAllowLinking());
                String objectMaxSize = resource.getCacheObjectMaxSize();
                if (objectMaxSize != null && objectMaxSize.trim().length() != 0) {
                    context.getResources().setCacheObjectMaxSize(Integer.parseInt(objectMaxSize));
                }
                if (resource.getCacheTtl() != null) {
                    long ttl = resource.getCacheTtl().toMillis();
                    context.getResources().setCacheTtl(ttl);
                }
                context.getResources().setCachingAllowed(resource.getCachingAllowed());
                context.getResources().setTrackLockedFiles(resource.getTrackLockedFiles());
            }
        }));
    }

    private void customizeErrorReportValve(ErrorProperties error, ConfigurableBesWebServerFactory factory) {
        Class<?> clazz = null;
        try {
            clazz = error.getClass();
            Method method = clazz.getMethod("getIncludeStacktrace", new Class[0]);
            String returnTypeName = method.getReturnType().getSimpleName();
            if (returnTypeName.equals(INCLUDESTACKTRACE) || returnTypeName.equals(INCLUDEATTRIBUTE)) {
                factory.addContextCustomizers(context -> {
                    Valve[] valves;
                    boolean found = false;
                    for (Valve valve : valves = context.getParent().getPipeline().getValves()) {
                        if (!ErrorReportValve.class.getName().equals(valve.getClass().getName())) continue;
                        ((ErrorReportValve)valve).setShowServerInfo(false);
                        ((ErrorReportValve)valve).setShowReport(false);
                        found = true;
                        break;
                    }
                    if (!found) {
                        ErrorReportValve valve = new ErrorReportValve();
                        valve.setShowServerInfo(false);
                        valve.setShowReport(false);
                        context.getParent().getPipeline().addValve(valve);
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void customizeUseRelativeRedirects(ConfigurableBesWebServerFactory factory, boolean useRelativeRedirects) {
        factory.addContextCustomizers(context -> context.setUseRelativeRedirects(this.besProperties.getBes().getUseRelativeRedirects()));
    }

    private void customizeJspPreCompile(ConfigurableBesWebServerFactory factory, Boolean jspPreCompile) {
        factory.addContextCustomizers(context -> context.setJspPreCompile(this.besProperties.getBes().getJspPreCompile()));
    }

    private void customizeAdditionalTldSkipPatterns(ConfigurableBesWebServerFactory factory, List<String> additionalTldSkipPatterns) {
        factory.addContextCustomizers(context -> {
            StandardJarScanFilter jarScanner = (StandardJarScanFilter)context.getJarScanner().getJarScanFilter();
            jarScanner.setTldSkip(jarScanner.getTldSkip() + "," + StringUtils.collectionToCommaDelimitedString((Collection)additionalTldSkipPatterns));
        });
    }
}

