/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.springboot.autoconfigure;

import com.bes.enterprise.appserver.common.util.StringUtils;
import com.bes.enterprise.springboot.autoconfigure.BESServletWebServerFactoryCustomizer;
import com.bes.enterprise.springboot.autoconfigure.BesProperties;
import com.bes.enterprise.springboot.autoconfigure.BesWebServerFactoryCustomizer;
import com.bes.enterprise.web.Embedded;
import com.bes.enterprise.web.crane.UpgradeProtocol;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={BesProperties.class})
@Import(value={ServletWebServerFactoryAutoConfiguration.BeanPostProcessorsRegistrar.class})
public class BesWebServerFactoryCustomizerAutoConfiguration {

    @ConditionalOnClass(value={Embedded.class, UpgradeProtocol.class})
    public static class BesWebServerFactoryCustomizerConfiguration {
        @Value(value="${management.server.port:}")
        private String managementPort;
        private String sharedContainer = System.getProperty("com.bes.enterprise.springboot.embedded.container.shared");

        @Bean
        public BESServletWebServerFactoryCustomizer besServletWebServerFactoryCustomizer(BesProperties besProperties) {
            this.initSharedContainer(besProperties);
            return new BESServletWebServerFactoryCustomizer(besProperties);
        }

        @Bean
        public BesWebServerFactoryCustomizer besWebServerFactoryCustomizer(Environment environment, BesProperties besProperties) {
            this.initSharedContainer(besProperties);
            return new BesWebServerFactoryCustomizer(environment, besProperties);
        }

        private void initSharedContainer(BesProperties besProperties) {
            BesProperties.Bes bes = besProperties.getBes();
            if (bes.getSharedContainer() == null && !StringUtils.isBlank(this.managementPort) && StringUtils.isBlank(this.sharedContainer)) {
                bes.setSharedContainer(false);
            }
        }
    }
}

