/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.springboot.embedded;

import com.bes.enterprise.springboot.embedded.BesStarter;
import com.bes.enterprise.springboot.embedded.LazySessionIdGenerator;
import com.bes.enterprise.webtier.Container;
import com.bes.enterprise.webtier.Manager;
import com.bes.enterprise.webtier.core.DefaultContext;
import com.bes.enterprise.webtier.session.ManagerBase;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class BesEmbeddedContext
extends DefaultContext {
    private BesStarter starter;
    private final boolean overrideLoadOnStart = ReflectionUtils.findMethod(DefaultContext.class, (String)"loadOnStartup", (Class[])new Class[]{Container[].class}).getReturnType() == Boolean.TYPE;

    BesEmbeddedContext() {
    }

    @Override
    public boolean loadOnStartup(Container[] children) {
        if (this.overrideLoadOnStart) {
            return true;
        }
        return super.loadOnStartup(children);
    }

    @Override
    public void setManager(Manager manager) {
        if (manager instanceof ManagerBase) {
            ((ManagerBase)manager).setSessionIdGenerator(new LazySessionIdGenerator());
        }
        super.setManager(manager);
    }

    public void deferredLoadOnStartup() {
        ClassLoader classLoader = this.getLoader().getClassLoader();
        ClassLoader existingLoader = null;
        if (classLoader != null) {
            existingLoader = ClassUtils.overrideThreadContextClassLoader((ClassLoader)classLoader);
        }
        if (this.overrideLoadOnStart) {
            super.loadOnStartup(this.findChildren());
        }
        if (existingLoader != null) {
            ClassUtils.overrideThreadContextClassLoader((ClassLoader)existingLoader);
        }
    }

    public void setStarter(BesStarter starter) {
        this.starter = starter;
    }

    public BesStarter getStarter() {
        return this.starter;
    }
}

