/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.springboot.embedded;

import com.bes.enterprise.webtier.loader.ParallelWebappClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BesEmbeddedSpringBootClassLoader
extends ParallelWebappClassLoader {
    private static final Log logger = LogFactory.getLog(BesEmbeddedSpringBootClassLoader.class);

    public BesEmbeddedSpringBootClassLoader() {
    }

    public BesEmbeddedSpringBootClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    public URL findResource(String name) {
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return Collections.emptyEnumeration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> result = this.findExistingLoadedClass(name);
            Class<?> clazz = result = result == null ? this.doLoadClass(name) : result;
            if (result == null) {
                throw new ClassNotFoundException(name);
            }
            return this.resolveIfNecessary(result, resolve);
        }
    }

    private Class<?> findExistingLoadedClass(String name) {
        Class<?> resultClass = this.findLoadedClass0(name);
        resultClass = resultClass == null ? this.findLoadedClass(name) : resultClass;
        return resultClass;
    }

    private Class<?> doLoadClass(String name) throws ClassNotFoundException {
        this.checkPackageAccess(name);
        return this.loadFromParent(name);
    }

    private Class<?> resolveIfNecessary(Class<?> resultClass, boolean resolve) {
        if (resolve) {
            this.resolveClass(resultClass);
        }
        return resultClass;
    }

    @Override
    protected void addURL(URL url) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Ignoring request to add " + url + " to the bes classloader"));
        }
    }

    private Class<?> loadFromParent(String name) {
        if (this.parent == null) {
            return null;
        }
        try {
            return Class.forName(name, false, this.parent);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    private void checkPackageAccess(String name) throws ClassNotFoundException {
        if (this.securityManager != null && name.lastIndexOf(46) >= 0) {
            try {
                this.securityManager.checkPackageAccess(name.substring(0, name.lastIndexOf(46)));
            }
            catch (SecurityException ex) {
                throw new ClassNotFoundException("Security Violation, attempt to use Restricted Class: " + name, ex);
            }
        }
    }

    @Override
    public URL getResource(String name) {
        if (this.parent == null) {
            return null;
        }
        URL url = this.parent.getResource(name);
        if (url != null) {
            return url;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (this.parent == null) {
            return null;
        }
        InputStream stream = this.parent.getResourceAsStream(name);
        if (stream != null) {
            return stream;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.parent == null) {
            return null;
        }
        Enumeration<URL> urls = this.parent.getResources(name);
        if (urls != null) {
            return urls;
        }
        return null;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

