/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.springboot.embedded;

import com.bes.appserv.lic.Auth;
import com.bes.appserv.lic.LicData;
import com.bes.appserv.lic.LicenseHelper;
import com.bes.appserv.lic.client.handler.LicenseHandler;
import com.bes.enterprise.appserver.common.util.EmbeddedClassPreventUtil;
import com.bes.enterprise.appserver.common.util.FileUtils;
import com.bes.enterprise.springboot.autoconfigure.BesApplication;
import com.bes.enterprise.springboot.embedded.BesConnectorCustomizer;
import com.bes.enterprise.springboot.embedded.BesContextCustomizer;
import com.bes.enterprise.springboot.embedded.BesEmbeddedContext;
import com.bes.enterprise.springboot.embedded.BesEmbeddedSpringBootClassLoader;
import com.bes.enterprise.springboot.embedded.BesEmbeddedWebappClassLoader;
import com.bes.enterprise.springboot.embedded.BesErrorPage;
import com.bes.enterprise.springboot.embedded.BesExecutorCustomizer;
import com.bes.enterprise.springboot.embedded.BesJdbcResourceCustomizer;
import com.bes.enterprise.springboot.embedded.BesStarter;
import com.bes.enterprise.springboot.embedded.BesVirtualServerCustomizer;
import com.bes.enterprise.springboot.embedded.BesWebServer;
import com.bes.enterprise.springboot.embedded.ConfigurableBesWebServerFactory;
import com.bes.enterprise.springboot.embedded.SslConnectorCustomizer;
import com.bes.enterprise.springboot.embedded.StoreLicLifecycle;
import com.bes.enterprise.springboot.embedded.TldSkipPatterns;
import com.bes.enterprise.springboot.util.ClassPreventUtil;
import com.bes.enterprise.web.Embedded;
import com.bes.enterprise.web.VirtualHost;
import com.bes.enterprise.web.crane.AbstractProtocol;
import com.bes.enterprise.web.crane.ProtocolHandler;
import com.bes.enterprise.web.crane.http2.Http2Protocol;
import com.bes.enterprise.web.util.scan.StandardJarScanFilter;
import com.bes.enterprise.webtier.Context;
import com.bes.enterprise.webtier.Engine;
import com.bes.enterprise.webtier.Host;
import com.bes.enterprise.webtier.LifecycleEvent;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.LifecycleListener;
import com.bes.enterprise.webtier.Manager;
import com.bes.enterprise.webtier.Service;
import com.bes.enterprise.webtier.Valve;
import com.bes.enterprise.webtier.WebResource;
import com.bes.enterprise.webtier.WebResourceRoot;
import com.bes.enterprise.webtier.WebResourceSet;
import com.bes.enterprise.webtier.Wrapper;
import com.bes.enterprise.webtier.connector.Connector;
import com.bes.enterprise.webtier.core.DefaultContext;
import com.bes.enterprise.webtier.core.DefaultHost;
import com.bes.enterprise.webtier.core.WorkThreadExecutor;
import com.bes.enterprise.webtier.deploy.NamingResourcesImpl;
import com.bes.enterprise.webtier.loader.WebappLoader;
import com.bes.enterprise.webtier.session.DefaultManager;
import com.bes.enterprise.webtier.startup.BESCore;
import com.bes.enterprise.webtier.util.LifecycleBase;
import com.bes.enterprise.webtier.util.ServerInfo;
import com.bes.enterprise.webtier.webresources.AbstractResourceSet;
import com.bes.enterprise.webtier.webresources.EmptyResource;
import com.bes.enterprise.webtier.webresources.StandardRoot;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.servlet.ServletContainerInitializer;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.boot.system.ApplicationPid;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.server.MimeMappings;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.server.AbstractServletWebServerFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class BesServletWebServerFactory
extends AbstractServletWebServerFactory
implements ConfigurableBesWebServerFactory,
ResourceLoaderAware {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Set<Class<?>> NO_CLASSES = Collections.emptySet();
    public static final String DEFAULT_PROTOCOL = "com.bes.enterprise.web.crane.http11.Http11NioProtocol";
    private File baseDirectory;
    private List<Valve> engineValves = new ArrayList<Valve>();
    private List<Valve> contextValves = new ArrayList<Valve>();
    private List<LifecycleListener> contextLifecycleListeners = new ArrayList<LifecycleListener>();
    private List<BesContextCustomizer> besContextCustomizers = new ArrayList<BesContextCustomizer>();
    private List<BesExecutorCustomizer> besExecutorCustomizers = new ArrayList<BesExecutorCustomizer>();
    private List<BesVirtualServerCustomizer> besVirtualServerCustomizers = new ArrayList<BesVirtualServerCustomizer>();
    private List<BesJdbcResourceCustomizer> besJdbcResourceCustomizers = new ArrayList<BesJdbcResourceCustomizer>();
    private List<BesConnectorCustomizer> besConnectorCustomizers = new ArrayList<BesConnectorCustomizer>();
    private List<Connector> additionalBesConnectors = new ArrayList<Connector>();
    private ResourceLoader resourceLoader;
    private String protocol = "com.bes.enterprise.web.crane.http11.Http11NioProtocol";
    private Set<String> tldSkipPatterns = new LinkedHashSet<String>(TldSkipPatterns.DEFAULT);
    private Charset uriEncoding = DEFAULT_CHARSET;
    private int backgroundProcessorDelay;
    private Boolean useNaming = false;
    private final Set<String> webListenerClassNames = new HashSet<String>();
    private List<BesApplication> modules = new ArrayList<BesApplication>();
    private static BesWebServer sharedBesWebServer = null;
    private boolean sharedContainer = Boolean.parseBoolean(System.getProperty("com.bes.enterprise.springboot.embedded.container.shared", "true"));
    private int storeLicInfoInterval = 30;
    private Boolean loadClassLocally = true;
    private final ApplicationPid pid = new ApplicationPid();
    private Boolean registerBesDefaultServlet = false;

    public BesServletWebServerFactory() {
    }

    public BesServletWebServerFactory(int port) {
        super(port);
    }

    public BesServletWebServerFactory(String contextPath, int port) {
        super(contextPath, port);
    }

    public void setModules(List<BesApplication> modules) {
        this.modules = modules;
    }

    private File initBaseDir() {
        File licenseDir;
        File baseDir = null;
        String installRoot = System.getProperty("com.bes.installRoot");
        if (installRoot != null) {
            baseDir = new File(installRoot);
        }
        if (baseDir == null && this.baseDirectory != null) {
            baseDir = this.baseDirectory;
        }
        if (baseDir == null && !(licenseDir = new File(baseDir = this.getDefaultBaseDirectory(), "license")).exists() && !licenseDir.mkdir()) {
            throw new IllegalStateException(String.format("Failed to create license directory %s.", licenseDir.getAbsolutePath()));
        }
        System.setProperty("com.bes.installRoot", baseDir.getAbsolutePath());
        System.setProperty("com.bes.instanceRoot", baseDir.getAbsolutePath());
        return baseDir;
    }

    private File getDefaultBaseDirectory() {
        File baseDir;
        String userDir = System.getProperty("user.dir");
        String fileName = "bes." + this.getPort();
        if (StringUtils.hasLength((String)userDir)) {
            baseDir = new File(userDir + File.separator + "appserver", fileName);
        } else {
            ApplicationHome applicationHome = new ApplicationHome(this.getClass());
            baseDir = new File(applicationHome.getDir() + File.separator + "appserver", fileName);
        }
        if (!baseDir.exists() && !baseDir.mkdirs()) {
            throw new IllegalStateException(String.format("Failed to create base directory %s.", baseDir.getAbsolutePath()));
        }
        return baseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebServer getWebServer(ServletContextInitializer ... initializers) {
        BesWebServer server;
        if (this.sharedContainer && sharedBesWebServer == null) {
            Class<BesWebServer> clazz = BesWebServer.class;
            synchronized (BesWebServer.class) {
                if (sharedBesWebServer == null) {
                    sharedBesWebServer = this.buildBesWebServer(initializers);
                }
                server = sharedBesWebServer;
                // ** MonitorExit[var3_2] (shouldn't be in output)
            }
        } else if (this.sharedContainer) {
            Embedded bes = sharedBesWebServer.getBes();
            this.prepareContext(bes.getHost(), initializers);
            server = sharedBesWebServer;
        } else {
            server = this.buildBesWebServer(initializers);
        }
        return server;
    }

    private BesWebServer buildBesWebServer(ServletContextInitializer ... initializers) {
        File baseDir = this.initBaseDir();
        if (!BesWebServer.checkedLic) {
            this.checkLic(baseDir);
            BesWebServer.checkedLic = true;
            try {
                if (this.getClass().getClassLoader().getResource("").getPath().contains("!")) {
                    ClassPreventUtil.check();
                } else {
                    EmbeddedClassPreventUtil.check();
                }
            }
            catch (Exception e2) {
                this.logger.warn((Object)e2.getMessage());
            }
        }
        Embedded bes = this.prepareEmbedded(baseDir, initializers);
        BesWebServer server = this.getBesWebServer(bes);
        if (this.storeLicInfoInterval > 0) {
            StoreLicLifecycle lifecycle = new StoreLicLifecycle(FileUtils.createLicTmp("bes." + this.getPort()), this.storeLicInfoInterval);
            server.addLifecycle(lifecycle);
        }
        return server;
    }

    private void checkLic(File baseDir) {
        try {
            Auth.check(baseDir.getAbsolutePath(), "WEB", "SpringBoot", "Universal");
            if (this.logger.isInfoEnabled()) {
                this.showLicInfo();
                long remainingDays = Auth.queryExpiry(baseDir.getAbsolutePath());
                long expirtionReminderDays = Auth.getShowMsgExpiryDays();
                if (remainingDays <= expirtionReminderDays && remainingDays != -1L) {
                    this.logger.info((Object)("BES will expire in " + remainingDays + " days."));
                }
            }
            if (Auth.isLicManager()) {
                LicenseHandler handler = LicenseHandler.getInstance();
                Thread shutdownHookThread = handler.getShutdownHookThread();
                Runtime.getRuntime().addShutdownHook(shutdownHookThread);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error occurred when checking license :" + ex.getMessage());
        }
    }

    private Embedded prepareEmbedded(File baseDir, ServletContextInitializer ... initializers) {
        Embedded bes = new Embedded();
        bes.setBaseDir(baseDir.getAbsolutePath());
        for (com.bes.enterprise.webtier.Executor executor : bes.getService().findExecutors()) {
            this.customizeThreadPool(executor);
        }
        this.customizeConnector(bes);
        this.configureEngine(bes.getEngine());
        for (Connector additionalConnector : this.additionalBesConnectors) {
            String defaultVirtualServer = additionalConnector.getDefaultVirtualServer();
            if (StringUtils.isEmpty((Object)defaultVirtualServer) || "localhost".equals(defaultVirtualServer)) {
                additionalConnector.setDefaultVirtualServer("server");
            }
            bes.getService().addConnector(additionalConnector);
        }
        this.customizeVirtualServer(bes.getHost());
        this.prepareContext(bes.getHost(), initializers);
        this.customizeJdbcResource(bes.getServer().getGlobalNamingResources());
        this.prepareBesApplication(bes);
        return bes;
    }

    private void showLicInfo() throws Exception {
        LicData licData = LicenseHelper.readLicData();
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder licInfo = new StringBuilder();
        licInfo.append("Server information :").append(lineSeparator);
        licInfo.append("----------------------------------------------------------------");
        licInfo.append(lineSeparator);
        licInfo.append(ServerInfo.getServerInfoAndServerNumber()).append(lineSeparator);
        licInfo.append(ServerInfo.getServerBuilt()).append(lineSeparator);
        licInfo.append("Copyright (c) 2018-2022 Beijing Baolande Software Corporation. All Rights Reserved.");
        licInfo.append(lineSeparator);
        licInfo.append(lineSeparator);
        licInfo.append("License information :").append(lineSeparator);
        licInfo.append("   ").append("Custom  Name : ").append(licData.getCustomerName());
        licInfo.append(lineSeparator);
        licInfo.append("   ").append("Project Name : ").append(licData.getProjectName());
        licInfo.append(lineSeparator);
        licInfo.append("   ").append("License Type : ").append(licData.getRegisterType());
        licInfo.append(lineSeparator);
        licInfo.append("   ").append("Expiry  Date : ").append(licData.getExpiryDate());
        licInfo.append(lineSeparator);
        licInfo.append("----------------------------------------------------------------");
        this.logger.info((Object)licInfo.toString());
    }

    private void configureEngine(Engine engine) {
        engine.setName("BES");
        engine.setBackgroundProcessorDelay(this.backgroundProcessorDelay);
        for (Valve valve : this.engineValves) {
            engine.getPipeline().addValve(valve);
        }
    }

    protected void prepareContext(Host host, ServletContextInitializer[] initializers) {
        File documentRoot = this.getValidDocumentRoot();
        BesEmbeddedContext context = new BesEmbeddedContext();
        if (documentRoot != null) {
            context.setResources(new LoaderHidingResourceRoot(context));
        }
        context.setName(this.getContextPath());
        context.setDisplayName(this.getDisplayName());
        context.setPath(this.getContextPath());
        File workFile = new File(this.getDefaultBaseDirectory(), "bes-docbase");
        workFile.mkdirs();
        workFile.deleteOnExit();
        File docBase = documentRoot != null ? documentRoot : workFile;
        context.setDocBase(docBase.getAbsolutePath());
        context.addLifecycleListener(new BESCore.FixContextListener());
        context.setParentClassLoader(this.resourceLoader != null ? this.resourceLoader.getClassLoader() : ClassUtils.getDefaultClassLoader());
        this.resetDefaultLocaleMapping(context);
        this.addLocaleMappings(context);
        context.setUseRelativeRedirects(false);
        this.configureTldSkipPatterns(context);
        WebappLoader loader = new WebappLoader(context.getParentClassLoader());
        loader.setLoaderClass(this.loadClassLocally != false ? BesEmbeddedWebappClassLoader.class.getName() : BesEmbeddedSpringBootClassLoader.class.getName());
        loader.setDelegate(true);
        context.setLoader(loader);
        if (this.isRegisterDefaultServlet() || this.registerBesDefaultServlet.booleanValue()) {
            this.addDefaultServlet(context);
        }
        if (this.shouldRegisterJspServlet()) {
            this.addJspServlet(context);
            this.addJasperInitializer(context);
        }
        context.addLifecycleListener(new StaticResourceConfigurer(context));
        ServletContextInitializer[] initializersToUse = this.mergeInitializers(initializers);
        context.setParent(host);
        this.configureContext(context, initializersToUse);
        host.addChild(context);
        this.postProcessContext(context);
    }

    protected void prepareBesApplication(Embedded bes) {
        bes.getHost().setConfigClass("com.bes.enterprise.webtier.startup.ContextConfig");
        ((VirtualHost)bes.getHost()).setUnpackWARs(false);
        Collections.sort(this.modules);
        for (BesApplication app : this.modules) {
            if (!app.isEnabled() || app.getPath() == null) continue;
            File file = new File(app.getPath());
            String contextRoot = app.getContextPath() == null ? "/" + file.getName() : app.getContextPath();
            try {
                Context context = bes.addWebapp(contextRoot, file.getAbsolutePath());
                context.setParentClassLoader(this.getClass().getClassLoader());
                if (!(context instanceof DefaultContext)) continue;
                ((DefaultContext)context).setOrder(app.getId());
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to add webapp", ex);
            }
        }
    }

    private void resetDefaultLocaleMapping(BesEmbeddedContext context) {
        context.addLocaleEncodingMappingParameter(Locale.ENGLISH.toString(), DEFAULT_CHARSET.displayName());
        context.addLocaleEncodingMappingParameter(Locale.FRENCH.toString(), DEFAULT_CHARSET.displayName());
    }

    private void addLocaleMappings(BesEmbeddedContext context) {
        for (Map.Entry entry : this.getLocaleCharsetMappings().entrySet()) {
            Locale locale = (Locale)entry.getKey();
            Charset charset = (Charset)entry.getValue();
            context.addLocaleEncodingMappingParameter(locale.toString(), charset.toString());
        }
    }

    private void configureTldSkipPatterns(BesEmbeddedContext context) {
        StandardJarScanFilter filter = new StandardJarScanFilter();
        filter.setTldSkip(StringUtils.collectionToCommaDelimitedString(this.tldSkipPatterns));
        context.getJarScanner().setJarScanFilter(filter);
    }

    private void addDefaultServlet(Context context) {
        Wrapper defaultServlet = context.createWrapper();
        defaultServlet.setName("default");
        defaultServlet.setServletClass("com.bes.enterprise.webtier.servlets.DefaultServlet");
        defaultServlet.addInitParameter("debug", "0");
        defaultServlet.addInitParameter("listings", "false");
        defaultServlet.setLoadOnStartup(1);
        defaultServlet.setOverridable(true);
        context.addChild(defaultServlet);
        context.addServletMappingDecoded("/", "default");
    }

    private void addJspServlet(Context context) {
        Wrapper jspServlet = context.createWrapper();
        jspServlet.setName("jsp");
        jspServlet.setServletClass(this.getJsp().getClassName());
        jspServlet.addInitParameter("fork", "false");
        for (Map.Entry initParameter : this.getJsp().getInitParameters().entrySet()) {
            jspServlet.addInitParameter((String)initParameter.getKey(), (String)initParameter.getValue());
        }
        jspServlet.setLoadOnStartup(3);
        context.addChild(jspServlet);
        context.addServletMappingDecoded("*.jsp", "jsp");
        context.addServletMappingDecoded("*.jspx", "jsp");
    }

    private void addJasperInitializer(BesEmbeddedContext context) {
        try {
            ServletContainerInitializer initializer = (ServletContainerInitializer)ClassUtils.forName((String)"com.bes.enterprise.web.jasper.servlet.JasperInitializer", null).newInstance();
            context.addServletContainerInitializer(initializer, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void customizeThreadPool(com.bes.enterprise.webtier.Executor executor) {
        if (!(executor instanceof WorkThreadExecutor)) {
            return;
        }
        WorkThreadExecutor workThreadPool = (WorkThreadExecutor)executor;
        for (BesExecutorCustomizer customizer : this.besExecutorCustomizers) {
            customizer.customize(workThreadPool);
        }
    }

    private void rebuildThreadNamePrefix(Connector connector) {
        Executor executor = connector.getProtocolHandler().getExecutor();
        if (executor instanceof WorkThreadExecutor) {
            WorkThreadExecutor workThreadExecutor = (WorkThreadExecutor)executor;
            String prefix = connector.getSecure() ? "httpSSLWorkerThread-" : "httpWorkerThread-";
            String name = prefix + connector.getPort();
            prefix = name + "-";
            workThreadExecutor.setName(name);
            workThreadExecutor.setNamePrefix(prefix);
        }
    }

    protected void customizeVirtualServer(Host host) {
        if (!(host instanceof DefaultHost)) {
            return;
        }
        DefaultHost defaultHost = (DefaultHost)host;
        host.setAutoDeploy(false);
        for (BesVirtualServerCustomizer customizer : this.besVirtualServerCustomizers) {
            customizer.customize(defaultHost);
        }
    }

    protected void customizeJdbcResource(NamingResourcesImpl namingResources) {
        for (BesJdbcResourceCustomizer customizer : this.besJdbcResourceCustomizers) {
            customizer.customize(namingResources);
        }
    }

    protected void customizeConnector(Embedded embedded) {
        Connector connector = embedded.getConnector();
        if (!this.protocol.equals(DEFAULT_PROTOCOL)) {
            Service service = embedded.getService();
            service.removeConnector(connector);
            String defaultVirtualServer = connector.getDefaultVirtualServer();
            Executor executor = connector.getProtocolHandler().getExecutor();
            connector = new Connector(this.protocol);
            connector.setDefaultVirtualServer(defaultVirtualServer);
            ProtocolHandler protocolHandlerClass = connector.getProtocolHandler();
            Method setExecutorMethod = ClassUtils.getMethod(AbstractProtocol.class, (String)"setExecutor", (Class[])new Class[]{Executor.class});
            ReflectionUtils.invokeMethod((Method)setExecutorMethod, (Object)protocolHandlerClass, (Object[])new Object[]{executor});
            embedded.setConnector(connector);
        }
        int port = this.getPort() >= 0 ? this.getPort() : 0;
        connector.setPort(port);
        if (StringUtils.hasText((String)this.getServerHeader())) {
            connector.setAttribute("server", this.getServerHeader());
        }
        if (connector.getProtocolHandler() instanceof AbstractProtocol) {
            this.customizeProtocol((AbstractProtocol)connector.getProtocolHandler());
        }
        if (this.getUriEncoding() != null) {
            connector.setURIEncoding(this.getUriEncoding().name());
        }
        connector.setProperty("bindOnInit", "false");
        if (this.getSsl() != null && this.getSsl().isEnabled()) {
            this.customizeSsl(connector);
        }
        for (BesConnectorCustomizer customizer : this.besConnectorCustomizers) {
            customizer.customize(connector);
        }
        if (this.getPort() > 0 || this.getSsl() != null && this.getSsl().isEnabled()) {
            this.rebuildThreadNamePrefix(connector);
        }
    }

    private void customizeProtocol(AbstractProtocol<?> protocol) {
        if (this.getAddress() != null) {
            protocol.setAddress(this.getAddress());
        }
    }

    private void customizeSsl(Connector connector) {
        new SslConnectorCustomizer(this.getSsl(), this.getSslStoreProvider()).customize(connector);
        if (this.getHttp2() != null && this.getHttp2().isEnabled()) {
            connector.addUpgradeProtocol(new Http2Protocol());
        }
    }

    protected void configureContext(Context context, ServletContextInitializer[] initializers) {
        BesStarter starter = new BesStarter(initializers);
        if (context instanceof BesEmbeddedContext) {
            ((BesEmbeddedContext)context).setStarter(starter);
        }
        context.addServletContainerInitializer(starter, NO_CLASSES);
        for (LifecycleListener lifecycleListener : this.contextLifecycleListeners) {
            context.addLifecycleListener(lifecycleListener);
        }
        for (Valve valve : this.contextValves) {
            context.getPipeline().addValve(valve);
        }
        for (ErrorPage errorPage : this.getErrorPages()) {
            new BesErrorPage(errorPage).addToContext(context);
        }
        for (MimeMappings.Mapping mapping : this.getMimeMappings()) {
            context.addMimeMapping(mapping.getExtension(), mapping.getMimeType());
        }
        this.configureSession(context);
        if (!this.getBESWebListenerClassNames().isEmpty()) {
            for (String webListenerClassName : this.getBESWebListenerClassNames()) {
                context.addApplicationListener(webListenerClassName);
            }
        }
        for (BesContextCustomizer customizer : this.besContextCustomizers) {
            customizer.customize(context);
        }
    }

    public void addWebListeners(String ... webListenerClassNames) {
        this.webListenerClassNames.addAll(Arrays.asList(webListenerClassNames));
    }

    protected final Set<String> getBESWebListenerClassNames() {
        return this.webListenerClassNames;
    }

    private void configureSession(Context context) {
        long sessionTimeout = this.getSessionTimeoutInMinutes();
        context.setSessionTimeout((int)sessionTimeout);
        Boolean httpOnly = this.getSession().getCookie().getHttpOnly();
        if (httpOnly != null) {
            context.setUseHttpOnly(httpOnly);
        }
        if (this.getSession().isPersistent()) {
            Manager manager = context.getManager();
            if (manager == null) {
                manager = new DefaultManager();
                context.setManager(manager);
            }
            this.configurePersistSession(manager);
        } else {
            context.addLifecycleListener(new DisablePersistSessionListener());
        }
    }

    private void configurePersistSession(Manager manager) {
        Assert.state((boolean)(manager instanceof DefaultManager), () -> "Unable to persist HTTP session state using manager type " + manager.getClass().getName());
        File dir = this.getValidSessionStoreDir();
        File file = new File(dir, "SESSIONS.ser");
        ((DefaultManager)manager).setPathname(file.getAbsolutePath());
    }

    private long getSessionTimeoutInMinutes() {
        Duration sessionTimeout = this.getSession().getTimeout();
        if (this.isZeroOrLess(sessionTimeout)) {
            return 0L;
        }
        return Math.max(sessionTimeout.toMinutes(), 1L);
    }

    private boolean isZeroOrLess(Duration sessionTimeout) {
        return sessionTimeout == null || sessionTimeout.isNegative() || sessionTimeout.isZero();
    }

    protected void postProcessContext(Context context) {
    }

    protected BesWebServer getBesWebServer(Embedded bes) {
        return new BesWebServer(bes, this.getPort() >= 0, this.useNaming);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void setSharedContainer(boolean sharedContainer) {
        this.sharedContainer = sharedContainer;
    }

    public Set<String> getTldSkipPatterns() {
        return this.tldSkipPatterns;
    }

    public void setTldSkipPatterns(Collection<String> patterns) {
        Assert.notNull(patterns, (String)"Patterns must not be null");
        this.tldSkipPatterns = new LinkedHashSet<String>(patterns);
    }

    public void addTldSkipPatterns(String ... patterns) {
        Assert.notNull((Object)patterns, (String)"Patterns must not be null");
        this.tldSkipPatterns.addAll(Arrays.asList(patterns));
    }

    public void setProtocol(String protocol) {
        Assert.hasLength((String)protocol, (String)"Protocol must not be empty");
        this.protocol = protocol;
    }

    public void setEngineValves(Collection<? extends Valve> engineValves) {
        Assert.notNull(engineValves, (String)"Valves must not be null");
        this.engineValves = new ArrayList<Valve>(engineValves);
    }

    public Collection<Valve> getEngineValves() {
        return this.engineValves;
    }

    @Override
    public void addEngineValves(Valve ... engineValves) {
        Assert.notNull((Object)engineValves, (String)"Valves must not be null");
        this.engineValves.addAll(Arrays.asList(engineValves));
    }

    public void setContextValves(Collection<? extends Valve> contextValves) {
        Assert.notNull(contextValves, (String)"Valves must not be null");
        this.contextValves = new ArrayList<Valve>(contextValves);
    }

    public Collection<Valve> getContextValves() {
        return this.contextValves;
    }

    public void addContextValves(Valve ... contextValves) {
        Assert.notNull((Object)contextValves, (String)"Valves must not be null");
        this.contextValves.addAll(Arrays.asList(contextValves));
    }

    public void setContextLifecycleListeners(Collection<? extends LifecycleListener> contextLifecycleListeners) {
        Assert.notNull(contextLifecycleListeners, (String)"ContextLifecycleListeners must not be null");
        this.contextLifecycleListeners = new ArrayList<LifecycleListener>(contextLifecycleListeners);
    }

    public Collection<LifecycleListener> getContextLifecycleListeners() {
        return this.contextLifecycleListeners;
    }

    public void addContextLifecycleListeners(LifecycleListener ... contextLifecycleListeners) {
        Assert.notNull((Object)contextLifecycleListeners, (String)"ContextLifecycleListeners must not be null");
        this.contextLifecycleListeners.addAll(Arrays.asList(contextLifecycleListeners));
    }

    public void setBesContextCustomizers(Collection<? extends BesContextCustomizer> besContextCustomizers) {
        Assert.notNull(besContextCustomizers, (String)"BesContextCustomizers must not be null");
        this.besContextCustomizers = new ArrayList<BesContextCustomizer>(besContextCustomizers);
    }

    public Collection<BesContextCustomizer> getBesContextCustomizers() {
        return this.besContextCustomizers;
    }

    @Override
    public void addContextCustomizers(BesContextCustomizer ... besContextCustomizers) {
        Assert.notNull((Object)besContextCustomizers, (String)"BesContextCustomizers must not be null");
        this.besContextCustomizers.addAll(Arrays.asList(besContextCustomizers));
    }

    @Override
    public void addExecutorCustomizers(BesExecutorCustomizer ... besExecutorCustomizers) {
        Assert.notNull((Object)besExecutorCustomizers, (String)"besExecutorCustomizers must not be null");
        this.besExecutorCustomizers.addAll(Arrays.asList(besExecutorCustomizers));
    }

    @Override
    public void setRegisterBesDefaultServlet(Boolean registerBesDefaultServlet) {
        this.registerBesDefaultServlet = registerBesDefaultServlet;
    }

    @Override
    public void addVirtualServerCustomizers(BesVirtualServerCustomizer ... besVirtualServerCustomizers) {
        Assert.notNull((Object)besVirtualServerCustomizers, (String)"besVirtualServerCustomizers must not be null");
        this.besVirtualServerCustomizers.addAll(Arrays.asList(besVirtualServerCustomizers));
    }

    @Override
    public void addJdbcResourceCustomizers(BesJdbcResourceCustomizer ... besJdbcResourceCustomizers) {
        Assert.notNull((Object)besJdbcResourceCustomizers, (String)"besJdbcResourceCustomizers must not be null");
        this.besJdbcResourceCustomizers.addAll(Arrays.asList(besJdbcResourceCustomizers));
    }

    public void setBesConnectorCustomizers(Collection<? extends BesConnectorCustomizer> besConnectorCustomizers) {
        Assert.notNull(besConnectorCustomizers, (String)"BesConnectorCustomizers must not be null");
        this.besConnectorCustomizers = new ArrayList<BesConnectorCustomizer>(besConnectorCustomizers);
    }

    @Override
    public void addConnectorCustomizers(BesConnectorCustomizer ... besConnectorCustomizers) {
        Assert.notNull((Object)besConnectorCustomizers, (String)"BesConnectorCustomizers must not be null");
        this.besConnectorCustomizers.addAll(Arrays.asList(besConnectorCustomizers));
    }

    public Collection<BesConnectorCustomizer> getBesConnectorCustomizers() {
        return this.besConnectorCustomizers;
    }

    public void addAdditionalBesConnectors(Connector ... connectors) {
        Assert.notNull((Object)connectors, (String)"Connectors must not be null");
        this.additionalBesConnectors.addAll(Arrays.asList(connectors));
    }

    public List<Connector> getAdditionalBesConnectors() {
        return this.additionalBesConnectors;
    }

    @Override
    public void setUriEncoding(Charset uriEncoding) {
        this.uriEncoding = uriEncoding;
    }

    @Override
    public void setUseNaming(Boolean useNaming) {
        this.useNaming = useNaming;
    }

    public Boolean getUseNaming() {
        return this.useNaming;
    }

    public Charset getUriEncoding() {
        return this.uriEncoding;
    }

    @Override
    public void setBackgroundProcessorDelay(int delay) {
        this.backgroundProcessorDelay = delay;
    }

    public int getStoreLicInfoInterval() {
        return this.storeLicInfoInterval;
    }

    public void setStoreLicInfoInterval(int storeLicInfoInterval) {
        this.storeLicInfoInterval = storeLicInfoInterval;
    }

    public Boolean getLoadClassLocally() {
        return this.loadClassLocally;
    }

    public void setLoadClassLocally(Boolean loadClassLocally) {
        this.loadClassLocally = loadClassLocally;
    }

    private static final class LoaderHidingWebResourceSet
    extends AbstractResourceSet {
        private final WebResourceSet delegate;
        private final Method initInternal;

        private LoaderHidingWebResourceSet(WebResourceSet delegate) {
            this.delegate = delegate;
            try {
                this.initInternal = LifecycleBase.class.getDeclaredMethod("initInternal", new Class[0]);
                this.initInternal.setAccessible(true);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }

        @Override
        public WebResource getResource(String path) {
            if (path.startsWith("/org/springframework/boot")) {
                return new EmptyResource(this.getRoot(), path);
            }
            return this.delegate.getResource(path);
        }

        @Override
        public String[] list(String path) {
            return this.delegate.list(path);
        }

        @Override
        public Set<String> listWebAppPaths(String path) {
            return this.delegate.listWebAppPaths(path);
        }

        @Override
        public boolean mkdir(String path) {
            return this.delegate.mkdir(path);
        }

        @Override
        public boolean write(String path, InputStream is, boolean overwrite) {
            return this.delegate.write(path, is, overwrite);
        }

        @Override
        public URL getBaseUrl() {
            return this.delegate.getBaseUrl();
        }

        @Override
        public void setReadOnly(boolean readOnly) {
            this.delegate.setReadOnly(readOnly);
        }

        @Override
        public boolean isReadOnly() {
            return this.delegate.isReadOnly();
        }

        @Override
        public void gc() {
            this.delegate.gc();
        }

        @Override
        protected void initInternal() throws LifecycleException {
            if (this.delegate instanceof LifecycleBase) {
                try {
                    ReflectionUtils.invokeMethod((Method)this.initInternal, (Object)this.delegate);
                }
                catch (Exception ex) {
                    throw new LifecycleException(ex);
                }
            }
        }
    }

    private static final class LoaderHidingResourceRoot
    extends StandardRoot {
        private LoaderHidingResourceRoot(BesEmbeddedContext context) {
            super(context);
        }

        @Override
        protected WebResourceSet createMainResourceSet() {
            return new LoaderHidingWebResourceSet(super.createMainResourceSet());
        }
    }

    private final class StaticResourceConfigurer
    implements LifecycleListener {
        private final Context context;

        private StaticResourceConfigurer(Context context) {
            this.context = context;
        }

        @Override
        public void lifecycleEvent(LifecycleEvent event) {
            if (event.getType().equals("configure_start")) {
                this.addResourceJars(BesServletWebServerFactory.this.getUrlsOfJarsWithMetaInfResources());
            }
        }

        private void addResourceJars(List<URL> resourceJarUrls) {
            for (URL url : resourceJarUrls) {
                String file = this.getOwnDecodedFile(url);
                if (file.endsWith(".jar") || file.endsWith(".jar!/")) {
                    String jar = url.toString();
                    if (!jar.startsWith("jar:")) {
                        jar = "jar:" + jar + "!/";
                    }
                    this.addResourceSet(jar);
                    continue;
                }
                this.addResourceSet(url.toString());
            }
        }

        private String getOwnDecodedFile(URL url) {
            try {
                return URLDecoder.decode(url.getFile(), "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException("Failed to decode '" + url.getFile() + "' using UTF-8");
            }
        }

        private void addResourceSet(String resource) {
            try {
                if (this.isInsideNestedJar(resource)) {
                    resource = resource.substring(0, resource.length() - 2);
                }
                URL url = new URL(resource);
                String path = "/META-INF/resources";
                this.context.getResources().createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", url, path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private boolean isInsideNestedJar(String dir) {
            return dir.indexOf("!/") < dir.lastIndexOf("!/");
        }
    }

    private static class DisablePersistSessionListener
    implements LifecycleListener {
        private DisablePersistSessionListener() {
        }

        @Override
        public void lifecycleEvent(LifecycleEvent event) {
            Context context;
            Manager manager;
            if (event.getType().equals("start") && (manager = (context = (Context)event.getLifecycle()).getManager()) != null && manager instanceof DefaultManager) {
                ((DefaultManager)manager).setPathname(null);
            }
        }
    }
}

