/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.springboot.embedded;

import com.bes.enterprise.naming.ContextBindings;
import com.bes.enterprise.springboot.embedded.BesEmbeddedContext;
import com.bes.enterprise.springboot.embedded.BesEmbeddedWebappClassLoader;
import com.bes.enterprise.springboot.embedded.BesStarter;
import com.bes.enterprise.springboot.embedded.ConnectorStartFailedException;
import com.bes.enterprise.springboot.embedded.EmbeddedLifecycle;
import com.bes.enterprise.web.Embedded;
import com.bes.enterprise.webtier.Container;
import com.bes.enterprise.webtier.Context;
import com.bes.enterprise.webtier.Engine;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.LifecycleState;
import com.bes.enterprise.webtier.Service;
import com.bes.enterprise.webtier.connector.Connector;
import com.bes.enterprise.webtier.core.DefaultContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.util.Assert;

public class BesWebServer
implements WebServer {
    private static final Log logger = LogFactory.getLog(BesWebServer.class);
    private static final AtomicInteger containerCounter = new AtomicInteger(-1);
    private final Object monitor = new Object();
    private final Map<Service, Connector[]> serviceConnectors = new HashMap<Service, Connector[]>();
    private final Embedded bes;
    private final boolean autoStart;
    private volatile boolean started;
    private final boolean useNaming;
    private final List<EmbeddedLifecycle> lifecycles = new ArrayList<EmbeddedLifecycle>();
    public static boolean checkedLic = false;

    public BesWebServer(Embedded bes) {
        this(bes, true, false);
    }

    public BesWebServer(Embedded bes, boolean autoStart, boolean useNaming) {
        Assert.notNull((Object)bes, (String)"BES Server must not be null");
        this.bes = bes;
        this.autoStart = autoStart;
        this.useNaming = useNaming;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws WebServerException {
        logger.info((Object)("BES initialized with port(s): " + this.getPortsDescription(false)));
        Object object = this.monitor;
        synchronized (object) {
            try {
                this.addInstanceIdToEngineName();
                Context context = this.findContext();
                context.addLifecycleListener(event -> {
                    if (context.equals(event.getSource()) && "start".equals(event.getType())) {
                        this.removeServiceConnectors();
                    }
                });
                if (this.useNaming || this.canLoadDataSource()) {
                    this.bes.enableNaming();
                }
                this.bes.start();
                this.rethrowDeferredStartupExceptions();
                try {
                    ContextBindings.bindClassLoader(context, context.getNamingToken(), this.getClass().getClassLoader());
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                this.startDaemonAwaitThread();
            }
            catch (Exception ex) {
                throw new WebServerException("Unable to start embedded Bes", (Throwable)ex);
            }
        }
    }

    private boolean canLoadDataSource() {
        ClassLoader classLoader = BesWebServer.class.getClassLoader();
        try {
            classLoader.loadClass("com.bes.enterprise.gjc.spi.BasicDataSource");
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
        return true;
    }

    public void addLifecycle(EmbeddedLifecycle lifecycle) {
        this.lifecycles.add(lifecycle);
    }

    private Context findContext() {
        for (Container child : this.bes.getHost().findChildren()) {
            if (!(child instanceof Context)) continue;
            return (Context)child;
        }
        throw new IllegalStateException("The host does not contain a Context");
    }

    private void addInstanceIdToEngineName() {
        int instanceId = containerCounter.incrementAndGet();
        if (instanceId > 0) {
            Engine engine = this.bes.getEngine();
            engine.setName(engine.getName() + "-" + instanceId);
        }
    }

    private void removeServiceConnectors() {
        for (Service service : this.bes.getServer().findServices()) {
            Connector[] connectors = (Connector[])service.findConnectors().clone();
            this.serviceConnectors.put(service, connectors);
            for (Connector connector : connectors) {
                service.removeConnector(connector);
            }
        }
    }

    private void rethrowDeferredStartupExceptions() throws Exception {
        Container[] children;
        for (Container container : children = this.bes.getHost().findChildren()) {
            Exception exception;
            BesStarter besStarter;
            if (container instanceof BesEmbeddedContext && (besStarter = ((BesEmbeddedContext)container).getStarter()) != null && (exception = besStarter.getStartUpException()) != null) {
                throw exception;
            }
            if (LifecycleState.STARTED.equals((Object)container.getState())) continue;
            throw new IllegalStateException(container + " failed to start");
        }
    }

    private void startDaemonAwaitThread() {
        Thread awaitThread = new Thread("container-" + containerCounter.get()){

            @Override
            public void run() {
                BesWebServer.this.bes.getServer().await();
            }
        };
        awaitThread.setContextClassLoader(this.getClass().getClassLoader());
        awaitThread.setDaemon(false);
        awaitThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws WebServerException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.started) {
                return;
            }
            try {
                this.addPreviouslyRemovedConnectors();
                Connector connector = this.bes.getConnector();
                if (connector != null && this.autoStart) {
                    this.startConnector();
                }
                for (EmbeddedLifecycle lifecycle : this.lifecycles) {
                    lifecycle.start();
                }
                this.checkThatConnectorsHaveStarted();
                this.started = true;
                logger.info((Object)("Server listening on port(s): " + this.getPortsDescription(true) + " with context path '" + this.getContextPath() + "'"));
            }
            catch (ConnectorStartFailedException ex) {
                this.stopSilently();
                throw ex;
            }
            catch (Exception ex) {
                throw new WebServerException("Unable to start BES server", (Throwable)ex);
            }
            finally {
                Context context = this.findContext();
                ContextBindings.unbindClassLoader(context, context.getNamingToken(), this.getClass().getClassLoader());
            }
        }
    }

    private void checkThatConnectorsHaveStarted() {
        for (Connector connector : this.bes.getService().findConnectors()) {
            if (!LifecycleState.FAILED.equals((Object)connector.getState())) continue;
            throw new ConnectorStartFailedException(connector.getPort());
        }
    }

    private void stopSilently() {
        try {
            this.stopBes();
        }
        catch (LifecycleException lifecycleException) {
            // empty catch block
        }
    }

    private void stopBes() throws LifecycleException {
        if (Thread.currentThread().getContextClassLoader() instanceof BesEmbeddedWebappClassLoader) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        }
        this.bes.stop();
    }

    private void addPreviouslyRemovedConnectors() {
        Service[] services;
        for (Service service : services = this.bes.getServer().findServices()) {
            Connector[] connectors = this.serviceConnectors.get(service);
            if (connectors == null) continue;
            for (Connector connector : connectors) {
                service.addConnector(connector);
                if (this.autoStart) continue;
                this.stopProtocolHandler(connector);
            }
            this.serviceConnectors.remove(service);
        }
    }

    private void stopProtocolHandler(Connector connector) {
        try {
            connector.getProtocolHandler().stop();
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot pause connector: ", (Throwable)ex);
        }
    }

    private void startConnector() {
        try {
            for (Container child : this.bes.getHost().findChildren()) {
                if (!(child instanceof BesEmbeddedContext)) continue;
                ((BesEmbeddedContext)child).deferredLoadOnStartup();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot start connector: ", (Throwable)ex);
            throw new WebServerException("Unable to start embedded BES connectors", (Throwable)ex);
        }
    }

    Map<Service, Connector[]> getServiceConnectors() {
        return this.serviceConnectors;
    }

    public void gracefulShutdownAbort() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws WebServerException {
        Object object = this.monitor;
        synchronized (object) {
            boolean wasStarted = this.started;
            try {
                this.started = false;
                try {
                    for (EmbeddedLifecycle lifecycle : this.lifecycles) {
                        lifecycle.stop();
                    }
                    this.gracefulShutdownAbort();
                    this.stopBes();
                    this.bes.destroy();
                }
                catch (LifecycleException lifecycleException) {
                    // empty catch block
                }
            }
            catch (Exception ex) {
                throw new WebServerException("Unable to stop embedded Bes", (Throwable)ex);
            }
            finally {
                if (wasStarted) {
                    containerCounter.decrementAndGet();
                }
            }
        }
    }

    private String getPortsDescription(boolean localPort) {
        StringBuilder ports = new StringBuilder();
        for (Connector connector : this.bes.getService().findConnectors()) {
            ports.append(ports.length() == 0 ? "" : " ");
            int port = localPort ? connector.getLocalPort() : connector.getPort();
            ports.append(port + " (" + connector.getScheme() + ")");
        }
        return ports.toString();
    }

    public int getPort() {
        Connector connector = this.bes.getConnector();
        if (connector != null) {
            return connector.getLocalPort();
        }
        return 0;
    }

    private String getContextPath() {
        return Arrays.stream(this.bes.getHost().findChildren()).filter(BesEmbeddedContext.class::isInstance).map(BesEmbeddedContext.class::cast).map(DefaultContext::getPath).collect(Collectors.joining(" "));
    }

    public Embedded getBes() {
        return this.bes;
    }
}

